package com.bizunited.platform.titan.starter.service.invoke.handle.request;

import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.invoke.InvokeRequestHandle;
import com.bizunited.platform.titan.starter.common.Constants;
import com.bizunited.platform.titan.starter.common.enums.TaskOperateBtn;
import com.bizunited.platform.titan.starter.service.ProcessTaskService;
import com.bizunited.platform.titan.starter.service.invoke.model.ProcessInputParamsModel;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

/**
 * 流程任务处理节点，用于在责任链中在处理表单数据之前处理流程的任务
 * @Author: Paul Chan
 * @Date: 2019-06-04 21:07
 */
@Component("ProcessInstanceHandle")
public class ProcessInstanceHandle implements InvokeRequestHandle {

  private final static Logger LOGGER = LoggerFactory.getLogger(ProcessInstanceHandle.class);

  @Autowired
  private ProcessTaskService processTaskService;

  @Override
  public void doHandle(InvokeProxyContext context, HandleChain chain) throws InvokeProxyException {
    if(!context.isException()){
      // 取当前操作者信息
      SecurityContext securityContext = SecurityContextHolder.getContext();
      Validate.notNull(securityContext , "未发现任何用户权限信息!!");
      Authentication authentication = securityContext.getAuthentication();
      Validate.notNull(authentication , "未发现任何用户登录信息!!");

      // 操作流程任务
      ProcessInputParamsModel model = (ProcessInputParamsModel) context.getChainParam(ProcessInputParamsModel.class.getName());
      Validate.notNull(model , "错误的入参模型对象，请检查!!");
      Validate.notBlank(model.getBtn(), "btn参数不能为空");
      TaskOperateBtn btn = Constants.TASK_OPERATION_BTN_MAP.get(model.getBtn());
      Validate.notNull(btn, "不支持的操作：%s", model.getBtn());
      switch (btn){
        case BTN_001:
          processTaskService.handleComplete(model.getTaskId(), authentication, model.getContent(), model.getVariables());
          break;
        case BTN_002:
          processTaskService.handleReject(model.getTaskId(), authentication, model.getContent(), model.getVariables());
          break;
        case BTN_003:
          processTaskService.handleBackTask(model.getTaskId(), model.getTargetActivitiId(), authentication, model.getContent(), model.getVariables());
          break;
        case BTN_004:
          processTaskService.handleRetrieve(model.getProcessInstanceId(), model.getActivityId(), authentication);
          break;
        case BTN_011:
          processTaskService.handleSubmitForm(model.getProcessInstanceId(), authentication, model.getVariables());
          break;
        case BTN_012:
          processTaskService.handleCancel(model.getProcessInstanceId(), authentication, model.getContent(), model.getVariables());
          break;
        case BTN_013:
          processTaskService.handleStop(model.getTaskId(), authentication, model.getContent());
          break;
        default:
          LOGGER.error(String.format("不支持的操作：%s", btn.getBtn()));
          throw new UnsupportedOperationException(String.format("不支持的操作：%s", btn.getBtn()));
      }
    }
    chain.doHandle(context, HandleChain.ChainLogic.CONTINUE);
  }

}
