package com.bizunited.platform.titan.starter.service.invoke.handle.request;

import com.bizunited.platform.core.entity.ScriptEntity;
import com.bizunited.platform.core.service.ScriptService;
import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.invoke.InvokeRequestHandle;
import com.bizunited.platform.titan.entity.ProcessVariableEntity;
import org.apache.commons.lang3.Validate;
import org.flowable.task.service.delegate.DelegateTask;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * 处理任务监听器的脚本handle
 * @Author: Paul Chan
 * @Date: 2019-06-14 16:49
 */
public class TaskScriptListenerHandle extends AbstractScriptListenerHandle implements InvokeRequestHandle {

  private ScriptEntity script;
  private DelegateTask delegateTask;
  private ScriptService scriptService;
  private Set<ProcessVariableEntity> variables;

  public TaskScriptListenerHandle(ScriptEntity script, DelegateTask delegateTask, ScriptService scriptService, Set<ProcessVariableEntity> variables){
    this.script = script;
    this.delegateTask = delegateTask;
    this.variables = variables;
    this.scriptService = scriptService;
  }

  @Override
  public void doHandle(InvokeProxyContext context, HandleChain chain) throws InvokeProxyException {
    Validate.notNull(script, "执行脚本不能为空");
    super.setVariables(delegateTask, variables);
    Map<String, Object> params = new HashMap<>(4);
    params.put("delegateTask", delegateTask);
    super.putFlowableService(params);
    Map<String, Object> returnResults = this.scriptService.invoke(script.getId(), params);
    if(returnResults != null && !returnResults.isEmpty()) {
      context.setChainParams(returnResults);
    }
    chain.doHandle(context, HandleChain.ChainLogic.CONTINUE);
  }
}