package com.bizunited.platform.titan.starter.service.invoke.handle.response;

import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.invoke.InvokeResponseHandle;
import org.springframework.stereotype.Component;

/**
 * 监听器执行的结果处理，实际上不需要处理，所以这是一个空的处理节点
 * @Author: Paul Chan
 * @Date: 2019-06-14 14:37
 */
@Component("ListenerResponseHandle")
public class ListenerResponseHandle implements InvokeResponseHandle {

  @Override
  public boolean handleException(InvokeProxyContext context) {
    return false;
  }

  @Override
  public void doHandle(InvokeProxyContext context, HandleChain chain) throws InvokeProxyException {
    if(context.isException()) {
      chain.doHandle(context, HandleChain.ChainLogic.BREAK);
    }
    chain.doHandle(context, HandleChain.ChainLogic.CONTINUE);
  }
}
