package com.bizunited.platform.titan.starter.service.invoke.model;

import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.Map;
import java.util.Set;

/**
 * @author yinwenjie
 */
public class InputParams {
  /**
   * 脚本id
   */
  private String[] scriptIds;
  /**
   * 入参
   */
  private Map<String, Object> params;

  /**
   * 操作人
   */
  private String operator;

  /**
   * 当前时间
   */
  private Date currentTime;

  public String[] getScriptIds() {
    return scriptIds;
  }

  public void setScriptIds(String[] scriptIds) {
    this.scriptIds = scriptIds;
  }

  public void setParams(String key , Object value) {
    if(StringUtils.isEmpty(key)){
      return;
    }
    this.params.put(key,value);
  }

  public Object getParams(String key) {
    if(StringUtils.isEmpty(key)){
      return null;
    }
    return this.params.get(key);
  }

  public Set<String> keySet(){
    return this.params.keySet();
  }

  public String getOperator() {
    return operator;
  }

  public void setOperator(String operator) {
    this.operator = operator;
  }

  public Date getCurrentTime() {
    return currentTime;
  }

  public void setCurrentTime(Date currentTime) {
    this.currentTime = currentTime;
  }

  public Set<String> getKeys() {
    return this.params.keySet();
  }
}
