package com.bizunited.platform.titan.starter.service.invoke.model;

import com.bizunited.platform.core.service.serviceable.model.InputParamsModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 流程任务进参
 * @Author: Paul Chan
 * @Date: 2019-06-04 21:19
 */
public class ProcessInputParamsModel implements Serializable {

  private static final long serialVersionUID = -5639947767264948489L;

  /**
   * 按钮，目前支持按钮有BTN_001(审批通过),BTN_002(驳回),BTN_003(回退),BTN_004(取回)
   * BTN_011(提交),BTN_012(撤销),BTN_013(终止)
   *
   */
  @ApiModelProperty(value = "按钮，目前支持按钮有BTN_001(审批通过),BTN_002(驳回),BTN_003(回退),BTN_004(取回),BTN_011(提交),BTN_012(撤销),BTN_013(终止)")
  private String btn;

  /**
   * 流程实例ID
   */
  @ApiModelProperty(value = "流程实例ID")
  private String processInstanceId;

  /**
   * 任务ID
   */
  @ApiModelProperty(value = "任务ID")
  private String taskId;

  /**
   * 活动ID，也是用户任务的taskKey
   */
  @ApiModelProperty(value = "活动ID，也是用户任务的taskKey")
  private String activityId;

  /**
   * 目标活动ID，也是用户任务的taskKey
   */
  @ApiModelProperty(value = "目标活动ID，也是用户任务的taskKey")
  private String targetActivitiId;

  /**
   * 目标任务人
   */
  @ApiModelProperty(value = "目标任务人")
  private String targetAssignment;

  /**
   * 任务人集合
   */
  @ApiModelProperty(value = "任务人集合")
  private List<String> assignments;

  /**
   * 审批内容
   */
  @ApiModelProperty(value = "审批内容")
  private String content;

  /**
   * 流程变量
   */
  @ApiModelProperty(value = "流程变量")
  private Map<String, Object> variables;

  /**
   * 表单实例ID
   */
  private String formInstanceId;

  /**
   * 表单更新参数
   */
  @ApiModelProperty(value = "表单更新参数")
  private InputParamsModel inputParamsModel;


  public String getBtn() {
    return btn;
  }

  public void setBtn(String btn) {
    this.btn = btn;
  }

  public String getProcessInstanceId() {
    return processInstanceId;
  }

  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = processInstanceId;
  }

  public String getTaskId() {
    return taskId;
  }

  public void setTaskId(String taskId) {
    this.taskId = taskId;
  }

  public String getActivityId() {
    return activityId;
  }

  public void setActivityId(String activityId) {
    this.activityId = activityId;
  }

  public String getTargetActivitiId() {
    return targetActivitiId;
  }

  public void setTargetActivitiId(String targetActivitiId) {
    this.targetActivitiId = targetActivitiId;
  }

  public String getTargetAssignment() {
    return targetAssignment;
  }

  public void setTargetAssignment(String targetAssignment) {
    this.targetAssignment = targetAssignment;
  }

  public List<String> getAssignments() {
    return assignments;
  }

  public void setAssignments(List<String> assignments) {
    this.assignments = assignments;
  }

  public String getContent() {
    return content;
  }

  public void setContent(String content) {
    this.content = content;
  }

  public Map<String, Object> getVariables() {
    return variables;
  }

  public void setVariables(Map<String, Object> variables) {
    this.variables = variables;
  }

  public InputParamsModel getInputParamsModel() {
    return inputParamsModel;
  }

  public String getFormInstanceId() {
    return formInstanceId;
  }

  public void setFormInstanceId(String formInstanceId) {
    this.formInstanceId = formInstanceId;
  }

  public void setInputParamsModel(InputParamsModel inputParamsModel) {
    this.inputParamsModel = inputParamsModel;
  }
}
