/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.controller;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.titan.starter.entity.ProcessListenerEntity;
import com.bizunited.platform.titan.starter.service.ProcessListenerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"v1/titan/listeners"})
@Api(tags={"\u6d41\u7a0b\u76d1\u542c\u5668\u529f\u80fd\u4e1a\u52a1\u6a21\u578b\u7684MVC Controller\u5c42\u5b9e\u73b0"})
public class ProcessListenerController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessListenerController.class);
    @Autowired
    private ProcessListenerService processListenerService;

    @PostMapping(value={""})
    @ApiOperation(value="\u521b\u5efa\u6d41\u7a0b\u76d1\u542c\u5668")
    public ResponseModel create(@RequestBody ProcessListenerEntity processListener) {
        try {
            processListener = this.processListenerService.create(processListener);
            return this.buildHttpResultW((Object)processListener, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PatchMapping(value={""})
    @ApiOperation(value="\u66f4\u65b0\u6d41\u7a0b\u76d1\u542c\u5668")
    public ResponseModel update(@RequestBody ProcessListenerEntity processListener) {
        try {
            processListener = this.processListenerService.update(processListener);
            return this.buildHttpResultW((Object)processListener, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PatchMapping(value={"/handleState"})
    @ApiOperation(value="\u5207\u6362\u72b6\u6001")
    public ResponseModel handleState(@RequestParam(value="id") @ApiParam(value="ID", required=true) String id, @RequestParam(value="state") @ApiParam(value="\u72b6\u6001\uff1a0=\u7981\u75281=\u542f\u7528", required=true) Integer state) {
        try {
            this.processListenerService.handleState(id, state);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByConditions"})
    @ApiOperation(value="\u6761\u4ef6\u67e5\u8be2\u76d1\u542c\u5668")
    public ResponseModel findByConditions(@ApiParam(value="\u67e5\u8be2\u6761\u4ef6\u8f7d\u4f53") ProcessListenerEntity processListener, @PageableDefault(value=50) Pageable pageable) {
        try {
            Page<ProcessListenerEntity> page = this.processListenerService.findByConditions(processListener, pageable);
            return this.buildHttpResultW((Iterable)page, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

