/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.controller;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateNodePermissionEntity;
import com.bizunited.platform.titan.starter.service.ProcessTemplateNodePermissionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6d41\u7a0b\u6a21\u7248\u8282\u70b9\u64cd\u4f5c\u6743\u9650\u529f\u80fd\u4e1a\u52a1\u6a21\u578b\u7684MVC Controller\u5c42\u5b9e\u73b0"})
@RestController
@RequestMapping(value={"v1/titan/template/node/permissions"})
public class ProcessTemplateNodePermissionController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessTemplateNodePermissionController.class);
    @Autowired
    private ProcessTemplateNodePermissionService processTemplateNodePermissionService;

    @GetMapping(value={"findByConditions"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6d41\u7a0b\u6a21\u7248\u8282\u70b9\u64cd\u4f5c\u6743\u9650", notes="\u9875\u6570\u53c2\u6570\u4e3apage\uff0c\u7b2c\u4e00\u9875\u4ece0\u5f00\u59cb\uff0c\u5206\u9875\u5927\u5c0f\u53c2\u6570\u4e3asize\uff08size\u9ed8\u8ba4\u4e3a50\uff09")
    public ResponseModel findByConditions(@PageableDefault(value=50) Pageable pageable, @ApiParam(value="\u64cd\u4f5c\u7f16\u7801") @RequestParam(value="operateCode", required=false) String operateCode, @ApiParam(value="\u64cd\u4f5c\u540d\u79f0") @RequestParam(value="operateName", required=false) String operateName) {
        try {
            ProcessTemplateNodePermissionEntity nodePermission = new ProcessTemplateNodePermissionEntity();
            nodePermission.setOperateCode(operateCode);
            nodePermission.setOperateName(operateName);
            Page<ProcessTemplateNodePermissionEntity> page = this.processTemplateNodePermissionService.findByConditions(nodePermission, pageable);
            return this.buildHttpResultW((Iterable)page, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PostMapping(value={""})
    @ApiOperation(value="\u521b\u5efa\u8282\u70b9\u64cd\u4f5c\u6743\u9650")
    public ResponseModel create(@RequestBody ProcessTemplateNodePermissionEntity nodePermission) {
        try {
            Principal principal = this.getPrincipal();
            ProcessTemplateNodePermissionEntity nodePermissionEntity = this.processTemplateNodePermissionService.create(nodePermission, principal);
            return this.buildHttpResultW((Object)nodePermissionEntity, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PatchMapping(value={""})
    @ApiOperation(value="\u66f4\u65b0\u8282\u70b9\u64cd\u4f5c\u6743\u9650")
    public ResponseModel update(@RequestBody ProcessTemplateNodePermissionEntity nodePermission) {
        try {
            Principal principal = this.getPrincipal();
            ProcessTemplateNodePermissionEntity nodePermissionEntity = this.processTemplateNodePermissionService.update(nodePermission, principal);
            return this.buildHttpResultW((Object)nodePermissionEntity, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

