/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.service.internal;

import com.bizunited.platform.rbac.server.vo.UserVo;
import com.bizunited.platform.titan.starter.common.enums.TaskOperateBtn;
import com.bizunited.platform.titan.starter.entity.ProcessAssignmentEntity;
import com.bizunited.platform.titan.starter.entity.ProcessCarbonCopyEntity;
import com.bizunited.platform.titan.starter.entity.ProcessInstanceEntity;
import com.bizunited.platform.titan.starter.repository.ProcessCarbonCopyRepository;
import com.bizunited.platform.titan.starter.service.ProcessAssignmentService;
import com.bizunited.platform.titan.starter.service.ProcessCarbonCopyService;
import com.bizunited.platform.titan.starter.service.ProcessInstanceOperateRecordService;
import com.bizunited.platform.titan.starter.service.ProcessInstanceService;
import com.bizunited.platform.titan.starter.service.internal.BaseService;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.flowable.task.api.Task;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="ProcessCarbonCopyServiceImpl")
public class ProcessCarbonCopyServiceImpl
extends BaseService
implements ProcessCarbonCopyService {
    @Autowired
    private ProcessCarbonCopyRepository processCarbonCopyRepository;
    @Autowired
    private ProcessInstanceService processInstanceService;
    @Autowired
    private ProcessAssignmentService processAssignmentService;
    @Autowired
    private ProcessInstanceOperateRecordService processInstanceOperateRecordService;

    @Override
    public List<ProcessCarbonCopyEntity> create(Task task, ProcessInstanceEntity processInstance, UserVo ccUser, List<String> assignments) {
        Validate.notEmpty(assignments, (String)"\u4efb\u52a1\u6284\u9001\u63a5\u6536\u4eba\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.processAssignmentService.valid(assignments);
        ArrayList<ProcessCarbonCopyEntity> carbonCopies = new ArrayList<ProcessCarbonCopyEntity>(assignments.size());
        StringBuilder content = new StringBuilder("\u6284\u9001\u6d41\u7a0b\u4efb\u52a1\u7ed9\u7528\u6237\u3010");
        HashSet<String> assignmentsSet = new HashSet<String>();
        for (int i = 0; i < assignments.size(); ++i) {
            String assignment = assignments.get(i);
            Validate.notBlank((CharSequence)assignment, (String)"\u4efb\u52a1\u6284\u9001\u63a5\u6536\u4eba\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((!assignmentsSet.contains(assignment) ? 1 : 0) != 0, (String)"\u6709\u91cd\u590d\u7684\u6284\u9001\u4eba:%s", (Object[])new Object[]{assignment});
            Validate.isTrue((!this.processAssignmentService.equals(ccUser, assignment) ? 1 : 0) != 0, (String)"\u4e0d\u80fd\u6284\u9001\u7ed9\u4efb\u52a1\u4eba\u81ea\u5df1", (Object[])new Object[0]);
            assignmentsSet.add(assignment);
            Long count = this.processCarbonCopyRepository.countByTaskIdAndAssignment(task.getId(), assignment);
            Validate.isTrue((count == null || count < 1L ? 1 : 0) != 0, (String)"\u7528\u6237\u3010%s\u3011\u5df2\u6284\u9001\u8fc7\uff0c\u8bf7\u52ff\u91cd\u590d\u6284\u9001", (Object[])new Object[]{assignment});
            ProcessCarbonCopyEntity carbonCopy = new ProcessCarbonCopyEntity();
            carbonCopy.setCcAccount(ccUser.getAccount());
            carbonCopy.setCcUser(ccUser);
            carbonCopy.setCreateTime(new Date());
            carbonCopy.setProcessInstance(processInstance);
            carbonCopy.setState(0);
            carbonCopy.setTaskDefId(task.getTaskDefinitionKey());
            carbonCopy.setTaskId(task.getId());
            this.processCarbonCopyRepository.save((Object)carbonCopy);
            ProcessAssignmentEntity assignmentEntity = this.processAssignmentService.save(carbonCopy.getId(), assignment);
            carbonCopy.setReceiveAssignment(assignmentEntity);
            carbonCopies.add(carbonCopy);
            if (i > 0) {
                content.append("\uff0c");
            }
            content.append(assignmentEntity.getAssignmentName());
        }
        content.append("\u3011");
        this.processCarbonCopyRepository.saveAll(carbonCopies);
        this.processInstanceOperateRecordService.create(task, processInstance, ccUser, TaskOperateBtn.BTN_006, content.toString());
        return carbonCopies;
    }

    @Override
    public Page<ProcessCarbonCopyEntity> findMyByConditions(Pageable pageable, Principal principal, ProcessCarbonCopyEntity carbonCopy) {
        UserVo user = super.getLoginUser(principal);
        UserVo userVo = this.userService.findDetailsById(user.getId());
        Page page = this.processCarbonCopyRepository.findMyByConditions(pageable, carbonCopy, userVo);
        this.loadUser(page.getContent());
        return page;
    }

    private void loadUser(List<ProcessCarbonCopyEntity> carbonCopies) {
        if (CollectionUtils.isEmpty(carbonCopies)) {
            return;
        }
        for (ProcessCarbonCopyEntity carbonCopy : carbonCopies) {
            UserVo user = super.getUserByAccount(carbonCopy.getCcAccount());
            carbonCopy.setCcUser(user);
            this.processInstanceService.loadUser(carbonCopy.getProcessInstance());
        }
    }

    @Override
    @Transactional
    public void read(String id, Principal principal) {
        Validate.notBlank((CharSequence)id, (String)"\u6284\u9001ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        UserVo user = this.getLoginUser(principal);
        ProcessCarbonCopyEntity carbonCopy = this.processCarbonCopyRepository.findDetailById(id);
        Validate.notNull((Object)((Object)carbonCopy), (String)"\u672a\u627e\u5230\u6284\u9001\u4fe1\u606f\u5bf9\u8c61", (Object[])new Object[0]);
        Validate.isTrue((boolean)this.processAssignmentService.equals(user, carbonCopy.getReceiveAssignment().getAssignment()), (String)"\u9605\u8bfb\u5931\u8d25\uff0c\u5f53\u524d\u6284\u9001\u4efb\u52a1\u4e0d\u5c5e\u4e8e\u5f53\u524d\u7528\u6237", (Object[])new Object[0]);
        if (carbonCopy.getState().equals(0)) {
            carbonCopy.setState(1);
            carbonCopy.setReadTime(new Date());
            this.processCarbonCopyRepository.save((Object)carbonCopy);
        }
    }
}

