/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.service.internal;

import com.bizunited.platform.titan.starter.entity.ProcessCheckRecordEntity;
import com.bizunited.platform.titan.starter.entity.ProcessCheckRecordItemEntity;
import com.bizunited.platform.titan.starter.repository.ProcessCheckRecordItemRepository;
import com.bizunited.platform.titan.starter.service.ProcessCheckRecordItemService;
import java.util.Date;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="ProcessCheckRecordItemServiceImpl")
public class ProcessCheckRecordItemServiceImpl
implements ProcessCheckRecordItemService {
    @Autowired
    private ProcessCheckRecordItemRepository processCheckRecordItemRepository;

    private void createValidation(Set<ProcessCheckRecordItemEntity> items) {
        if (!CollectionUtils.isEmpty(items)) {
            for (ProcessCheckRecordItemEntity item : items) {
                Validate.notBlank((CharSequence)item.getCheckType(), (String)"\u68c0\u6d4b\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)item.getNodeKey(), (String)"\u8282\u70b9key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)item.getNodeName(), (String)"\u8282\u70b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)item.getResult(), (String)"\u68c0\u6d4b\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)item.getTaskId(), (String)"\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notNull((Object)item.getState(), (String)"\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            }
        }
    }

    @Override
    @Transactional
    public Set<ProcessCheckRecordItemEntity> create(ProcessCheckRecordEntity record, Set<ProcessCheckRecordItemEntity> items) {
        Validate.notNull((Object)((Object)record), (String)"\u68c0\u6d4b\u8bb0\u5f55\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.createValidation(items);
        if (!CollectionUtils.isEmpty(items)) {
            for (ProcessCheckRecordItemEntity item : items) {
                item.setProcessCheckRecord(record);
                item.setCreateTime(new Date());
                this.processCheckRecordItemRepository.save((Object)item);
            }
        }
        return items;
    }

    @Override
    @Transactional
    public void deleteByRecordId(String recordId) {
        Validate.notBlank((CharSequence)recordId, (String)"\u8bb0\u5f55ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Set<ProcessCheckRecordItemEntity> items = this.processCheckRecordItemRepository.findByRecordId(recordId);
        if (!CollectionUtils.isEmpty(items)) {
            this.processCheckRecordItemRepository.deleteAll(items);
        }
    }
}

