/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.service.internal;

import com.alibaba.fastjson.JSON;
import com.bizunited.platform.rbac.server.vo.UserVo;
import com.bizunited.platform.titan.starter.entity.ProcessAssignmentEntity;
import com.bizunited.platform.titan.starter.entity.ProcessCheckRecordEntity;
import com.bizunited.platform.titan.starter.entity.ProcessCheckRecordItemEntity;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateEntity;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateNodeEntity;
import com.bizunited.platform.titan.starter.repository.ProcessCheckRecordRepository;
import com.bizunited.platform.titan.starter.repository.ProcessTemplateRepository;
import com.bizunited.platform.titan.starter.service.ProcessAssignmentService;
import com.bizunited.platform.titan.starter.service.ProcessCheckRecordItemService;
import com.bizunited.platform.titan.starter.service.ProcessCheckRecordService;
import com.bizunited.platform.titan.starter.service.ProcessInstanceService;
import com.bizunited.platform.titan.starter.service.ProcessTemplateNodeService;
import com.bizunited.platform.titan.starter.service.ProcessTemplateService;
import com.bizunited.platform.titan.starter.service.internal.BaseService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.security.Principal;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.UserTask;
import org.flowable.engine.HistoryService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="ProcessCheckRecordServiceImpl")
public class ProcessCheckRecordServiceImpl
extends BaseService
implements ProcessCheckRecordService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessCheckRecordServiceImpl.class);
    @Autowired
    private ProcessTemplateRepository processTemplateRepository;
    @Autowired
    private ProcessCheckRecordRepository processCheckRecordRepository;
    private ProcessCheckRecordService proxySelf;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private TaskService taskService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ProcessTemplateService processTemplateService;
    @Autowired
    private ProcessInstanceService processInstanceService;
    @Autowired
    private ProcessAssignmentService processAssignmentService;
    @Autowired
    private ProcessTemplateNodeService processTemplateNodeService;
    @Autowired
    private ProcessCheckRecordItemService processCheckRecordItemService;

    @PostConstruct
    public void setProxySelf() {
        this.proxySelf = (ProcessCheckRecordService)this.applicationContext.getBean(ProcessCheckRecordService.class);
    }

    @Override
    @Transactional
    public ProcessCheckRecordEntity checkProcess(String templateId, String assignment, Map<String, Object> variables, Principal principal) {
        Validate.notBlank((CharSequence)templateId, (String)"\u6a21\u7248ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull(variables, (String)"\u53d8\u91cf\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.processAssignmentService.valid(assignment);
        variables.put("applicantUser", assignment);
        UserVo user = this.getLoginUser(principal);
        ProcessTemplateEntity template = this.processTemplateService.findById(templateId);
        Validate.notNull((Object)((Object)template), (String)"\u672a\u627e\u5230\u6d41\u7a0b\u6a21\u7248\u5bf9\u8c61", (Object[])new Object[0]);
        ProcessCheckRecordEntity record = new ProcessCheckRecordEntity();
        String processDefinitionId = template.getProcessDefinitionId();
        try {
            this.proxySelf.checkProcess(template, record, variables);
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
        template.setProcessDefinitionId(processDefinitionId);
        record.setCreateUser(user);
        record.setCreateAccount(user.getAccount());
        record.setCreateTime(new Date());
        record.setProcessTemplate(template);
        this.processCheckRecordRepository.save((Object)record);
        Set<ProcessCheckRecordItemEntity> items = this.processCheckRecordItemService.create(record, record.getProcessCheckRecordItems());
        record.setProcessCheckRecordItems(items);
        return record;
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public void checkProcess(ProcessTemplateEntity template, ProcessCheckRecordEntity record, Map<String, Object> variables) {
        ProcessInstance processInstance;
        BpmnModel bpmn = this.processTemplateService.findBpmnById(template.getId());
        Validate.notNull((Object)bpmn, (String)"\u672a\u627e\u5230\u6d41\u7a0b\u5b9a\u4e49\u5bf9\u8c61", (Object[])new Object[0]);
        Process process = (Process)bpmn.getProcesses().get(0);
        String processId = process.getId();
        record.setParams(JSON.toJSONString(variables));
        record.setProcessDefId(processId);
        record.setProcessTemplate(template);
        record.setTestProcessDefId(processId);
        record.setTitle(StringUtils.join((Object[])new String[]{template.getProcessName(), "_\u68c0\u6d4b\u62a5\u544a"}));
        try {
            ProcessDefinition processDefinition = this.deploy(bpmn, template);
            processInstance = this.startProcess(template, processDefinition.getId(), variables);
        }
        catch (Exception e) {
            record.setState(2);
            record.setResult(String.format("\u6a21\u7248\u683c\u5f0f\u9519\u8bef\uff1a%s", e.getMessage()));
            return;
        }
        boolean haveException = false;
        long startTime = System.nanoTime();
        try {
            this.complete(template, processInstance, record);
        }
        catch (Exception e) {
            haveException = true;
        }
        long endTime = System.nanoTime();
        boolean processEnd = this.isProcessEnd(processInstance.getProcessInstanceId());
        if (haveException) {
            record.setState(2);
        } else if (processEnd) {
            record.setState(1);
        } else {
            record.setState(0);
        }
        record.setProcessInstanceId(processInstance.getId());
        this.initRecordResult(process, record, (endTime - startTime) / 1000000L);
        throw new AbortCompilation();
    }

    @Override
    public List<ProcessCheckRecordEntity> findByTemplateId(String templateId) {
        if (StringUtils.isBlank((CharSequence)templateId)) {
            return Lists.newArrayList();
        }
        return this.processCheckRecordRepository.findByTemplateId(templateId);
    }

    @Override
    public ProcessCheckRecordEntity findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ProcessCheckRecordEntity record = this.processCheckRecordRepository.findDetailById(id);
        this.loadUser(record);
        return record;
    }

    private void loadUser(ProcessCheckRecordEntity record) {
        if (record == null) {
            return;
        }
        UserVo user = super.getUserByAccount(record.getCreateAccount());
        record.setCreateUser(user);
    }

    @Override
    @Transactional
    public void deleteByTemplateId(String templateId) {
        Validate.notBlank((CharSequence)templateId, (String)"\u6a21\u7248ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<ProcessCheckRecordEntity> records = this.processCheckRecordRepository.findByTemplateId(templateId);
        if (CollectionUtils.isEmpty(records)) {
            return;
        }
        for (ProcessCheckRecordEntity record : records) {
            this.processCheckRecordItemService.deleteByRecordId(record.getId());
            this.processCheckRecordRepository.delete((Object)record);
        }
    }

    private void initRecordResult(Process process, ProcessCheckRecordEntity record, long time) {
        StringBuilder result = new StringBuilder("\u672c\u6b21\u68c0\u6d4b\u5171\u8017\u65f6<span style=\"color:green;font-weight: bolder;\">");
        result.append((double)time / 1000.0).append("</span>\u79d2,\u5b8c\u6210\u5ea6<span style=\"color:green;font-weight: bolder;\">");
        int[] completeness = this.calculateCompleteness(process, record);
        result.append(completeness[0]).append("%</span>\uff0c\u6210\u529f<span style=\"color:green;font-weight: bolder;\">");
        result.append(completeness[1]).append("</span>\u9879\uff0c\u5931\u8d25<span style=\"color:red;font-weight: bolder;\">");
        int failed = completeness[2] - completeness[1];
        if (record.getState() == 1) {
            failed = 0;
        }
        result.append(failed).append("</span>\u9879");
        record.setResult(result.toString());
    }

    private int[] calculateCompleteness(Process process, ProcessCheckRecordEntity record) {
        int competedTasks = 0;
        HashSet<String> taskDefKeys = new HashSet<String>();
        int totalTasks = process.getFlowElements().stream().filter(e -> e instanceof UserTask).collect(Collectors.toList()).size();
        Set<ProcessCheckRecordItemEntity> items = record.getProcessCheckRecordItems();
        if (!CollectionUtils.isEmpty(items)) {
            for (ProcessCheckRecordItemEntity item : items) {
                if (taskDefKeys.contains(item.getNodeKey())) continue;
                if (item.getState().equals(1)) {
                    ++competedTasks;
                }
                taskDefKeys.add(item.getNodeKey());
            }
        }
        int completeness = new BigDecimal(competedTasks).divide(new BigDecimal(totalTasks), 2, 5).multiply(new BigDecimal(100)).intValue();
        if (record.getState() == 1) {
            completeness = 100;
        }
        return new int[]{completeness, competedTasks, totalTasks};
    }

    private void complete(ProcessTemplateEntity template, ProcessInstance processInstance, ProcessCheckRecordEntity record) {
        if (this.isProcessEnd(processInstance.getProcessInstanceId())) {
            return;
        }
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstance.getProcessInstanceId())).list();
        if (CollectionUtils.isEmpty((Collection)tasks)) {
            return;
        }
        for (Task task : tasks) {
            TaskQuery taskQuery = this.taskService.createTaskQuery();
            task = (Task)((TaskQuery)taskQuery.taskId(task.getId())).singleResult();
            if (task == null) continue;
            StringBuilder result = new StringBuilder("<p>\u5f00\u59cb\u5ba1\u6279\u6d41\u7a0b\u8282\u70b9\uff1a");
            result.append(task.getName()).append("</p>");
            result.append("<p>\u8282\u70b9\u5ba1\u6279\u4eba\uff1a").append(task.getAssignee()).append("</p>");
            ProcessTemplateNodeEntity node = this.processTemplateNodeService.findByProcessTemplateIdAndProcessNodeId(template.getId(), task.getTaskDefinitionKey());
            if (node == null) {
                result.append("<p>\u672a\u627e\u5230\u6d41\u7a0b\u8282\u70b9\u7684\u914d\u7f6e\u4fe1\u606f</p>");
                this.addItem(record, this.initRecordItem(task, result.toString(), 2));
                throw new IllegalArgumentException("\u672a\u627e\u5230\u6d41\u7a0b\u8282\u70b9\u7684\u914d\u7f6e\u4fe1\u606f");
            }
            if (StringUtils.isBlank((CharSequence)task.getAssignee())) {
                if (!node.getNullSkip().booleanValue()) {
                    result.append("<p>\u6d41\u7a0b\u8282\u70b9\u672a\u627e\u5230\u5ba1\u6279\u4eba</p>");
                    this.addItem(record, this.initRecordItem(task, result.toString(), 2));
                    throw new IllegalArgumentException("\u6d41\u7a0b\u8282\u70b9\u672a\u627e\u5230\u5ba1\u6279\u4eba");
                }
                result.append("<p>\u5ba1\u6279\u4eba\u4e3a\u7a7a\uff0c\u6839\u636e\u8282\u70b9\u914d\u7f6e\u81ea\u52a8\u8df3\u8fc7</p>");
            } else {
                ProcessAssignmentEntity assignment;
                try {
                    assignment = this.processAssignmentService.findAssignment(task.getAssignee());
                }
                catch (Exception e) {
                    result.append("<p>\u6d41\u7a0b\u8282\u70b9\u5ba1\u6279\u4eba\u9519\u8bef\uff1a").append(e.getMessage()).append("</p>");
                    this.addItem(record, this.initRecordItem(task, result.toString(), 2));
                    throw new IllegalArgumentException(String.format("\u6d41\u7a0b\u8282\u70b9\u5ba1\u6279\u4eba\u9519\u8bef\uff1a%s", e.getMessage()));
                }
                if (assignment == null) {
                    result.append("<p>\u6d41\u7a0b\u8282\u70b9\u5ba1\u6279\u4eba\u9519\u8bef,\u672a\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237\u6216\u5c97\u4f4d\uff1a").append(task.getAssignee()).append("</p>");
                    this.addItem(record, this.initRecordItem(task, result.toString(), 2));
                    throw new IllegalArgumentException(String.format("\u6d41\u7a0b\u8282\u70b9\u5ba1\u6279\u4eba\u9519\u8bef,\u672a\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237\u6216\u5c97\u4f4d\uff1a%s", task.getAssignee()));
                }
            }
            try {
                this.taskService.complete(task.getId());
            }
            catch (Exception e) {
                result.append("<p>\u6d41\u7a0b\u8282\u70b9\u5ba1\u6279\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a").append(e.getMessage()).append("</p>");
                this.addItem(record, this.initRecordItem(task, result.toString(), 2));
                throw e;
            }
            this.addItem(record, this.initRecordItem(task, result.toString(), 1));
        }
        this.complete(template, processInstance, record);
    }

    private void addItem(ProcessCheckRecordEntity record, ProcessCheckRecordItemEntity item) {
        Set<ProcessCheckRecordItemEntity> items = record.getProcessCheckRecordItems();
        if (items == null) {
            items = new LinkedHashSet<ProcessCheckRecordItemEntity>();
        }
        items.add(item);
        record.setProcessCheckRecordItems(items);
    }

    private ProcessCheckRecordItemEntity initRecordItem(Task task, String result, Integer state) {
        ProcessCheckRecordItemEntity item = new ProcessCheckRecordItemEntity();
        item.setCheckType("PASS");
        item.setCreateTime(new Date());
        item.setNodeKey(task.getTaskDefinitionKey());
        item.setNodeName(task.getName());
        item.setResult(result);
        item.setState(state);
        item.setTaskId(task.getId());
        return item;
    }

    private boolean isProcessEnd(String processInstanceId) {
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).finished().singleResult();
        return historicProcessInstance != null;
    }

    private ProcessDefinition deploy(BpmnModel bpmn, ProcessTemplateEntity template) {
        Process process = (Process)bpmn.getProcesses().get(0);
        String deployName = process.getId() + ".bpmn";
        Deployment deployment = this.repositoryService.createDeployment().addBpmnModel(deployName, bpmn).name(process.getId()).key(process.getId()).deploy();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        template.setProcessDefinitionId(processDefinition.getId());
        this.processTemplateRepository.save((Object)template);
        return processDefinition;
    }

    private ProcessInstance startProcess(ProcessTemplateEntity template, String processDefinitionId, Map<String, Object> variables) {
        variables = this.processInstanceService.initInstanceMultiVariable(template, variables);
        return this.runtimeService.startProcessInstanceById(processDefinitionId, variables);
    }
}

