/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.service.internal;

import com.bizunited.platform.core.common.PlatformContext;
import com.bizunited.platform.kuiper.entity.InstanceActivityEntity;
import com.bizunited.platform.kuiper.entity.InstanceEntity;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.service.InstanceService;
import com.bizunited.platform.rbac.server.vo.UserVo;
import com.bizunited.platform.titan.starter.common.enums.MultiType;
import com.bizunited.platform.titan.starter.common.enums.ProcessInstanceState;
import com.bizunited.platform.titan.starter.common.enums.ProcessTemplateState;
import com.bizunited.platform.titan.starter.entity.ProcessAssignmentEntity;
import com.bizunited.platform.titan.starter.entity.ProcessInstanceAttachmentEntity;
import com.bizunited.platform.titan.starter.entity.ProcessInstanceEntity;
import com.bizunited.platform.titan.starter.entity.ProcessInstanceOperateRecordEntity;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateEntity;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateNodeEntity;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateNodeMultiEntity;
import com.bizunited.platform.titan.starter.repository.ProcessInstanceRepository;
import com.bizunited.platform.titan.starter.service.ProcessAssignmentService;
import com.bizunited.platform.titan.starter.service.ProcessInstanceAttachmentService;
import com.bizunited.platform.titan.starter.service.ProcessInstanceOperateRecordService;
import com.bizunited.platform.titan.starter.service.ProcessInstanceService;
import com.bizunited.platform.titan.starter.service.ProcessTaskService;
import com.bizunited.platform.titan.starter.service.ProcessTemplateNodeService;
import com.bizunited.platform.titan.starter.service.ProcessTemplateService;
import com.bizunited.platform.titan.starter.service.ProcessVariableService;
import com.bizunited.platform.titan.starter.service.internal.BaseService;
import com.bizunited.platform.titan.starter.vo.ProcessImageNodeVo;
import com.bizunited.platform.titan.starter.vo.ProcessImageVo;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.GraphicInfo;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.UserTask;
import org.flowable.engine.HistoryService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.runtime.Execution;
import org.flowable.engine.runtime.ExecutionQuery;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskInfo;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="ProcessInstanceServiceImpl")
public class ProcessInstanceServiceImpl
extends BaseService
implements ProcessInstanceService {
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ProcessInstanceRepository processInstanceRepository;
    @Autowired
    private TaskService taskService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired(required=false)
    private InstanceService instanceService;
    @Autowired
    private PlatformContext platformContext;
    @Autowired
    private ProcessTaskService processTaskService;
    @Autowired
    private ProcessVariableService processVariableService;
    @Autowired
    private ProcessTemplateService processTemplateService;
    @Autowired
    private ProcessAssignmentService processAssignmentService;
    @Autowired
    private ProcessTemplateNodeService processTemplateNodeService;
    @Autowired
    private ProcessInstanceAttachmentService processInstanceAttachmentService;
    @Autowired
    private ProcessInstanceOperateRecordService processInstanceOperateRecordService;

    @Override
    @Transactional
    public ProcessInstanceEntity startProcess(String processTemplateId, Map<String, Object> variables, Principal principal) {
        UserVo user = super.getLoginUser(principal);
        Validate.notBlank((CharSequence)processTemplateId, (String)"\u6a21\u7248ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ProcessTemplateEntity processTemplate = this.processTemplateService.findById(processTemplateId);
        Validate.notNull((Object)((Object)processTemplate), (String)"\u6d41\u7a0b\u6a21\u7248\u5bf9\u8c61\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((boolean)processTemplate.getProcessState().equals(ProcessTemplateState.PUBLISHED.getState()), (String)"\u6d41\u7a0b\u6a21\u7248\u672a\u53d1\u5e03\uff0c\u4e0d\u80fd\u53d1\u8d77\u6d41\u7a0b", (Object[])new Object[0]);
        if (variables == null) {
            variables = new HashMap<String, Object>(16);
        }
        variables.put("applicantUser", StringUtils.join((Object[])new String[]{"username:", principal.getName()}));
        Map<String, Object> templateVariables = this.processVariableService.getVariablesByTargetId(processTemplateId);
        variables.putAll(templateVariables);
        this.initInstanceMultiVariable(processTemplate, variables);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processTemplate.getProcessDefinitionId(), variables);
        Date nowTime = new Date();
        ProcessInstanceEntity instanceEntity = new ProcessInstanceEntity();
        instanceEntity.setApplicantUser(user);
        instanceEntity.setApplicantAccount(user.getAccount());
        instanceEntity.setCreateTime(nowTime);
        instanceEntity.setModifyTime(nowTime);
        instanceEntity.setLatestSubmitTime(processInstance.getStartTime());
        instanceEntity.setProcessInstanceId(processInstance.getProcessInstanceId());
        instanceEntity.setProcessState(ProcessInstanceState.DRAFT.getState());
        instanceEntity.setProcessTemplate(processTemplate);
        Set<ProcessTemplateNodeEntity> nodes = this.processTaskService.findCurrentNodes(instanceEntity);
        instanceEntity.setCurrentNodes(nodes);
        instanceEntity.setLatestOperateTime(nowTime);
        this.processInstanceRepository.save((Object)instanceEntity);
        Set<ProcessAssignmentEntity> currentAssignments = this.processTaskService.findCurrentAssignments(instanceEntity);
        instanceEntity.setCurrentAssignments(currentAssignments);
        switch (processTemplate.getFormType()) {
            case 0: {
                this.processTaskService.handleSubmitForm(processInstance.getProcessInstanceId(), principal, null);
                break;
            }
            case 1: {
                Validate.isTrue((boolean)this.platformContext.isEnableKuiper(), (String)"\u5e94\u7528\u672a\u542f\u7528\u8868\u5355\u5f15\u64ce\u6a21\u5757\uff0c\u4e0d\u80fd\u521b\u5efa\u8868\u5355\u6a21\u7248\u7684\u6d41\u7a0b", (Object[])new Object[0]);
                InstanceEntity instance = new InstanceEntity();
                TemplateEntity template = new TemplateEntity();
                template.setId(processTemplate.getFormTemplateId());
                instance.setTemplate(template);
                String taskCode = StringUtils.join((Object[])new String[]{instanceEntity.getProcessInstanceId(), "DEFAULT_START"});
                instance = this.instanceService.create(instance, taskCode, principal);
                instanceEntity.setFormInstanceId(instance.getId());
                instanceEntity.setFormNo(instance.getId());
                instanceEntity.setFormCreateActivityId(((InstanceActivityEntity)instance.getActivities().get(0)).getId());
                this.processInstanceRepository.save((Object)instanceEntity);
                break;
            }
        }
        return instanceEntity;
    }

    @Override
    public Map<String, Object> initInstanceMultiVariable(ProcessTemplateEntity processTemplate, Map<String, Object> variables) {
        Validate.notNull((Object)((Object)processTemplate), (String)"\u6d41\u7a0b\u6a21\u7248\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (variables == null) {
            variables = new HashMap<String, Object>(16);
        }
        Set<ProcessTemplateNodeEntity> nodes = this.processTemplateNodeService.findDetailsByProcessTemplateId(processTemplate.getId());
        for (ProcessTemplateNodeEntity node : nodes) {
            ProcessTemplateNodeMultiEntity multi = node.getProcessTemplateNodeMulti();
            if (multi == null || multi.getMiType().equals(MultiType.NONE_MULTI.getType())) continue;
            String collection = StringUtils.join((Object[])new String[]{node.getProcessNodeId(), "_mi_assignments"});
            if (Boolean.TRUE.equals(multi.getPresetMiAssignments())) {
                List assignments = multi.getAssignments().stream().map(ProcessAssignmentEntity::getAssignment).collect(Collectors.toList());
                variables.put(collection, assignments);
                continue;
            }
            variables.put(collection, new ArrayList());
        }
        return variables;
    }

    @Override
    @Transactional
    public void initInstanceMulti(ProcessInstanceEntity processInstance) {
        Execution processExecution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getProcessInstanceId()).onlyProcessInstanceExecutions().singleResult();
        Validate.notNull((Object)processExecution, (String)"\u672a\u627e\u5230\u6d41\u7a0b\u5b9e\u4f8b\u7684\u6267\u884c\u5b9e\u4f8b\u5bf9\u8c61", (Object[])new Object[0]);
        Map variables = this.runtimeService.getVariables(processExecution.getId());
        this.initInstanceMultiVariable(processInstance.getProcessTemplate(), variables);
        this.runtimeService.setVariables(processExecution.getId(), variables);
    }

    @Override
    public ProcessInstanceEntity findByProcessInstanceId(String processInstanceId) {
        return this.processInstanceRepository.findByProcessInstanceId(processInstanceId);
    }

    @Override
    @Transactional
    public ProcessInstanceEntity save(ProcessInstanceEntity processInstance) {
        return (ProcessInstanceEntity)((Object)this.processInstanceRepository.save((Object)processInstance));
    }

    @Override
    @Transactional
    public ProcessInstanceEntity update(ProcessInstanceEntity processInstance, UserVo user, ProcessTemplateNodeEntity currentNode, Set<ProcessAssignmentEntity> nextAssignments, Set<ProcessTemplateNodeEntity> nextNodes, Integer state) {
        Date nowTime = new Date();
        processInstance.setModifyTime(nowTime);
        processInstance.setLatestOperateTime(nowTime);
        processInstance.setLatestAssignment(user);
        processInstance.setLatestAssignmentAccount(user.getAccount());
        processInstance.setLatestNode(currentNode);
        processInstance.setCurrentAssignments(nextAssignments);
        processInstance.setCurrentNodes(nextNodes);
        processInstance.setProcessState(state);
        if (state.equals(ProcessInstanceState.COMPLETED.getState()) || state.equals(ProcessInstanceState.STOPPED.getState()) || state.equals(ProcessInstanceState.CANCELED.getState())) {
            processInstance.setEndTime(nowTime);
        }
        this.processInstanceRepository.save((Object)processInstance);
        return processInstance;
    }

    @Override
    public Page<ProcessInstanceEntity> findByConditions(Pageable pageable, ProcessInstanceEntity processInstance, Principal principal, Boolean isApplicant) {
        Page page;
        if (Boolean.TRUE.equals(isApplicant)) {
            UserVo user = this.getLoginUser(principal);
            processInstance.setApplicantUser(user);
            processInstance.setApplicantAccount(user.getAccount());
        }
        if (!CollectionUtils.isEmpty((Collection)(page = this.processInstanceRepository.findByConditions(pageable, processInstance)).getContent())) {
            for (ProcessInstanceEntity processInstanceEntity : page.getContent()) {
                Set<ProcessAssignmentEntity> currentAssignments = this.processAssignmentService.findByResourceId(processInstanceEntity.getId());
                processInstanceEntity.setCurrentAssignments(currentAssignments);
                this.loadUser(processInstanceEntity);
            }
        }
        return page;
    }

    @Override
    public ProcessInstanceEntity findDetailsByProcessInstanceId(String processInstanceId) {
        if (StringUtils.isBlank((CharSequence)processInstanceId)) {
            return null;
        }
        ProcessTemplateEntity processTemplate = this.processTemplateService.findDetailsByProcessInstanceId(processInstanceId);
        ProcessInstanceEntity processInstance = this.processInstanceRepository.findDetailsByProcessInstanceId(processInstanceId);
        if (processInstance == null) {
            return null;
        }
        this.loadUser(processInstance);
        Set<ProcessTemplateNodeEntity> currentNodes = this.processTemplateNodeService.findCurrentNodesByProcessInstanceId(processInstanceId);
        Set<ProcessInstanceOperateRecordEntity> records = this.processInstanceOperateRecordService.findDetailsByProcessInstanceId(processInstanceId);
        Set<ProcessInstanceAttachmentEntity> attachments = this.processInstanceAttachmentService.findDetailsByProcessInstanceId(processInstanceId);
        Set<ProcessAssignmentEntity> currentAssignments = this.processAssignmentService.findByResourceId(processInstance.getId());
        processInstance.setCurrentAssignments(currentAssignments);
        processInstance.setCurrentNodes(currentNodes);
        processInstance.setRecords(records);
        processInstance.setAttachments(attachments);
        processInstance.setProcessTemplate(processTemplate);
        return processInstance;
    }

    @Override
    public void loadUser(ProcessInstanceEntity processInstance) {
        if (processInstance == null) {
            return;
        }
        UserVo applicant = super.getUserByAccount(processInstance.getApplicantAccount());
        UserVo latestAssignment = super.getUserByAccount(processInstance.getLatestAssignmentAccount());
        processInstance.setApplicantUser(applicant);
        processInstance.setLatestAssignment(latestAssignment);
        this.processTemplateService.loadUser(processInstance.getProcessTemplate());
    }

    @Override
    public ProcessImageVo findImageInfoByProcessInstanceId(String processInstanceId) {
        ProcessTemplateEntity processTemplate = this.processTemplateService.findDetailsByProcessInstanceId(processInstanceId);
        Validate.notNull((Object)((Object)processTemplate), (String)"\u672a\u627e\u5230\u6d41\u7a0b\u6a21\u7248\u5bf9\u8c61", (Object[])new Object[0]);
        ProcessInstanceEntity processInstance = this.findDetailsByProcessInstanceId(processInstanceId);
        Validate.notNull((Object)((Object)processInstance), (String)"\u672a\u627e\u5230\u6d41\u7a0b\u5b9e\u4f8b\u5bf9\u8c61", (Object[])new Object[0]);
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processTemplate.getProcessDefinitionId());
        Validate.notNull((Object)bpmnModel, (String)"\u672a\u627e\u5230\u6d41\u7a0b\u8bbe\u8ba1\u56fe\u8d44\u6e90\u5bf9\u8c61", (Object[])new Object[0]);
        ArrayList<String> highLightedFlows = new ArrayList<String>();
        ArrayList<String> highLightedHisActivities = new ArrayList<String>();
        List list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).finishedAfter(processInstance.getLatestSubmitTime()).finished().list();
        List<Task> tasks = this.processTaskService.findCurrentTasks(processInstanceId);
        List highLightedActivities = tasks.stream().map(TaskInfo::getTaskDefinitionKey).collect(Collectors.toList());
        list.forEach(activityInstance -> {
            if (activityInstance.getActivityType().equals("sequenceFlow")) {
                highLightedFlows.add(activityInstance.getActivityId());
            } else {
                highLightedHisActivities.add(activityInstance.getActivityId());
            }
        });
        List<String> activities = this.processTemplateService.getStartEventAndOutLine((Process)bpmnModel.getProcesses().get(0));
        highLightedFlows.addAll(activities);
        highLightedHisActivities.addAll(activities);
        ProcessImageVo processImage = new ProcessImageVo();
        processImage.setProcessXml(processTemplate.getProcessXml());
        processImage.setHighLightedFlows(StringUtils.join(highLightedFlows, (String)","));
        processImage.setHighLightedActivities(StringUtils.join(highLightedActivities, (String)","));
        processImage.setHighLightedHisActivities(StringUtils.join(highLightedHisActivities, (String)","));
        Set<ProcessImageNodeVo> imageNodes = this.getProcessImageNodes(bpmnModel, processInstance);
        processImage.setImageNodes(imageNodes);
        return processImage;
    }

    @Override
    public Map<String, Object> setProcessVariables(String processInstanceId, Map<String, Object> variables) {
        Validate.notBlank((CharSequence)processInstanceId, (String)"\u6d41\u7a0b\u5b9e\u4f8bID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ProcessInstanceEntity processInstance = this.processInstanceRepository.findByProcessInstanceId(processInstanceId);
        Validate.notNull((Object)((Object)processInstance), (String)"\u672a\u627e\u5230\u6d41\u7a0b\u5b9e\u4f8b\u5bf9\u8c61", (Object[])new Object[0]);
        Validate.isTrue((!processInstance.getProcessState().equals(ProcessInstanceState.COMPLETED.getState()) ? 1 : 0) != 0, (String)"\u6d41\u7a0b\u5df2\u5b8c\u6210\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u53d8\u91cf", (Object[])new Object[0]);
        Validate.isTrue((!processInstance.getProcessState().equals(ProcessInstanceState.STOPPED.getState()) ? 1 : 0) != 0, (String)"\u6d41\u7a0b\u5df2\u7ec8\u6b62\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u53d8\u91cf", (Object[])new Object[0]);
        Validate.isTrue((!processInstance.getProcessState().equals(ProcessInstanceState.CANCELED.getState()) ? 1 : 0) != 0, (String)"\u6d41\u7a0b\u5df2\u64a4\u9500\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u53d8\u91cf", (Object[])new Object[0]);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(processInstanceId).onlyProcessInstanceExecutions().singleResult();
        Validate.notNull((Object)execution, (String)"\u672a\u627e\u5230\u6d41\u7a0b\u5b9e\u4f8b\u6267\u884c\u5bf9\u8c61", (Object[])new Object[0]);
        Map oldVariables = this.runtimeService.getVariables(execution.getId());
        if (CollectionUtils.isEmpty(variables)) {
            return oldVariables;
        }
        oldVariables.putAll(variables);
        this.runtimeService.setVariables(execution.getId(), oldVariables);
        return oldVariables;
    }

    @Override
    public Map<String, Object> findVariablesByProcessInstanceId(String processInstanceId) {
        if (StringUtils.isBlank((CharSequence)processInstanceId)) {
            return null;
        }
        ProcessInstanceEntity processInstance = this.processInstanceRepository.findByProcessInstanceId(processInstanceId);
        if (processInstance == null) {
            return null;
        }
        ExecutionQuery executionQuery = this.runtimeService.createExecutionQuery();
        Execution execution = (Execution)executionQuery.processInstanceId(processInstanceId).onlyProcessInstanceExecutions().singleResult();
        if (execution == null) {
            return null;
        }
        return this.runtimeService.getVariables(execution.getId());
    }

    private Set<ProcessImageNodeVo> getProcessImageNodes(BpmnModel bpmnModel, ProcessInstanceEntity processInstance) {
        HashSet<ProcessImageNodeVo> nodes = new HashSet<ProcessImageNodeVo>();
        ProcessTemplateEntity processTemplate = processInstance.getProcessTemplate();
        Process process = (Process)bpmnModel.getProcesses().get(0);
        Map locationMap = bpmnModel.getLocationMap();
        Set<UserTask> userTasks = this.getProcessUserTasks(process);
        for (UserTask userTask : userTasks) {
            ProcessImageNodeVo imageNode = new ProcessImageNodeVo();
            this.initNodeTaskInfo(imageNode, processInstance, userTask.getId());
            GraphicInfo graphicInfo = (GraphicInfo)locationMap.get(userTask.getId());
            imageNode.setX(graphicInfo.getX());
            imageNode.setY(graphicInfo.getY());
            imageNode.setWidth(graphicInfo.getWidth());
            imageNode.setHeight(graphicInfo.getHeight());
            ProcessTemplateNodeEntity node = this.processTemplateNodeService.findDetailByProcessTemplateIdAndProcessNodeId(processTemplate.getId(), userTask.getId());
            Set<ProcessInstanceOperateRecordEntity> records = this.processInstanceOperateRecordService.findByProcessInstanceIdAndProcessNodeId(processInstance.getProcessInstanceId(), userTask.getId());
            imageNode.setNode(node);
            imageNode.setRecords(records);
            nodes.add(imageNode);
        }
        return nodes;
    }

    private ProcessImageNodeVo initNodeTaskInfo(ProcessImageNodeVo imageNode, ProcessInstanceEntity processInstance, String taskDefinitionKey) {
        HistoricTaskInstanceQuery query = (HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstance.getProcessInstanceId())).taskDefinitionKey(taskDefinitionKey)).orderByHistoricTaskInstanceStartTime().desc();
        if (!taskDefinitionKey.equals("DEFAULT_START")) {
            query.taskCreatedAfter(processInstance.getLatestSubmitTime());
        }
        List taskInstances = query.list();
        List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstance.getProcessInstanceId())).taskDefinitionKey(taskDefinitionKey)).listPage(0, 1);
        if (CollectionUtils.isEmpty((Collection)tasks) && !CollectionUtils.isEmpty((Collection)taskInstances)) {
            imageNode.setState(1);
        } else {
            imageNode.setState(0);
        }
        if (CollectionUtils.isEmpty((Collection)taskInstances)) {
            return imageNode;
        }
        StringBuilder assignments = new StringBuilder();
        StringBuilder assignmentNames = new StringBuilder();
        HashSet<String> assignmentSet = new HashSet<String>();
        for (int i = 0; i < taskInstances.size(); ++i) {
            HistoricTaskInstance taskInstance = (HistoricTaskInstance)taskInstances.get(i);
            if (assignmentSet.contains(taskInstance.getAssignee())) continue;
            assignmentSet.add(taskInstance.getAssignee());
            if (assignments.length() > 0) {
                assignments.append("|");
                assignmentNames.append("|");
            }
            assignments.append(taskInstance.getAssignee());
            ProcessAssignmentEntity assignment = this.processAssignmentService.findAssignment(taskInstance.getAssignee());
            if (assignment != null) {
                assignmentNames.append(assignment.getAssignmentName());
                continue;
            }
            assignmentNames.append("\u65e0\u5ba1\u6279\u4eba");
        }
        imageNode.setAssignments(assignments.toString());
        imageNode.setAssignmentNames(assignmentNames.toString());
        imageNode.setStartTime(((HistoricTaskInstance)taskInstances.get(taskInstances.size() - 1)).getCreateTime());
        imageNode.setEndTime(((HistoricTaskInstance)taskInstances.get(0)).getEndTime());
        return imageNode;
    }

    private Set<UserTask> getProcessUserTasks(Process process) {
        HashSet<UserTask> userTasks = new HashSet<UserTask>();
        Collection flowElements = process.getFlowElements();
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof UserTask)) continue;
            UserTask userTask = (UserTask)flowElement;
            userTasks.add(userTask);
        }
        return userTasks;
    }
}

