/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.service.internal;

import com.bizunited.platform.core.entity.ScriptEntity;
import com.bizunited.platform.core.service.ScriptService;
import com.bizunited.platform.titan.starter.entity.ProcessListenerEntity;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateEntity;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateListenerEntity;
import com.bizunited.platform.titan.starter.entity.ProcessVariableEntity;
import com.bizunited.platform.titan.starter.repository.ProcessTemplateListenerRepository;
import com.bizunited.platform.titan.starter.service.ProcessListenerService;
import com.bizunited.platform.titan.starter.service.ProcessTemplateListenerService;
import com.bizunited.platform.titan.starter.service.ProcessVariableService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="ProcessTemplateListenerServiceImpl")
public class ProcessTemplateListenerServiceImpl
implements ProcessTemplateListenerService {
    @Autowired
    private ProcessTemplateListenerRepository processTemplateListenerRepository;
    @Autowired
    private ScriptService scriptService;
    @Autowired
    private ProcessVariableService processVariableService;
    @Autowired
    private ProcessListenerService processListenerService;

    private void createValidation(Set<ProcessTemplateListenerEntity> processTemplateListeners) {
        for (ProcessTemplateListenerEntity listener : processTemplateListeners) {
            Validate.isTrue((listener.getId() == null ? 1 : 0) != 0, (String)"\u521b\u5efa\u6d41\u7a0b\u6a21\u7248\u76d1\u542c\u5668\u4e0d\u80fd\u6709ID", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)listener.getTargetId(), (String)"\u6d41\u7a0b\u5143\u7d20ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)((Object)listener.getProcessListener()), (String)"\u76d1\u542c\u5668\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            this.validListenerAndScript(listener);
        }
    }

    private void validListenerAndScript(ProcessTemplateListenerEntity listener) {
        if (listener.getProcessListener() != null) {
            ProcessListenerEntity processListener = listener.getProcessListener();
            Validate.notBlank((CharSequence)processListener.getId(), (String)"\u5173\u8054\u7684\u76d1\u542c\u5668ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            processListener = this.processListenerService.findById(processListener.getId());
            Validate.notNull((Object)((Object)processListener), (String)"\u672a\u627e\u5230\u5173\u8054\u7684\u76d1\u542c\u5668:%s", (Object[])new Object[]{processListener.getId()});
            listener.setProcessListener(processListener);
        }
        if (listener.getScript() != null) {
            ScriptEntity script = listener.getScript();
            Validate.notBlank((CharSequence)script.getId(), (String)"\u5173\u8054\u7684\u811a\u672cID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            script = this.scriptService.findById(script.getId());
            Validate.notNull((Object)script, (String)"\u672a\u627e\u5230\u5173\u8054\u7684\u811a\u672c\uff1a%s", (Object[])new Object[]{script.getId()});
            listener.setScript(script);
        }
    }

    @Override
    @Transactional
    public void create(ProcessTemplateEntity processTemplateEntity, Set<ProcessTemplateListenerEntity> processTemplateListeners) {
        Validate.notNull((Object)((Object)processTemplateEntity), (String)"\u6d41\u7a0b\u6a21\u7248\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty(processTemplateListeners)) {
            processTemplateEntity.setProcessTemplateListeners(new HashSet<ProcessTemplateListenerEntity>());
            return;
        }
        this.createValidation(processTemplateListeners);
        for (ProcessTemplateListenerEntity listener : processTemplateListeners) {
            listener.setCreateTime(new Date());
            listener.setModifyTime(new Date());
            listener.setProcessTemplate(processTemplateEntity);
            this.processTemplateListenerRepository.save((Object)listener);
            Set<ProcessVariableEntity> variables = this.processVariableService.save(listener.getId(), listener.getVariables());
            listener.setVariables(variables);
        }
        processTemplateEntity.setProcessTemplateListeners(processTemplateListeners);
    }

    private void updateValidation(Set<ProcessTemplateListenerEntity> processTemplateListeners) {
        for (ProcessTemplateListenerEntity listener : processTemplateListeners) {
            Validate.isTrue((listener.getId() == null || StringUtils.isNotBlank((CharSequence)listener.getId()) ? 1 : 0) != 0, (String)"\u66f4\u65b0\u6d41\u7a0b\u6a21\u7248\u76d1\u542c\u5668\u7684ID\u4e0d\u80fd\u4e3a\u7a7a\u5b57\u7b26\u4e32", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)listener.getTargetId(), (String)"\u6d41\u7a0b\u5143\u7d20ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)((Object)listener.getProcessListener()), (String)"\u76d1\u542c\u5668\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            this.validListenerAndScript(listener);
        }
    }

    @Override
    @Transactional
    public void update(ProcessTemplateEntity processTemplateEntity, Set<ProcessTemplateListenerEntity> processTemplateListeners) {
        Validate.notNull((Object)((Object)processTemplateEntity), (String)"\u6d41\u7a0b\u6a21\u7248\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (processTemplateListeners == null) {
            processTemplateListeners = new HashSet<ProcessTemplateListenerEntity>();
        }
        this.updateValidation(processTemplateListeners);
        List<ProcessTemplateListenerEntity> oldListeners = this.processTemplateListenerRepository.findByProcessTemplateId(processTemplateEntity.getId());
        HashMap<String, ProcessTemplateListenerEntity> oldListenersMap = new HashMap<String, ProcessTemplateListenerEntity>(16);
        if (!CollectionUtils.isEmpty(oldListeners)) {
            for (ProcessTemplateListenerEntity listener2 : oldListeners) {
                oldListenersMap.put(listener2.getId(), listener2);
            }
        }
        HashSet<ProcessTemplateListenerEntity> createListeners = new HashSet<ProcessTemplateListenerEntity>();
        HashSet<ProcessTemplateListenerEntity> updateListeners = new HashSet<ProcessTemplateListenerEntity>();
        for (ProcessTemplateListenerEntity listener3 : processTemplateListeners) {
            if (listener3.getId() == null) {
                createListeners.add(listener3);
                continue;
            }
            ProcessTemplateListenerEntity listenerEntity = (ProcessTemplateListenerEntity)((Object)oldListenersMap.get(listener3.getId()));
            Validate.notNull((Object)((Object)listenerEntity), (String)"\u66f4\u65b0\u5bf9\u8c61\u4e0d\u5b58\u5728\uff0cID:%s", (Object[])new Object[]{listener3.getId()});
            listenerEntity.setModifyTime(new Date());
            listenerEntity.setProcessListener(listener3.getProcessListener());
            listenerEntity.setScript(listener3.getScript());
            listenerEntity.setTargetId(listener3.getTargetId());
            this.processTemplateListenerRepository.save((Object)listenerEntity);
            Set<ProcessVariableEntity> variables = this.processVariableService.save(listenerEntity.getId(), listener3.getVariables());
            listenerEntity.setVariables(variables);
            updateListeners.add(listenerEntity);
            oldListenersMap.remove(listener3.getId());
        }
        this.create(processTemplateEntity, createListeners);
        processTemplateEntity.getProcessTemplateListeners().addAll(updateListeners);
        if (!oldListenersMap.isEmpty()) {
            oldListenersMap.forEach((key, listener) -> {
                this.processVariableService.deleteBySourceId(listener.getId());
                this.processTemplateListenerRepository.delete(listener);
            });
        }
    }

    @Override
    public Set<ProcessTemplateListenerEntity> findDetailsByProcessTemplateId(String processTemplateId) {
        if (StringUtils.isBlank((CharSequence)processTemplateId)) {
            return Sets.newHashSet();
        }
        Set<ProcessTemplateListenerEntity> listeners = this.processTemplateListenerRepository.findDetailsByProcessTemplateId(processTemplateId);
        if (!CollectionUtils.isEmpty(listeners)) {
            for (ProcessTemplateListenerEntity listener : listeners) {
                Set<ProcessVariableEntity> variables = this.processVariableService.findBySourceId(listener.getId());
                listener.setVariables(variables);
            }
        }
        return listeners;
    }

    @Override
    public List<ProcessTemplateListenerEntity> findDetailsByProcessDefinitionIdAndTargetIdAndEvent(String processDefinitionId, String targetId, String event) {
        if (StringUtils.isBlank((CharSequence)processDefinitionId)) {
            return Lists.newArrayList();
        }
        if (StringUtils.isBlank((CharSequence)targetId)) {
            return Lists.newArrayList();
        }
        if (StringUtils.isBlank((CharSequence)event)) {
            return Lists.newArrayList();
        }
        List<ProcessTemplateListenerEntity> listeners = this.processTemplateListenerRepository.findDetailsByProcessDefinitionIdAndTargetIdAndEvent(processDefinitionId, targetId, event);
        if (!CollectionUtils.isEmpty(listeners)) {
            for (ProcessTemplateListenerEntity listener : listeners) {
                Set<ProcessVariableEntity> variables = this.processVariableService.findBySourceId(listener.getId());
                listener.setVariables(variables);
            }
        }
        return listeners;
    }
}

