/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.service.internal;

import com.bizunited.platform.core.entity.ScriptEntity;
import com.bizunited.platform.core.service.ScriptService;
import com.bizunited.platform.titan.starter.entity.ProcessListenerEntity;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateNodeAssignmentEntity;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateNodeEntity;
import com.bizunited.platform.titan.starter.entity.ProcessVariableEntity;
import com.bizunited.platform.titan.starter.repository.ProcessTemplateNodeAssignmentRepository;
import com.bizunited.platform.titan.starter.service.ProcessListenerService;
import com.bizunited.platform.titan.starter.service.ProcessTemplateNodeAssignmentService;
import com.bizunited.platform.titan.starter.service.ProcessVariableService;
import java.util.Date;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ProcessTemplateNodeAssignmentServiceImpl")
public class ProcessTemplateNodeAssignmentServiceImpl
implements ProcessTemplateNodeAssignmentService {
    @Autowired
    private ProcessTemplateNodeAssignmentRepository processTemplateNodeAssignmentRepository;
    @Autowired
    private ScriptService scriptService;
    @Autowired
    private ProcessVariableService processVariableService;
    @Autowired
    private ProcessListenerService processListenerService;

    @Override
    @Transactional
    public void create(ProcessTemplateNodeEntity node, ProcessTemplateNodeAssignmentEntity assignment) {
        Validate.notNull((Object)((Object)node), (String)"\u6d41\u7a0b\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (assignment == null) {
            return;
        }
        Validate.isTrue((assignment.getId() == null ? 1 : 0) != 0, (String)"\u521b\u5efa\u5ba1\u6279\u4eba\u4e0d\u80fd\u6709ID", (Object[])new Object[0]);
        Validate.notNull((Object)assignment.getType(), (String)"\u5ba1\u6279\u4eba\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.validListenerAndScript(assignment);
        assignment.setCreateTime(new Date());
        assignment.setModifyTime(new Date());
        assignment.setProcessTemplateNode(node);
        this.processTemplateNodeAssignmentRepository.save((Object)assignment);
        Set<ProcessVariableEntity> variables = this.processVariableService.save(assignment.getId(), assignment.getVariables());
        assignment.setVariables(variables);
        node.setAssignment(assignment);
    }

    private void validListenerAndScript(ProcessTemplateNodeAssignmentEntity assignment) {
        if (assignment.getProcessListener() != null) {
            ProcessListenerEntity processListener = assignment.getProcessListener();
            Validate.notBlank((CharSequence)processListener.getId(), (String)"\u5173\u8054\u7684\u76d1\u542c\u5668ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            processListener = this.processListenerService.findById(processListener.getId());
            Validate.notNull((Object)((Object)processListener), (String)"\u672a\u627e\u5230\u5ba1\u6279\u4eba\u5173\u8054\u7684\u76d1\u542c\u5668:%s", (Object[])new Object[]{processListener.getId()});
            assignment.setProcessListener(processListener);
        }
        if (assignment.getScript() != null) {
            ScriptEntity script = assignment.getScript();
            Validate.notBlank((CharSequence)script.getId(), (String)"\u5173\u8054\u7684\u811a\u672cID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            script = this.scriptService.findById(script.getId());
            Validate.notNull((Object)script, (String)"\u672a\u627e\u5230\u5173\u8054\u7684\u811a\u672c\uff1a%s", (Object[])new Object[]{script.getId()});
            assignment.setScript(script);
        }
    }

    @Override
    @Transactional
    public void update(ProcessTemplateNodeEntity node, ProcessTemplateNodeAssignmentEntity assignment) {
        Validate.notNull((Object)((Object)node), (String)"\u6d41\u7a0b\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ProcessTemplateNodeAssignmentEntity assignmentEntity = this.processTemplateNodeAssignmentRepository.findByProcessTemplateNodeId(node.getId());
        if (assignmentEntity == null) {
            this.create(node, assignment);
            return;
        }
        if (assignment == null) {
            this.processTemplateNodeAssignmentRepository.delete((Object)assignmentEntity);
            return;
        }
        Validate.notNull((Object)assignment.getType(), (String)"\u5ba1\u6279\u4eba\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.validListenerAndScript(assignment);
        assignmentEntity.setModifyTime(new Date());
        assignmentEntity.setProcessListener(assignment.getProcessListener());
        assignmentEntity.setScript(assignment.getScript());
        assignmentEntity.setType(assignment.getType());
        this.processTemplateNodeAssignmentRepository.save((Object)assignmentEntity);
        Set<ProcessVariableEntity> variables = this.processVariableService.save(assignmentEntity.getId(), assignment.getVariables());
        assignmentEntity.setVariables(variables);
        node.setAssignment(assignmentEntity);
    }

    @Override
    public ProcessTemplateNodeAssignmentEntity findDetailsByProcessDefinitionIdAndProcessNodeId(String processDefinitionId, String processNodeId) {
        ProcessTemplateNodeAssignmentEntity assignmentEntity = this.processTemplateNodeAssignmentRepository.findDetailsByProcessDefinitionIdAndProcessNodeId(processDefinitionId, processNodeId);
        if (assignmentEntity != null) {
            Set<ProcessVariableEntity> variables = this.processVariableService.findBySourceId(assignmentEntity.getId());
            assignmentEntity.setVariables(variables);
        }
        return assignmentEntity;
    }
}

