/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.service.internal;

import com.bizunited.platform.titan.starter.entity.ProcessAssignmentEntity;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateEntity;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateNodeAssignmentEntity;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateNodeEntity;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateNodeMultiEntity;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateNodePermissionEntity;
import com.bizunited.platform.titan.starter.entity.ProcessVariableEntity;
import com.bizunited.platform.titan.starter.repository.ProcessTemplateNodeRepository;
import com.bizunited.platform.titan.starter.service.ProcessAssignmentService;
import com.bizunited.platform.titan.starter.service.ProcessTemplateNodeAssignmentService;
import com.bizunited.platform.titan.starter.service.ProcessTemplateNodeMultiService;
import com.bizunited.platform.titan.starter.service.ProcessTemplateNodePermissionService;
import com.bizunited.platform.titan.starter.service.ProcessTemplateNodeService;
import com.bizunited.platform.titan.starter.service.ProcessVariableService;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="ProcessTemplateNodeServiceImpl")
public class ProcessTemplateNodeServiceImpl
implements ProcessTemplateNodeService {
    @Autowired
    private ProcessTemplateNodeRepository processTemplateNodeRepository;
    @Autowired
    private ProcessVariableService processVariableService;
    @Autowired
    private ProcessAssignmentService processAssignmentService;
    @Autowired
    private ProcessTemplateNodeMultiService processTemplateNodeMultiService;
    @Autowired
    private ProcessTemplateNodePermissionService processTemplateNodePermissionService;
    @Autowired
    private ProcessTemplateNodeAssignmentService processTemplateNodeAssignmentService;

    private void createValidation(Set<ProcessTemplateNodeEntity> processTemplateNodes) {
        HashSet<String> nodeIds = new HashSet<String>();
        for (ProcessTemplateNodeEntity node : processTemplateNodes) {
            Validate.isTrue((node.getId() == null ? 1 : 0) != 0, (String)"\u521b\u5efa\u6d41\u7a0b\u8282\u70b9\u4e0d\u80fd\u6709ID", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)node.getProcessNodeId(), (String)"\u8282\u70b9ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)node.getProcessNodeName(), (String)"\u8282\u70b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((!nodeIds.contains(node.getProcessNodeId()) ? 1 : 0) != 0, (String)"\u8282\u70b9ID\u4e0d\u80fd\u91cd\u590d", (Object[])new Object[0]);
            nodeIds.add(node.getProcessNodeId());
        }
    }

    @Override
    @Transactional
    public void create(ProcessTemplateEntity processTemplateEntity, Set<ProcessTemplateNodeEntity> processTemplateNodes) {
        if (CollectionUtils.isEmpty(processTemplateNodes)) {
            return;
        }
        this.createValidation(processTemplateNodes);
        for (ProcessTemplateNodeEntity node : processTemplateNodes) {
            if (node.getCanBack() == null) {
                node.setCanBack(false);
            }
            if (node.getCancelFlag() == null) {
                node.setCancelFlag(false);
            }
            if (node.getManualNext() == null) {
                node.setManualNext(false);
            }
            if (node.getNullSkip() == null) {
                node.setNullSkip(false);
            }
            if (node.getRepeatSkip() == null) {
                node.setRepeatSkip(false);
            }
            node.setCreateTime(new Date());
            node.setModifyTime(new Date());
            node.setProcessTemplate(processTemplateEntity);
            ProcessTemplateNodeMultiEntity processTemplateNodeMulti = node.getProcessTemplateNodeMulti();
            ProcessTemplateNodeAssignmentEntity assignment = node.getAssignment();
            node.setProcessTemplateNodeMulti(null);
            node.setAssignment(null);
            this.processTemplateNodeRepository.save((Object)node);
            this.processTemplateNodeAssignmentService.create(node, assignment);
            ProcessTemplateNodeMultiEntity nodeMultiEntity = this.processTemplateNodeMultiService.save(node, processTemplateNodeMulti);
            node.setProcessTemplateNodeMulti(nodeMultiEntity);
        }
        processTemplateEntity.setProcessTemplateNodes(processTemplateNodes);
    }

    private void updateValidation(Set<ProcessTemplateNodeEntity> processTemplateNodes) {
        if (CollectionUtils.isEmpty(processTemplateNodes)) {
            return;
        }
        HashSet<String> nodeIds = new HashSet<String>();
        for (ProcessTemplateNodeEntity node : processTemplateNodes) {
            Validate.isTrue((node.getId() == null || StringUtils.isNotBlank((CharSequence)node.getId()) ? 1 : 0) != 0, (String)"\u66f4\u65b0\u6d41\u7a0b\u6a21\u7248\u8282\u70b9\u7684ID\u4e0d\u80fd\u4e3a\u7a7a\u5b57\u7b26\u4e32", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)node.getProcessNodeId(), (String)"\u8282\u70b9ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)node.getProcessNodeName(), (String)"\u8282\u70b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((!nodeIds.contains(node.getProcessNodeId()) ? 1 : 0) != 0, (String)"\u8282\u70b9ID\u4e0d\u80fd\u91cd\u590d", (Object[])new Object[0]);
            nodeIds.add(node.getProcessNodeId());
        }
    }

    @Override
    @Transactional
    public void update(ProcessTemplateEntity processTemplateEntity, Set<ProcessTemplateNodeEntity> processTemplateNodes) {
        if (processTemplateNodes == null) {
            processTemplateNodes = new HashSet<ProcessTemplateNodeEntity>();
        }
        this.updateValidation(processTemplateNodes);
        Set<ProcessTemplateNodeEntity> oldNodes = this.findDetailsByProcessTemplateId(processTemplateEntity.getId());
        HashMap<String, ProcessTemplateNodeEntity> oldNodesMap = new HashMap<String, ProcessTemplateNodeEntity>(16);
        if (!CollectionUtils.isEmpty(oldNodes)) {
            for (ProcessTemplateNodeEntity oldNode : oldNodes) {
                oldNodesMap.put(oldNode.getId(), oldNode);
            }
        }
        HashSet<ProcessTemplateNodeEntity> createNodes = new HashSet<ProcessTemplateNodeEntity>();
        HashSet<ProcessTemplateNodeEntity> updateNodes = new HashSet<ProcessTemplateNodeEntity>();
        for (ProcessTemplateNodeEntity node2 : processTemplateNodes) {
            if (node2.getId() == null) {
                createNodes.add(node2);
                continue;
            }
            ProcessTemplateNodeEntity oldNode = (ProcessTemplateNodeEntity)((Object)oldNodesMap.get(node2.getId()));
            Validate.notNull((Object)((Object)oldNode), (String)"\u66f4\u65b0\u5bf9\u8c61\u4e0d\u5b58\u5728\uff0cID:%s", (Object[])new Object[]{node2.getId()});
            if (node2.getCanBack() != null) {
                oldNode.setCanBack(node2.getCanBack());
            }
            if (node2.getCancelFlag() != null) {
                oldNode.setCancelFlag(node2.getCancelFlag());
            }
            if (node2.getManualNext() != null) {
                oldNode.setManualNext(node2.getManualNext());
            }
            if (node2.getNullSkip() != null) {
                oldNode.setNullSkip(node2.getNullSkip());
            }
            if (node2.getRepeatSkip() != null) {
                oldNode.setRepeatSkip(node2.getRepeatSkip());
            }
            oldNode.setProcessNodeId(node2.getProcessNodeId());
            oldNode.setProcessNodeName(node2.getProcessNodeName());
            oldNode.setProcessNodeDoc(node2.getProcessNodeDoc());
            oldNode.setBtnAuth(node2.getBtnAuth());
            oldNode.setModifyTime(new Date());
            oldNode.setFormVisibilityName(node2.getFormVisibilityName());
            oldNode.setProcessTemplateNodePermission(node2.getProcessTemplateNodePermission());
            this.processTemplateNodeRepository.save((Object)oldNode);
            ProcessTemplateNodeMultiEntity nodeMultiEntity = this.processTemplateNodeMultiService.save(oldNode, node2.getProcessTemplateNodeMulti());
            oldNode.setProcessTemplateNodeMulti(nodeMultiEntity);
            this.processTemplateNodeAssignmentService.update(oldNode, node2.getAssignment());
            updateNodes.add(oldNode);
            oldNodesMap.remove(oldNode.getId());
        }
        this.create(processTemplateEntity, createNodes);
        if (processTemplateEntity.getProcessTemplateNodes() == null) {
            processTemplateEntity.setProcessTemplateNodes(new HashSet<ProcessTemplateNodeEntity>());
        }
        processTemplateEntity.getProcessTemplateNodes().addAll(updateNodes);
        if (!oldNodesMap.isEmpty()) {
            oldNodesMap.forEach((key, node) -> {
                this.processTemplateNodeRepository.delete(node);
                if (node.getProcessTemplateNodeMulti() != null) {
                    this.processAssignmentService.deleteByResourceId(node.getProcessTemplateNodeMulti().getId());
                }
            });
        }
    }

    @Override
    public ProcessTemplateNodeEntity findByProcessTemplateIdAndProcessNodeId(String templateId, String processNodeId) {
        return this.processTemplateNodeRepository.findByProcessTemplateIdAndProcessNodeId(templateId, processNodeId);
    }

    @Override
    public ProcessTemplateNodeEntity findDetailByProcessTemplateIdAndProcessNodeId(String templateId, String processNodeId) {
        ProcessTemplateNodeEntity node = this.processTemplateNodeRepository.findDetailsByProcessTemplateIdAndProcessNodeId(templateId, processNodeId);
        this.loadNodeDetails(node);
        return node;
    }

    private ProcessTemplateNodeEntity loadNodeDetails(ProcessTemplateNodeEntity node) {
        if (node == null) {
            return null;
        }
        if (node.getAssignment() != null) {
            Set<ProcessVariableEntity> variables = this.processVariableService.findBySourceId(node.getAssignment().getId());
            node.getAssignment().setVariables(variables);
        }
        if (node.getProcessTemplateNodeMulti() != null) {
            Set<ProcessAssignmentEntity> assignments = this.processAssignmentService.findByResourceId(node.getProcessTemplateNodeMulti().getId());
            node.getProcessTemplateNodeMulti().setAssignments(assignments);
        }
        return node;
    }

    @Override
    public Set<ProcessTemplateNodeEntity> findDetailsByProcessTemplateId(String processTemplateId) {
        if (StringUtils.isBlank((CharSequence)processTemplateId)) {
            return Sets.newHashSet();
        }
        Set<ProcessTemplateNodeEntity> nodes = this.processTemplateNodeRepository.findDetailsByProcessTemplateId(processTemplateId);
        if (!CollectionUtils.isEmpty(nodes)) {
            for (ProcessTemplateNodeEntity node : nodes) {
                this.loadNodeDetails(node);
            }
        }
        return nodes;
    }

    @Override
    public List<ProcessTemplateNodeEntity> findByProcessTemplateIdAndCancelFlag(String processTemplateId, boolean cancelFlag) {
        return this.processTemplateNodeRepository.findByProcessTemplateIdAndCancelFlag(processTemplateId, cancelFlag);
    }

    @Override
    public List<ProcessTemplateNodeEntity> findByProcessTemplateId(String templateId) {
        return this.processTemplateNodeRepository.findByProcessTemplateId(templateId);
    }

    @Override
    public Set<ProcessTemplateNodeEntity> findCurrentNodesByProcessInstanceId(String processInstanceId) {
        Set<ProcessTemplateNodeEntity> nodes = this.processTemplateNodeRepository.findCurrentNodesByProcessInstanceId(processInstanceId);
        this.loadUser(nodes);
        return nodes;
    }

    private void loadUser(Set<ProcessTemplateNodeEntity> nodes) {
        if (CollectionUtils.isEmpty(nodes)) {
            return;
        }
        for (ProcessTemplateNodeEntity node : nodes) {
            ProcessTemplateNodePermissionEntity permission = node.getProcessTemplateNodePermission();
            this.processTemplateNodePermissionService.loadUser(permission);
        }
    }
}

