/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.repository.internal;

import com.bizunited.platform.rbac.server.vo.UserVo;
import com.bizunited.platform.titan.starter.entity.ProcessCarbonCopyEntity;
import com.bizunited.platform.titan.starter.entity.ProcessInstanceEntity;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateEntity;
import com.bizunited.platform.titan.starter.repository.internal.ProcessCarbonCopyRepositoryCustom;
import com.bizunited.platform.titan.starter.service.TitanToolkitService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository(value="ProcessCarbonCopyRepositoryImpl")
public class ProcessCarbonCopyRepositoryImpl
implements ProcessCarbonCopyRepositoryCustom {
    @Autowired
    private EntityManager entityManager;
    @Autowired
    @Qualifier(value="TitanToolkitService")
    private TitanToolkitService titanToolkitService;

    @Override
    public Page<ProcessCarbonCopyEntity> findMyByConditions(Pageable pageable, ProcessCarbonCopyEntity carbonCopy, UserVo user) {
        ProcessInstanceEntity processInstance;
        StringBuilder hql = new StringBuilder("select pcc from ProcessCarbonCopyEntity pcc ");
        hql.append(" inner join fetch pcc.processInstance pi ");
        hql.append(" inner join fetch pi.processTemplate pt");
        hql.append(" inner join fetch pcc.receiveAssignment pcca");
        hql.append(" where (pcca.assignment = :account or pcca.assignment in :positionCodes or pcca.assignment in :roleCodes) ");
        StringBuilder countHql = new StringBuilder("select count(*) from ProcessCarbonCopyEntity pcc ");
        countHql.append(" inner join pcc.processInstance pi ");
        countHql.append(" inner join pi.processTemplate pt");
        countHql.append(" inner join pcc.receiveAssignment pcca");
        countHql.append(" where (pcca.assignment = :account or pcca.assignment in :positionCodes or pcca.assignment in :roleCodes) ");
        StringBuilder conditions = new StringBuilder();
        HashMap<String, Object> parameter = new HashMap<String, Object>(16);
        parameter.put("account", StringUtils.join((Object[])new String[]{"username:", user.getAccount()}));
        List<String> positionCodes = this.titanToolkitService.getAssignmentPositionCodes(user.getPositions());
        if (positionCodes == null) {
            positionCodes = new ArrayList<String>();
        }
        if (positionCodes.isEmpty()) {
            positionCodes.add("-0101010101");
        }
        parameter.put("positionCodes", positionCodes);
        List<String> roleCodes = this.titanToolkitService.getAssignmentRoleCodes(user.getRoles());
        if (roleCodes == null) {
            roleCodes = new ArrayList<String>();
        }
        if (roleCodes.isEmpty()) {
            roleCodes.add("-0101010101");
        }
        parameter.put("roleCodes", roleCodes);
        if (carbonCopy != null && (processInstance = carbonCopy.getProcessInstance()) != null) {
            ProcessTemplateEntity processTemplate = processInstance.getProcessTemplate();
            if (StringUtils.isNotBlank((CharSequence)processInstance.getFormNo())) {
                conditions.append(" and pi.formNo = :formNo ");
                parameter.put("formNo", processInstance.getFormNo());
            }
            if (processInstance.getLatestSubmitTime() != null) {
                conditions.append(" and pi.latestSubmitTime >= :latestSubmitTime ");
                parameter.put("latestSubmitTime", processInstance.getLatestSubmitTime());
            }
            if (processTemplate != null) {
                if (StringUtils.isNotBlank((CharSequence)processTemplate.getProcessKey())) {
                    conditions.append(" and pt.processKey = :processKey ");
                    parameter.put("processKey", processTemplate.getProcessKey());
                }
                if (StringUtils.isNotBlank((CharSequence)processTemplate.getProcessName())) {
                    conditions.append(" and pt.processName = :processName ");
                    parameter.put("processName", processTemplate.getProcessName());
                }
            }
        }
        hql.append(conditions.toString()).append(" order by pcc.state asc, pcc.createTime desc ");
        countHql.append(conditions.toString());
        Query query = this.entityManager.createQuery(hql.toString());
        Query countQuery = this.entityManager.createQuery(countHql.toString());
        parameter.forEach((k, v) -> {
            query.setParameter(k, v);
            countQuery.setParameter(k, v);
        });
        query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
        query.setMaxResults(pageable.getPageSize());
        List result = new ArrayList();
        long count = (Long)countQuery.getResultList().get(0);
        if (count > 0L) {
            result = query.getResultList();
        }
        return new PageImpl(result, pageable, count);
    }
}

