/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.service.init;

import com.bizunited.platform.core.common.PlatformContext;
import com.bizunited.platform.core.service.init.AbstractCompetenceInitProcess;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="TitanCompetenceInitProcess")
public class TitanCompetenceInitProcess
extends AbstractCompetenceInitProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(TitanCompetenceInitProcess.class);
    @Autowired
    private PlatformContext platformContext;

    public boolean doProcess() {
        return this.platformContext.isEnableTitan();
    }

    public void init() {
        try (InputStream is = TitanCompetenceInitProcess.class.getClassLoader().getResourceAsStream("titan-competences.json");){
            super.initCompetences(is);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }
}

