/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.command;

import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.flowable.bpmn.model.MultiInstanceLoopCharacteristics;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.runtime.Execution;
import org.flowable.task.api.Task;

public class ProphesyMultiCompletionBeforeRejectCommand
implements Command<Boolean> {
    private Task task;
    private int rejectCount;
    private UserTask userTask;
    private RuntimeService runtimeService;

    public ProphesyMultiCompletionBeforeRejectCommand(RuntimeService runtimeService, Task task, UserTask userTask, int rejectCount) {
        this.task = task;
        this.userTask = userTask;
        this.rejectCount = rejectCount;
        this.runtimeService = runtimeService;
    }

    public Boolean execute(CommandContext commandContext) {
        MultiInstanceLoopCharacteristics loopCharacteristics = this.userTask.getLoopCharacteristics();
        Validate.notNull((Object)loopCharacteristics, (String)"\u672a\u627e\u5230\u7528\u6237\u4efb\u52a1\u8282\u70b9\u7684\u4f1a\u7b7e\u914d\u7f6e\u4fe1\u606f", (Object[])new Object[0]);
        String completionCondition = loopCharacteristics.getCompletionCondition();
        ExpressionManager expressionManager = CommandContextUtil.getProcessEngineConfiguration().getExpressionManager();
        Expression expression = expressionManager.createExpression(completionCondition);
        ExecutionEntityImpl executionEntity = ExecutionEntityImpl.createWithEmptyRelationshipCollections();
        Map variables = this.runtimeService.getVariables(this.task.getExecutionId());
        executionEntity.setVariables(variables);
        Integer nrOfInstances = (Integer)executionEntity.getVariable("nrOfInstances");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().executionId(this.task.getExecutionId()).singleResult();
        Integer nrOfRejectedInstances = (Integer)this.runtimeService.getVariableLocal(execution.getParentId(), "nrOfRejectedInstances");
        nrOfRejectedInstances = nrOfRejectedInstances == null ? 0 : nrOfRejectedInstances;
        nrOfRejectedInstances = nrOfRejectedInstances + this.rejectCount;
        Integer nrOfCompletedInstances = nrOfInstances - nrOfRejectedInstances;
        executionEntity.setVariable("nrOfCompletedInstances", (Object)nrOfCompletedInstances);
        Boolean value = (Boolean)expression.getValue((VariableContainer)executionEntity);
        executionEntity.removeVariables();
        return value;
    }
}

