/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.controller;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.titan.starter.entity.ProcessInstanceEntity;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateEntity;
import com.bizunited.platform.titan.starter.service.ProcessInstanceService;
import com.bizunited.platform.titan.starter.vo.ProcessImageVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.security.Principal;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6d41\u7a0b\u5b9e\u4f8b\u529f\u80fd\u4e1a\u52a1\u6a21\u578b\u7684MVC Controller\u5c42\u5b9e\u73b0"})
@RestController
@RequestMapping(value={"v1/titan/instances"})
public class ProcessInstanceController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessInstanceController.class);
    @Autowired
    private ProcessInstanceService processInstanceService;

    @PostMapping(value={"startProcess"})
    @ApiOperation(value="\u6839\u636e\u6a21\u7248ID\u5f00\u542f\u6d41\u7a0b")
    public ResponseModel startProcess(@RequestParam(name="processTemplateId") @ApiParam(value="\u6a21\u7248ID", required=true) String processTemplateId, @RequestBody Map<String, Object> variables) {
        try {
            Principal principal = this.getPrincipal();
            ProcessInstanceEntity processInstance = this.processInstanceService.startProcess(processTemplateId, variables, principal);
            return this.buildHttpResultW((Object)processInstance, new String[]{"processTemplate", "currentNodes", "latestNode"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PostMapping(value={"startProcessByFromInstance"})
    @ApiOperation(value="\u4ee5\u5df2\u6709\u8868\u5355\u5b9e\u4f8b\u5f00\u8d77\u6d41\u7a0b")
    public ResponseModel startProcess(@RequestParam(name="processKey") @ApiParam(value="\u6a21\u7248Key", required=true) String processKey, @RequestParam(name="formInstanceId") @ApiParam(value="\u8868\u5355\u5b9e\u4f8bID", required=true) String formInstanceId, @RequestParam(name="formNo") @ApiParam(value="\u8868\u5355\u7f16\u53f7", required=true) String formNo, @RequestParam(name="formTitle", required=false) @ApiParam(value="\u8868\u5355\u540d\u79f0") String formTitle, @RequestParam(name="visibility", defaultValue="create") @ApiParam(value="\u53ef\u89c1\u6027\uff0c\u9ed8\u8ba4\u4f20create", required=true) String visibility, @RequestBody Map<String, Object> variables) {
        try {
            Principal principal = this.getPrincipal();
            ProcessInstanceEntity processInstance = this.processInstanceService.startProcess(processKey, formInstanceId, formNo, formTitle, visibility, variables, principal, false);
            return this.buildHttpResultW((Object)processInstance, new String[]{"processTemplate", "currentNodes", "latestNode"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByConditions"})
    @ApiOperation(value="\u6761\u4ef6\u5206\u9875\u67e5\u8be2\u6d41\u7a0b\u5b9e\u4f8b", notes="\u5982\u679c\u662f\u67e5\u6211\u53d1\u8d77\u7684\u6d41\u7a0b\uff0cisApplicant\u53c2\u6570\u4f201 \n\u9875\u6570\u53c2\u6570\u4e3apage\uff0c\u7b2c\u4e00\u9875\u4ece0\u5f00\u59cb\uff0c\u5206\u9875\u5927\u5c0f\u53c2\u6570\u4e3asize\uff08size\u9ed8\u8ba4\u4e3a50\uff09")
    public ResponseModel findByConditions(@PageableDefault(value=50) Pageable pageable, @RequestParam(name="isApplicant", required=false, defaultValue="0") @ApiParam(value="\u662f\u5426\u662f\u53d1\u8d77\u4eba") Boolean isApplicant, @RequestParam(name="processKey", required=false) @ApiParam(value="\u6a21\u7248key") String processKey, @RequestParam(name="processName", required=false) @ApiParam(value="\u6a21\u7248\u540d\u79f0") String processName, @RequestParam(name="formNo", required=false) @ApiParam(value="\u8868\u5355\u7f16\u53f7") String formNo, @RequestParam(name="state", required=false) @ApiParam(value="\u6d41\u7a0b\u72b6\u6001") Integer state, @RequestParam(name="applyDate", required=false) @ApiParam(value="\u7533\u8bf7\u65e5\u671f,\u683c\u5f0f\u4e3a:yyyy-MM-dd") @DateTimeFormat(pattern="yyyy-MM-dd") Date applyDate) {
        try {
            Principal principal = this.getPrincipal();
            ProcessInstanceEntity processInstance = new ProcessInstanceEntity();
            ProcessTemplateEntity processTemplate = new ProcessTemplateEntity();
            processTemplate.setProcessKey(processKey);
            processTemplate.setProcessName(processName);
            processInstance.setProcessTemplate(processTemplate);
            processInstance.setFormNo(formNo);
            processInstance.setProcessState(state);
            processInstance.setLatestSubmitTime(applyDate);
            Page<ProcessInstanceEntity> page = this.processInstanceService.findByConditions(pageable, processInstance, principal, isApplicant);
            return this.buildHttpResultW((Iterable)page, new String[]{"processTemplate", "applicantUser", "latestAssignment", "currentAssignments", "latestNode", "currentNodes"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findDetailsByProcessInstanceId"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8bID\u67e5\u8be2\u8be6\u60c5")
    public ResponseModel findDetailsByProcessInstanceId(@RequestParam(name="processInstanceId") @ApiParam(value="\u6d41\u7a0b\u5b9e\u4f8bID", required=true) String processInstanceId) {
        try {
            ProcessInstanceEntity processInstance = this.processInstanceService.findDetailsByProcessInstanceId(processInstanceId);
            return this.buildHttpResultW((Object)processInstance, new String[]{"records", "currentNodes", "latestNode", "currentAssignments", "latestAssignment", "applicantUser", "processTemplate", "records.operator", "records.processTemplateNode", "attachments", "attachments.ordinaryFile", "processTemplate.onSubmitScript"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findImageInfoByProcessInstanceId"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8bID\u67e5\u8be2\u6d41\u7a0b\u56fe\u7247\u4fe1\u606f")
    public ResponseModel findImageInfoByProcessInstanceId(@RequestParam(name="processInstanceId") @ApiParam(value="\u6d41\u7a0b\u5b9e\u4f8bID", required=true) String processInstanceId) {
        try {
            ProcessImageVo processImage = this.processInstanceService.findImageInfoByProcessInstanceId(processInstanceId);
            return this.buildHttpResultW(processImage, new String[]{"imageNodes", "imageNodes.records", "imageNodes.records.operator", "imageNodes.node", "imageNodes.assignments", "imageNodes.assignmentNames", "imageNodes.node.processTemplateNodeMulti", "imageNodes.node.processTemplateNodePermission"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PatchMapping(value={"setProcessVariables"})
    @ApiOperation(value="\u8bbe\u7f6e\u6d41\u7a0b\u53d8\u91cf")
    public ResponseModel setProcessVariables(@RequestParam(name="processInstanceId") @ApiParam(value="\u6d41\u7a0b\u5b9e\u4f8bID", required=true) String processInstanceId, @RequestBody Map<String, Object> variables) {
        try {
            variables = this.processInstanceService.setProcessVariables(processInstanceId, variables);
            return this.buildHttpResult(variables);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findVariablesByProcessInstanceId"})
    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u53d8\u91cf")
    public ResponseModel findVariablesByProcessInstanceId(@RequestParam(name="processInstanceId") @ApiParam(value="\u6d41\u7a0b\u5b9e\u4f8bID", required=true) String processInstanceId) {
        try {
            Map<String, Object> variables = this.processInstanceService.findVariablesByProcessInstanceId(processInstanceId);
            return this.buildHttpResult(variables);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByFromNo"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355\u7f16\u53f7\u67e5\u8be2\u6d41\u7a0b\u5b9e\u4f8b")
    public ResponseModel findByFromNo(@RequestParam @ApiParam(value="\u8868\u5355\u7f16\u53f7", required=true) String formNo) {
        try {
            Set<ProcessInstanceEntity> instances = this.processInstanceService.findByFromNo(formNo);
            return this.buildHttpResultW(instances, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByProcessKeyAndFromNo"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0bkey\u548c\u8868\u5355\u7f16\u53f7\u67e5\u8be2\u6d41\u7a0b\u5b9e\u4f8b")
    public ResponseModel findByProcessKeyAndFromNo(@RequestParam @ApiParam(value="\u6d41\u7a0bkey", required=true) String processKey, @RequestParam @ApiParam(value="\u8868\u5355\u7f16\u53f7", required=true) String formNo) {
        try {
            ProcessInstanceEntity instance = this.processInstanceService.findByProcessKeyAndFromNo(processKey, formNo);
            return this.buildHttpResultW((Object)instance, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

