/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.service.init;

import com.alibaba.fastjson.JSON;
import com.bizunited.platform.core.service.init.InitProcessService;
import com.bizunited.platform.titan.starter.entity.ProcessListenerEntity;
import com.bizunited.platform.titan.starter.repository.ProcessListenerRepository;
import com.bizunited.platform.titan.starter.service.init.TitanCompetenceInitProcess;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="ListenerInitProcess")
public class ListenerInitProcess
implements InitProcessService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListenerInitProcess.class);
    @Autowired
    private ProcessListenerRepository processListenerRepository;

    public boolean doProcess() {
        long count = this.processListenerRepository.count();
        return count == 0L;
    }

    public void init() {
        try (InputStream is = TitanCompetenceInitProcess.class.getClassLoader().getResourceAsStream("listener-init.json");){
            if (is == null) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                String line = bufferedReader.readLine();
                while (line != null) {
                    sb.append(line);
                    line = bufferedReader.readLine();
                }
            }
            String json = sb.toString();
            if (StringUtils.isBlank((CharSequence)json)) {
                return;
            }
            List listeners = JSON.parseArray((String)json, ProcessListenerEntity.class);
            if (CollectionUtils.isEmpty((Collection)listeners)) {
                return;
            }
            Date date = new Date();
            for (ProcessListenerEntity listener : listeners) {
                listener.setCreateTime(date);
                listener.setModifyTime(date);
            }
            this.processListenerRepository.saveAll(listeners);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }
}

