/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.service.invoke.handle.request;

import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.invoke.InvokeRequestHandle;
import com.bizunited.platform.titan.starter.common.enums.ProcessListenerExecuteMode;
import com.bizunited.platform.titan.starter.entity.ProcessListenerEntity;
import com.bizunited.platform.titan.starter.entity.ProcessVariableEntity;
import com.bizunited.platform.titan.starter.service.invoke.handle.request.AbstractListenerHandle;
import com.bizunited.platform.titan.starter.service.invoke.handle.request.TaskListenerNotifyHandle;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.ExecutionListener;
import org.flowable.variable.api.delegate.VariableScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionListenerNotifyHandle
extends AbstractListenerHandle
implements InvokeRequestHandle {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskListenerNotifyHandle.class);
    private DelegateExecution execution;
    private ProcessListenerEntity listener;
    private Set<ProcessVariableEntity> variables;

    public ExecutionListenerNotifyHandle(DelegateExecution execution, ProcessListenerEntity listener, Set<ProcessVariableEntity> variables) {
        this.execution = execution;
        this.listener = listener;
        this.variables = variables;
    }

    public void doHandle(InvokeProxyContext context, HandleChain chain) throws InvokeProxyException {
        LOGGER.info("\u5f00\u59cb\u6267\u884c\u76d1\u542c\u5668\uff1a{}", (Object)this.listener.getName());
        Validate.isTrue((boolean)this.listener.getExecuteMode().equals(ProcessListenerExecuteMode.ORIGIN.getMode()), (String)"TaskListenerNotifyHandle\u53ea\u80fd\u5904\u7406\u539f\u751f\u76d1\u542c\u5668", (Object[])new Object[0]);
        try {
            Class<?> listenerClass = Class.forName(this.listener.getListenerClass());
            Object obj = listenerClass.newInstance();
            super.setVariables((VariableScope)this.execution, this.variables);
            Validate.isTrue((boolean)(obj instanceof ExecutionListener), (String)"\u6267\u884c\u76d1\u542c\u5668\u5fc5\u987b\u5b9e\u73b0org.flowable.engine.delegate.ExecutionListener", (Object[])new Object[0]);
            ExecutionListener executionListener = (ExecutionListener)obj;
            executionListener.notify(this.execution);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e.getCause());
        }
        LOGGER.info("\u6267\u884c\u7ed3\u675f\u76d1\u542c\u5668\uff1a{}", (Object)this.listener.getName());
    }
}

