/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.service.invoke.handle.request;

import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.invoke.InvokeRequestHandle;
import com.bizunited.platform.titan.starter.common.Constants;
import com.bizunited.platform.titan.starter.common.enums.TaskOperateBtn;
import com.bizunited.platform.titan.starter.entity.ProcessInstanceEntity;
import com.bizunited.platform.titan.starter.service.ProcessTaskService;
import com.bizunited.platform.titan.starter.service.invoke.model.ProcessInputParamsModel;
import java.security.Principal;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component(value="ProcessInstanceHandle")
public class ProcessInstanceHandle
implements InvokeRequestHandle {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessInstanceHandle.class);
    @Autowired
    private ProcessTaskService processTaskService;

    public void doHandle(InvokeProxyContext context, HandleChain chain) throws InvokeProxyException {
        if (!context.isException()) {
            SecurityContext securityContext = SecurityContextHolder.getContext();
            Validate.notNull((Object)securityContext, (String)"\u672a\u53d1\u73b0\u4efb\u4f55\u7528\u6237\u6743\u9650\u4fe1\u606f!!", (Object[])new Object[0]);
            Authentication authentication = securityContext.getAuthentication();
            Validate.notNull((Object)authentication, (String)"\u672a\u53d1\u73b0\u4efb\u4f55\u7528\u6237\u767b\u5f55\u4fe1\u606f!!", (Object[])new Object[0]);
            ProcessInputParamsModel model = (ProcessInputParamsModel)context.getChainParam(ProcessInputParamsModel.class.getName());
            Validate.notNull((Object)model, (String)"\u9519\u8bef\u7684\u5165\u53c2\u6a21\u578b\u5bf9\u8c61\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)model.getBtn(), (String)"btn\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            TaskOperateBtn btn = Constants.getOperateBtn(model.getBtn());
            Validate.notNull((Object)((Object)btn), (String)"\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\uff1a%s", (Object[])new Object[]{model.getBtn()});
            switch (btn) {
                case BTN_001: {
                    ProcessInstanceEntity processInstance = this.processTaskService.handleComplete(model.getTaskId(), (Principal)authentication, model.getContent(), model.getVariables());
                    context.setResult((Object)processInstance);
                    break;
                }
                case BTN_002: {
                    this.processTaskService.handleReject(model.getTaskId(), (Principal)authentication, model.getContent(), model.getVariables());
                    break;
                }
                case BTN_003: {
                    this.processTaskService.handleBackTask(model.getTaskId(), model.getTargetActivitiId(), (Principal)authentication, model.getContent(), model.getVariables());
                    break;
                }
                case BTN_004: {
                    this.processTaskService.handleRetrieve(model.getProcessInstanceId(), model.getActivityId(), (Principal)authentication);
                    break;
                }
                case BTN_011: {
                    this.processTaskService.handleSubmitForm(model.getProcessInstanceId(), (Principal)authentication, model.getVariables());
                    break;
                }
                case BTN_012: {
                    this.processTaskService.handleCancel(model.getProcessInstanceId(), (Principal)authentication, model.getContent(), model.getVariables());
                    break;
                }
                case BTN_013: {
                    this.processTaskService.handleStop(model.getTaskId(), (Principal)authentication, model.getContent());
                    break;
                }
                default: {
                    LOGGER.error("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\uff1a{}", (Object)btn.getBtn());
                    throw new UnsupportedOperationException(String.format("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\uff1a%s", btn.getBtn()));
                }
            }
        }
        chain.doHandle(context, HandleChain.ChainLogic.CONTINUE);
    }
}

