/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.configuration.flowable;

import com.bizunited.platform.titan.starter.configuration.flowable.AbstractSpringEngineAutoConfiguration;
import com.bizunited.platform.titan.starter.configuration.flowable.BaseEngineConfigurationWithConfigurers;
import com.bizunited.platform.titan.starter.configuration.flowable.FlowableJobConfiguration;
import com.bizunited.platform.titan.starter.configuration.flowable.FlowableMailProperties;
import com.bizunited.platform.titan.starter.configuration.flowable.FlowableProperties;
import com.bizunited.platform.titan.starter.configuration.flowable.process.FlowableProcessProperties;
import com.bizunited.platform.titan.starter.configuration.flowable.process.Process;
import com.bizunited.platform.titan.starter.configuration.flowable.process.ProcessAsync;
import com.bizunited.platform.titan.starter.configuration.flowable.process.ProcessAsyncHistory;
import java.io.IOException;
import java.util.List;
import javax.sql.DataSource;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.cfg.IdGenerator;
import org.flowable.common.engine.impl.persistence.StrongUuidGenerator;
import org.flowable.common.spring.SpringEngineConfiguration;
import org.flowable.engine.DynamicBpmnService;
import org.flowable.engine.FormService;
import org.flowable.engine.HistoryService;
import org.flowable.engine.IdentityService;
import org.flowable.engine.ManagementService;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.job.service.impl.asyncexecutor.AsyncExecutor;
import org.flowable.spring.ProcessEngineFactoryBean;
import org.flowable.spring.SpringProcessEngineConfiguration;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.Resource;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@EnableConfigurationProperties(value={FlowableProperties.class, FlowableMailProperties.class, FlowableProcessProperties.class})
@Import(value={FlowableJobConfiguration.class})
public class ProcessEngineAutoConfiguration
extends AbstractSpringEngineAutoConfiguration {
    protected final FlowableProcessProperties processProperties;
    protected final FlowableMailProperties mailProperties;

    public ProcessEngineAutoConfiguration(FlowableProperties flowableProperties, FlowableProcessProperties processProperties, FlowableMailProperties mailProperties) {
        super(flowableProperties);
        this.processProperties = processProperties;
        this.mailProperties = mailProperties;
    }

    @Bean
    public RuntimeService runtimeServiceBean(ProcessEngine processEngine) {
        return processEngine.getRuntimeService();
    }

    @Bean
    public RepositoryService repositoryServiceBean(ProcessEngine processEngine) {
        return processEngine.getRepositoryService();
    }

    @Bean
    public TaskService taskServiceBean(ProcessEngine processEngine) {
        return processEngine.getTaskService();
    }

    @Bean
    public HistoryService historyServiceBean(ProcessEngine processEngine) {
        return processEngine.getHistoryService();
    }

    @Bean
    public ManagementService managementServiceBean(ProcessEngine processEngine) {
        return processEngine.getManagementService();
    }

    @Bean
    public DynamicBpmnService dynamicBpmnServiceBean(ProcessEngine processEngine) {
        return processEngine.getDynamicBpmnService();
    }

    @Bean
    public FormService formServiceBean(ProcessEngine processEngine) {
        return processEngine.getFormService();
    }

    @Bean
    public IdentityService identityServiceBean(ProcessEngine processEngine) {
        return processEngine.getIdentityService();
    }

    @Bean
    public SpringProcessEngineConfiguration springProcessEngineConfiguration(DataSource dataSource, PlatformTransactionManager platformTransactionManager, @Process ObjectProvider<IdGenerator> processIdGenerator, ObjectProvider<IdGenerator> globalIdGenerator, @ProcessAsync ObjectProvider<AsyncExecutor> asyncExecutorProvider, @ProcessAsyncHistory ObjectProvider<AsyncExecutor> asyncHistoryExecutorProvider) throws IOException {
        AsyncExecutor springAsyncHistoryExecutor;
        AsyncExecutor springAsyncExecutor;
        SpringProcessEngineConfiguration conf = new SpringProcessEngineConfiguration();
        List<Resource> resources = this.discoverDeploymentResources(this.flowableProperties.getProcessDefinitionLocationPrefix(), this.flowableProperties.getProcessDefinitionLocationSuffixes(), this.flowableProperties.isCheckProcessDefinitions());
        if (resources != null && !resources.isEmpty()) {
            conf.setDeploymentResources(resources.toArray(new Resource[0]));
            conf.setDeploymentName(this.flowableProperties.getDeploymentName());
        }
        if ((springAsyncExecutor = (AsyncExecutor)asyncExecutorProvider.getIfUnique()) != null) {
            conf.setAsyncExecutor(springAsyncExecutor);
        }
        if ((springAsyncHistoryExecutor = (AsyncExecutor)asyncHistoryExecutorProvider.getIfUnique()) != null) {
            conf.setAsyncHistoryEnabled(true);
            conf.setAsyncHistoryExecutor(springAsyncHistoryExecutor);
        }
        this.configureSpringEngine((SpringEngineConfiguration)conf, platformTransactionManager);
        this.configureEngine((AbstractEngineConfiguration)conf, dataSource);
        conf.setDeploymentName(this.defaultText(this.flowableProperties.getDeploymentName(), conf.getDeploymentName()));
        conf.setDisableIdmEngine(false);
        conf.setAsyncExecutorActivate(this.flowableProperties.isAsyncExecutorActivate());
        conf.setAsyncHistoryExecutorActivate(this.flowableProperties.isAsyncHistoryExecutorActivate());
        conf.setMailServerHost(this.mailProperties.getHost());
        conf.setMailServerPort(this.mailProperties.getPort());
        conf.setMailServerUsername(this.mailProperties.getUsername());
        conf.setMailServerPassword(this.mailProperties.getPassword());
        conf.setMailServerDefaultFrom(this.mailProperties.getDefaultFrom());
        conf.setMailServerForceTo(this.mailProperties.getForceTo());
        conf.setMailServerUseSSL(this.mailProperties.isUseSsl());
        conf.setMailServerUseTLS(this.mailProperties.isUseTls());
        conf.setEnableProcessDefinitionHistoryLevel(this.processProperties.isEnableProcessDefinitionHistoryLevel());
        conf.setProcessDefinitionCacheLimit(this.processProperties.getDefinitionCacheLimit());
        conf.setEnableSafeBpmnXml(this.processProperties.isEnableSafeXml());
        conf.setHistoryLevel(this.flowableProperties.getHistoryLevel());
        conf.setActivityFontName(this.flowableProperties.getActivityFontName());
        conf.setAnnotationFontName(this.flowableProperties.getAnnotationFontName());
        conf.setLabelFontName(this.flowableProperties.getLabelFontName());
        IdGenerator idGenerator = this.getIfAvailable(processIdGenerator, globalIdGenerator);
        if (idGenerator == null) {
            idGenerator = new StrongUuidGenerator();
        }
        conf.setIdGenerator(idGenerator);
        return conf;
    }

    @Configuration
    static class StandaloneEngineConfiguration
    extends BaseEngineConfigurationWithConfigurers<SpringProcessEngineConfiguration> {
        StandaloneEngineConfiguration() {
        }

        @Bean
        public ProcessEngineFactoryBean processEngine(SpringProcessEngineConfiguration configuration) throws Exception {
            ProcessEngineFactoryBean processEngineFactoryBean = new ProcessEngineFactoryBean();
            processEngineFactoryBean.setProcessEngineConfiguration((ProcessEngineConfigurationImpl)configuration);
            this.invokeConfigurers(configuration);
            return processEngineFactoryBean;
        }
    }
}

