/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.service.internal;

import com.bizunited.platform.core.service.file.NebulaFileService;
import com.bizunited.platform.core.service.image.FileUpdateService;
import com.bizunited.platform.rbac.server.vo.UserVo;
import com.bizunited.platform.titan.starter.entity.ProcessInstanceAttachmentEntity;
import com.bizunited.platform.titan.starter.entity.ProcessInstanceEntity;
import com.bizunited.platform.titan.starter.repository.ProcessInstanceAttachmentRepository;
import com.bizunited.platform.titan.starter.service.ProcessInstanceAttachmentService;
import com.bizunited.platform.titan.starter.service.ProcessInstanceService;
import com.bizunited.platform.titan.starter.service.internal.BaseService;
import com.google.common.collect.Sets;
import java.security.Principal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="ProcessInstanceAttachmentServiceImpl")
public class ProcessInstanceAttachmentServiceImpl
extends BaseService
implements ProcessInstanceAttachmentService {
    @Autowired
    private ProcessInstanceAttachmentRepository processInstanceAttachmentRepository;
    @Autowired
    private FileUpdateService fileUpdateService;
    @Autowired
    private NebulaFileService nebulaFileService;
    @Autowired
    private ProcessInstanceService processInstanceService;

    private void createValidation(Set<ProcessInstanceAttachmentEntity> attachments) {
        Validate.notEmpty(attachments, (String)"\u4fdd\u5b58\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        HashSet<String> fileNames = new HashSet<String>();
        for (ProcessInstanceAttachmentEntity attachment : attachments) {
            Validate.isTrue((attachment.getId() == null ? 1 : 0) != 0, (String)"\u521b\u5efa\u5bf9\u8c61\u4e0d\u80fd\u6709ID", (Object[])new Object[0]);
            Validate.notNull((Object)attachment.getFileName(), (String)"\u6e90\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)attachment.getFileRename(), (String)"\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)attachment.getFileCode(), (String)"\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((!fileNames.contains(attachment.getFileName()) ? 1 : 0) != 0, (String)"\u91cd\u590d\u7684\u6587\u4ef6\uff1a%s", (Object[])new Object[]{attachment.getFileName()});
            fileNames.add(attachment.getFileName());
        }
    }

    @Override
    @Transactional
    public Set<ProcessInstanceAttachmentEntity> create(String processInstanceId, Set<ProcessInstanceAttachmentEntity> attachments, Principal principal) {
        Validate.notBlank((CharSequence)processInstanceId, (String)"\u6d41\u7a0b\u5b9e\u4f8bID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ProcessInstanceEntity processInstance = this.processInstanceService.findByProcessInstanceId(processInstanceId);
        Validate.notNull((Object)((Object)processInstance), (String)"\u672a\u627e\u5230\u6d41\u7a0b\u5b9e\u4f8b\u5bf9\u8c61", (Object[])new Object[0]);
        UserVo user = this.getLoginUser(principal);
        if (attachments == null) {
            attachments = new HashSet<ProcessInstanceAttachmentEntity>();
        }
        this.createValidation(attachments);
        Set<ProcessInstanceAttachmentEntity> oldAttachments = this.findDetailsByProcessInstanceId(processInstanceId);
        String[] fileRenames = new String[attachments.size()];
        int index = 0;
        for (ProcessInstanceAttachmentEntity attachment : attachments) {
            fileRenames[index] = StringUtils.join((Object[])new String[]{attachment.getFileCode(), "/", attachment.getFileRename()});
            attachment.setCreateUser(user);
            attachment.setCreateAccount(user.getAccount());
            attachment.setProcessInstance(processInstance);
            attachment.setCreateTime(new Date());
            this.processInstanceAttachmentRepository.save((Object)attachment);
            oldAttachments.add(attachment);
            ++index;
        }
        this.fileUpdateService.updateEffective(fileRenames);
        return oldAttachments;
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ProcessInstanceAttachmentEntity attachment = this.processInstanceAttachmentRepository.findDetailById(id);
        if (attachment != null) {
            this.processInstanceAttachmentRepository.deleteById(id);
            this.processInstanceAttachmentRepository.flush();
            this.nebulaFileService.deleteFile(attachment.getFileCode(), attachment.getFileName(), attachment.getFileRename());
        }
    }

    @Override
    public Set<ProcessInstanceAttachmentEntity> findDetailsByProcessInstanceId(String processInstanceId) {
        if (StringUtils.isBlank((CharSequence)processInstanceId)) {
            return Sets.newHashSet();
        }
        Set<ProcessInstanceAttachmentEntity> attachments = this.processInstanceAttachmentRepository.findDetailsByProcessInstanceId(processInstanceId);
        this.loadUser(attachments);
        return attachments;
    }

    private void loadUser(Set<ProcessInstanceAttachmentEntity> attachments) {
        if (CollectionUtils.isEmpty(attachments)) {
            return;
        }
        for (ProcessInstanceAttachmentEntity attachment : attachments) {
            UserVo user = super.getUserByAccount(attachment.getCreateAccount());
            attachment.setCreateUser(user);
        }
    }
}

