/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.service.internal;

import com.bizunited.platform.rbac.server.vo.UserVo;
import com.bizunited.platform.titan.starter.common.enums.TaskOperateBtn;
import com.bizunited.platform.titan.starter.entity.ProcessInstanceEntity;
import com.bizunited.platform.titan.starter.entity.ProcessInstanceMsgEntity;
import com.bizunited.platform.titan.starter.repository.ProcessInstanceMsgRepository;
import com.bizunited.platform.titan.starter.service.ProcessInstanceMsgService;
import com.bizunited.platform.titan.starter.service.internal.BaseService;
import com.google.common.collect.Lists;
import java.security.Principal;
import java.util.Date;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="ProcessInstanceMsgServiceImpl")
public class ProcessInstanceMsgServiceImpl
extends BaseService
implements ProcessInstanceMsgService {
    @Autowired
    private ProcessInstanceMsgRepository processInstanceMsgRepository;

    private void createValidation(ProcessInstanceMsgEntity msg) {
        Validate.notNull((Object)((Object)msg), (String)"\u4fdd\u5b58\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)msg.getContent(), (String)"\u6d88\u606f\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)msg.getProcessInstance()), (String)"\u6d41\u7a0b\u5b9e\u4f8b\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)msg.getProcessInstance().getId(), (String)"\u6d41\u7a0b\u5b9e\u4f8bID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public ProcessInstanceMsgEntity create(UserVo user, ProcessInstanceEntity processInstance, String content, TaskOperateBtn operateBtn) {
        ProcessInstanceMsgEntity msg = new ProcessInstanceMsgEntity();
        msg.setSendUser(user);
        msg.setSendAccount(user.getAccount());
        msg.setProcessInstance(processInstance);
        msg.setContent(content);
        msg.setOperation(operateBtn.getBtn());
        msg.setCreateTime(new Date());
        this.createValidation(msg);
        this.processInstanceMsgRepository.save((Object)msg);
        return msg;
    }

    @Override
    @Transactional
    public ProcessInstanceMsgEntity create(ProcessInstanceMsgEntity msg, Principal principal) {
        this.createValidation(msg);
        UserVo user = super.getLoginUser(principal);
        msg.setSendUser(user);
        msg.setSendAccount(user.getAccount());
        msg.setOperation(TaskOperateBtn.BTN_017.getBtn());
        msg.setCreateTime(new Date());
        this.processInstanceMsgRepository.save((Object)msg);
        return msg;
    }

    @Override
    public List<ProcessInstanceMsgEntity> findByProcessInstanceId(String processInstanceId) {
        if (StringUtils.isBlank((CharSequence)processInstanceId)) {
            return Lists.newArrayList();
        }
        List<ProcessInstanceMsgEntity> msgs = this.processInstanceMsgRepository.findByProcessInstanceId(processInstanceId);
        this.setIgnoreNullAndLoadUser(msgs);
        return msgs;
    }

    private void setIgnoreNullAndLoadUser(List<ProcessInstanceMsgEntity> msgs) {
        if (CollectionUtils.isEmpty(msgs)) {
            return;
        }
        for (ProcessInstanceMsgEntity msg : msgs) {
            msg.setProcessInstance(null);
            msg.setParent(null);
            UserVo user = super.getUserByAccount(msg.getSendAccount());
            if (user != null) {
                user.setGroups(null);
                user.setOrgs(null);
                user.setPositions(null);
                user.setRoles(null);
            }
            msg.setSendUser(user);
            this.setIgnoreNullAndLoadUser(msg.getReplyMsgs());
        }
    }
}

