/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.service.internal;

import com.bizunited.platform.core.service.file.NebulaFileService;
import com.bizunited.platform.rbac.server.vo.UserVo;
import com.bizunited.platform.titan.starter.common.enums.MultiType;
import com.bizunited.platform.titan.starter.common.enums.ProcessFormType;
import com.bizunited.platform.titan.starter.common.enums.ProcessListenerExecuteMode;
import com.bizunited.platform.titan.starter.common.enums.ProcessTemplateNodeAssignmentType;
import com.bizunited.platform.titan.starter.common.enums.ProcessTemplateState;
import com.bizunited.platform.titan.starter.entity.ProcessAssignmentEntity;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateEntity;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateListenerEntity;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateNodeAssignmentEntity;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateNodeEntity;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateNodeMultiEntity;
import com.bizunited.platform.titan.starter.entity.ProcessTemplatePermissionEntity;
import com.bizunited.platform.titan.starter.entity.ProcessVariableEntity;
import com.bizunited.platform.titan.starter.repository.ProcessTemplateRepository;
import com.bizunited.platform.titan.starter.service.ProcessAssignmentService;
import com.bizunited.platform.titan.starter.service.ProcessCheckRecordService;
import com.bizunited.platform.titan.starter.service.ProcessTemplateListenerService;
import com.bizunited.platform.titan.starter.service.ProcessTemplateNodeService;
import com.bizunited.platform.titan.starter.service.ProcessTemplatePermissionService;
import com.bizunited.platform.titan.starter.service.ProcessTemplateService;
import com.bizunited.platform.titan.starter.service.ProcessVariableService;
import com.bizunited.platform.titan.starter.service.internal.BaseService;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.flowable.bpmn.converter.BpmnXMLConverter;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EndEvent;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.api.io.InputStreamProvider;
import org.flowable.common.engine.impl.util.io.BytesStreamSource;
import org.flowable.common.engine.impl.util.io.StringStreamSource;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.ProcessDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="ProcessTemplateServiceImpl")
public class ProcessTemplateServiceImpl
extends BaseService
implements ProcessTemplateService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessTemplateServiceImpl.class);
    private static final String XML_FILE_SUFFIX = "xml";
    @Autowired
    private ProcessTemplateRepository processTemplateRepository;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private NebulaFileService kuiperFileService;
    @Autowired
    private ProcessVariableService processVariableService;
    @Autowired
    private ProcessAssignmentService processAssignmentService;
    @Autowired
    private ProcessCheckRecordService processCheckRecordService;
    @Autowired
    private ProcessTemplateNodeService processTemplateNodeService;
    @Autowired
    private ProcessTemplateListenerService processTemplateListenerService;
    @Autowired
    private ProcessTemplatePermissionService processTemplatePermissionService;

    @Override
    public Page<ProcessTemplateEntity> findByConditions(Pageable pageable, ProcessTemplateEntity processTemplate) {
        return this.processTemplateRepository.findByConditions(pageable, processTemplate);
    }

    private void createValidation(ProcessTemplateEntity processTemplateEntity) {
        Validate.notNull((Object)((Object)processTemplateEntity), (String)"\u4fdd\u5b58\u5bf9\u8c61\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((processTemplateEntity.getId() == null ? 1 : 0) != 0, (String)"\u521b\u5efa\u6570\u636e\u4e0d\u80fd\u6709ID", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTemplateEntity.getProcessKey(), (String)"\u6d41\u7a0bKey\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((processTemplateEntity.getCversion() > 0 ? 1 : 0) != 0, (String)"\u6d41\u7a0b\u7248\u672c\u53f7\u4e0d\u80fd\u5c0f\u4e8e1", (Object[])new Object[0]);
        if (processTemplateEntity.getCversion().equals(1)) {
            Long count = this.processTemplateRepository.countByProcessKey(processTemplateEntity.getProcessKey());
            Validate.isTrue((count == null || count == 0L ? 1 : 0) != 0, (String)"\u6d41\u7a0bKey\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362", (Object[])new Object[0]);
        }
        Validate.notBlank((CharSequence)processTemplateEntity.getProcessName(), (String)"\u6d41\u7a0b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTemplateEntity.getProcessXml(), (String)"\u6d41\u7a0b\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)processTemplateEntity.getFormType(), (String)"\u8868\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (ProcessFormType.FORM_TEMPLATE.getType().equals(processTemplateEntity.getFormType())) {
            Validate.notBlank((CharSequence)processTemplateEntity.getFormTemplateId(), (String)"\u8868\u5355\u6a21\u7248Id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        } else if (ProcessFormType.FORM_URL.getType().equals(processTemplateEntity.getFormType())) {
            Validate.notBlank((CharSequence)processTemplateEntity.getFormUrl(), (String)"\u8868\u5355\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)processTemplateEntity.getFormCreateType(), (String)"\u8868\u5355\u6a21\u7248\u5b9e\u4f8b\u521b\u5efa\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        this.validateProcessXml(processTemplateEntity, false);
    }

    private void validateProcessXml(ProcessTemplateEntity processTemplateEntity, boolean isDeploy) {
        BpmnModel bpmnModel;
        StringStreamSource inputStreamProvider = new StringStreamSource(processTemplateEntity.getProcessXml(), StandardCharsets.UTF_8.name());
        BpmnXMLConverter bpmnXMLConverter = new BpmnXMLConverter();
        try {
            bpmnModel = bpmnXMLConverter.convertToBpmnModel((InputStreamProvider)inputStreamProvider, true, false, StandardCharsets.UTF_8.name());
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u89e3\u6790\u6d41\u7a0b\u6587\u4ef6\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u6d41\u7a0b\u6587\u4ef6", e);
        }
        Process process = bpmnModel.getProcessById(processTemplateEntity.getProcessKey());
        Validate.notNull((Object)process, (String)"\u6d41\u7a0bkey\u4e0e\u6d41\u7a0b\u6587\u4ef6ID\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Collection flowElements = process.getFlowElements();
        List userTasks = flowElements.stream().filter(f -> f instanceof UserTask).collect(Collectors.toList());
        if (isDeploy || !CollectionUtils.isEmpty(userTasks)) {
            Validate.notEmpty(userTasks, (String)"\u6d41\u7a0b\u5fc5\u987b\u6709\u4e00\u4e2a\u8282\u70b9", (Object[])new Object[0]);
            UserTask userTask = (UserTask)userTasks.get(0);
            Validate.isTrue((boolean)userTask.getId().equals("DEFAULT_START"), (String)"\u53d1\u8d77\u8282\u70b9\u7684ID\u5fc5\u987b\u4e3a\uff1a%s", (Object[])new Object[]{"DEFAULT_START"});
            Validate.isTrue((boolean)"${applicantUser}".equals(userTask.getAssignee()), (String)"\u53d1\u8d77\u8282\u70b9\u7684\u5ba1\u6279\u503c\u5fc5\u987b\u4e3a\uff1a%s", (Object[])new Object[]{"${applicantUser}"});
        }
    }

    @Override
    @Transactional
    public ProcessTemplateEntity create(ProcessTemplateEntity processTemplateEntity, Principal principal, int cvertion) {
        processTemplateEntity.setCversion(cvertion);
        UserVo creator = super.getLoginUser(principal);
        this.createValidation(processTemplateEntity);
        Date nowDate = new Date();
        processTemplateEntity.setCreateUser(creator);
        processTemplateEntity.setCreateAccount(creator.getAccount());
        processTemplateEntity.setProcessState(ProcessTemplateState.DRAFT.getState());
        processTemplateEntity.setCreateTime(nowDate);
        processTemplateEntity.setModifyUser(creator);
        processTemplateEntity.setModifyAccount(creator.getAccount());
        processTemplateEntity.setModifyTime(nowDate);
        processTemplateEntity.setLastVersion(true);
        processTemplateEntity.setLastDeployedVersion(false);
        String folderName = new SimpleDateFormat("yyyyMMdd").format(nowDate);
        String renameImage = UUID.randomUUID().toString();
        String fileRename = renameImage + "." + XML_FILE_SUFFIX;
        String relativePath = StringUtils.join((Object[])new Serializable[]{"/process/xml/", folderName, "/", Integer.valueOf(new Random().nextInt(100) % 10)});
        byte[] processContent = processTemplateEntity.getProcessXml().getBytes(StandardCharsets.UTF_8);
        this.kuiperFileService.saveFile(relativePath, fileRename, fileRename, processContent);
        processTemplateEntity.setFilePath(relativePath);
        processTemplateEntity.setFileName(fileRename);
        this.processTemplateRepository.save((Object)processTemplateEntity);
        if (processTemplateEntity.getPermissions() != null) {
            this.processTemplatePermissionService.create(processTemplateEntity, processTemplateEntity.getPermissions());
        }
        if (processTemplateEntity.getProcessTemplateNodes() != null) {
            this.processTemplateNodeService.create(processTemplateEntity, processTemplateEntity.getProcessTemplateNodes());
        }
        if (processTemplateEntity.getProcessTemplateListeners() != null) {
            this.processTemplateListenerService.create(processTemplateEntity, processTemplateEntity.getProcessTemplateListeners());
        }
        Set<ProcessVariableEntity> variables = this.processVariableService.save(processTemplateEntity.getId(), processTemplateEntity.getVariables());
        processTemplateEntity.setVariables(variables);
        return processTemplateEntity;
    }

    private void updateValidation(ProcessTemplateEntity processTemplateEntity) {
        Validate.notNull((Object)((Object)processTemplateEntity), (String)"\u4fdd\u5b58\u5bf9\u8c61\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTemplateEntity.getProcessKey(), (String)"\u6d41\u7a0bKey\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (processTemplateEntity.getCversion().equals(1)) {
            Long count = this.processTemplateRepository.countByProcessKeyWithoutId(processTemplateEntity.getProcessKey(), processTemplateEntity.getId());
            Validate.isTrue((count == null || count == 0L ? 1 : 0) != 0, (String)"\u6d41\u7a0bKey\u91cd\u590d\uff0c\u8bf7\u66f4\u6362", (Object[])new Object[0]);
        }
        Validate.notBlank((CharSequence)processTemplateEntity.getProcessName(), (String)"\u6d41\u7a0b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTemplateEntity.getProcessXml(), (String)"\u6d41\u7a0b\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)processTemplateEntity.getFormType(), (String)"\u8868\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (ProcessFormType.FORM_TEMPLATE.getType().equals(processTemplateEntity.getFormType())) {
            Validate.notBlank((CharSequence)processTemplateEntity.getFormTemplateId(), (String)"\u8868\u5355\u6a21\u7248Id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)processTemplateEntity.getFormCreateType(), (String)"\u8868\u5355\u6a21\u7248\u5b9e\u4f8b\u521b\u5efa\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        } else if (ProcessFormType.FORM_URL.getType().equals(processTemplateEntity.getFormType())) {
            Validate.notBlank((CharSequence)processTemplateEntity.getFormUrl(), (String)"\u8868\u5355\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        this.validateProcessXml(processTemplateEntity, false);
    }

    @Override
    @Transactional
    public ProcessTemplateEntity update(ProcessTemplateEntity processTemplateEntity, Principal principal) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)processTemplateEntity.getId()), (String)"\u66f4\u65b0\u6570\u636e\u5fc5\u987b\u8981\u6709ID", (Object[])new Object[0]);
        UserVo user = super.getLoginUser(principal);
        ProcessTemplateEntity updateTemplate = this.processTemplateRepository.findDetailsById(processTemplateEntity.getId());
        Validate.notNull((Object)((Object)updateTemplate), (String)"\u66f4\u65b0\u5bf9\u8c61\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((boolean)updateTemplate.getProcessState().equals(ProcessTemplateState.DRAFT.getState()), (String)"\u5df2\u53d1\u5e03\u7684\u6d41\u7a0b\u6a21\u7248\u4e0d\u80fd\u8fdb\u884c\u7f16\u8f91", (Object[])new Object[0]);
        processTemplateEntity.setCversion(updateTemplate.getCversion());
        this.updateValidation(processTemplateEntity);
        ProcessTemplateEntity lastDeployedVersion = this.processTemplateRepository.findLastDeployVersionByProcessKey(updateTemplate.getProcessKey());
        if (lastDeployedVersion != null) {
            Validate.isTrue((boolean)lastDeployedVersion.getProcessKey().equals(processTemplateEntity.getProcessKey()), (String)"\u6d41\u7a0bkey\u5fc5\u987b\u4e0e\u5df2\u53d1\u5e03\u7684\u6a21\u7248\u4e00\u81f4", (Object[])new Object[0]);
        }
        updateTemplate.setModifyTime(new Date());
        updateTemplate.setModifyUser(user);
        updateTemplate.setModifyAccount(user.getAccount());
        updateTemplate.setFormName(processTemplateEntity.getFormName());
        updateTemplate.setFormVersion(processTemplateEntity.getFormVersion());
        updateTemplate.setProcessName(processTemplateEntity.getProcessName());
        updateTemplate.setProcessKey(processTemplateEntity.getProcessKey());
        updateTemplate.setFormUrl(processTemplateEntity.getFormUrl());
        updateTemplate.setFormCallBackUrl(processTemplateEntity.getFormCallBackUrl());
        updateTemplate.setFormTemplateId(processTemplateEntity.getFormTemplateId());
        updateTemplate.setFormType(processTemplateEntity.getFormType());
        updateTemplate.setProcessDoc(processTemplateEntity.getProcessDoc());
        updateTemplate.setProcessXml(processTemplateEntity.getProcessXml());
        updateTemplate.setOnSubmitScript(processTemplateEntity.getOnSubmitScript());
        updateTemplate.setFormCreateType(processTemplateEntity.getFormCreateType());
        byte[] processContent = processTemplateEntity.getProcessXml().getBytes(StandardCharsets.UTF_8);
        String fileName = updateTemplate.getFileName();
        this.kuiperFileService.saveFile(updateTemplate.getFilePath(), fileName, fileName, processContent);
        this.processTemplateRepository.save((Object)updateTemplate);
        this.processTemplatePermissionService.update(processTemplateEntity, processTemplateEntity.getPermissions());
        this.processTemplateNodeService.update(processTemplateEntity, processTemplateEntity.getProcessTemplateNodes());
        this.processTemplateListenerService.update(processTemplateEntity, processTemplateEntity.getProcessTemplateListeners());
        Set<ProcessVariableEntity> variables = this.processVariableService.save(updateTemplate.getId(), processTemplateEntity.getVariables());
        updateTemplate.setVariables(variables);
        return updateTemplate;
    }

    @Override
    public ProcessTemplateEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ProcessTemplateEntity processTemplate = this.processTemplateRepository.findDetailsById(id);
        if (processTemplate == null) {
            return null;
        }
        return this.loadDetails(processTemplate);
    }

    private ProcessTemplateEntity loadDetails(ProcessTemplateEntity processTemplate) {
        Set<ProcessTemplateNodeEntity> nodes = this.processTemplateNodeService.findDetailsByProcessTemplateId(processTemplate.getId());
        Set<ProcessTemplatePermissionEntity> permissions = this.processTemplatePermissionService.findByProcessTemplateId(processTemplate.getId());
        Set<ProcessTemplateListenerEntity> listeners = this.processTemplateListenerService.findDetailsByProcessTemplateId(processTemplate.getId());
        Set<ProcessVariableEntity> variables = this.processVariableService.findBySourceId(processTemplate.getId());
        UserVo creator = super.getUserByAccount(processTemplate.getCreateAccount());
        UserVo modifyUser = super.getUserByAccount(processTemplate.getModifyAccount());
        processTemplate.setCreateUser(creator);
        processTemplate.setModifyUser(modifyUser);
        processTemplate.setProcessTemplateNodes(nodes);
        processTemplate.setPermissions(permissions);
        processTemplate.setProcessTemplateListeners(listeners);
        processTemplate.setVariables(variables);
        String fileName = processTemplate.getFileName();
        byte[] bytes = this.kuiperFileService.readFileContent(processTemplate.getFilePath(), fileName);
        if (bytes != null && bytes.length > 0) {
            try {
                processTemplate.setProcessXml(new String(bytes, StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        return processTemplate;
    }

    @Override
    public ProcessTemplateEntity findDetailsByProcessInstanceId(String processInstanceId) {
        if (StringUtils.isBlank((CharSequence)processInstanceId)) {
            return null;
        }
        ProcessTemplateEntity processTemplate = this.processTemplateRepository.findDetailsByProcessInstanceId(processInstanceId);
        if (processTemplate == null) {
            return null;
        }
        return this.loadDetails(processTemplate);
    }

    @Override
    @Transactional
    public ProcessTemplateEntity upgradeVersion(ProcessTemplateEntity processTemplate, Principal principal) {
        Validate.notBlank((CharSequence)processTemplate.getProcessKey(), (String)"\u6d41\u7a0bkey\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        UserVo user = super.getLoginUser(principal);
        ProcessTemplateEntity lastVersion = this.processTemplateRepository.findLastVersionByProcessKey(processTemplate.getProcessKey());
        Validate.notNull((Object)((Object)lastVersion), (String)"\u65e0\u53ef\u7528\u4e8e\u5347\u7ea7\u7684\u6d41\u7a0b\u6a21\u7248", (Object[])new Object[0]);
        Validate.isTrue((boolean)lastVersion.getProcessState().equals(ProcessTemplateState.PUBLISHED.getState()), (String)"\u5f53\u524d\u6d41\u7a0b\u6a21\u7248\u5b58\u5728\u8349\u7a3f\u6a21\u7248\uff0c\u8bf7\u5728\u8349\u7a3f\u6a21\u7248\u4e0a\u8fdb\u884c\u7f16\u8f91", (Object[])new Object[0]);
        int newVersion = lastVersion.getCversion() + 1;
        lastVersion.setModifyUser(user);
        lastVersion.setModifyAccount(user.getAccount());
        lastVersion.setModifyTime(new Date());
        lastVersion.setLastVersion(false);
        this.processTemplateRepository.save((Object)lastVersion);
        processTemplate.setProcessDefinitionId(null);
        processTemplate.setDeployTime(null);
        processTemplate.setId(null);
        processTemplate.getPermissions().forEach(permission -> permission.setId(null));
        if (!CollectionUtils.isEmpty(processTemplate.getProcessTemplateListeners())) {
            processTemplate.getProcessTemplateListeners().forEach(listener -> {
                listener.setId(null);
                if (listener.getVariables() != null) {
                    listener.getVariables().forEach(v -> v.setId(null));
                }
            });
        }
        if (!CollectionUtils.isEmpty(processTemplate.getProcessTemplateNodes())) {
            processTemplate.getProcessTemplateNodes().forEach(node -> {
                node.setId(null);
                if (node.getAssignment() != null) {
                    node.getAssignment().setId(null);
                    if (node.getAssignment().getVariables() != null) {
                        node.getAssignment().getVariables().forEach(v -> v.setId(null));
                    }
                }
                if (node.getProcessTemplateNodeMulti() != null) {
                    node.getProcessTemplateNodeMulti().setId(null);
                    if (!CollectionUtils.isEmpty(node.getProcessTemplateNodeMulti().getAssignments())) {
                        for (ProcessAssignmentEntity assignment : node.getProcessTemplateNodeMulti().getAssignments()) {
                            assignment.setId(null);
                        }
                    }
                }
            });
        }
        return this.create(processTemplate, principal, newVersion);
    }

    @Override
    public List<ProcessTemplateEntity> findByProcessKey(String processKey) {
        if (StringUtils.isBlank((CharSequence)processKey)) {
            return Collections.emptyList();
        }
        Sort sort = new Sort(Sort.Direction.DESC, new String[]{"cversion"});
        return this.processTemplateRepository.findByProcessKey(processKey, sort);
    }

    @Override
    @Transactional
    public void deploy(String id, Principal principal) {
        Validate.notBlank((CharSequence)id, (String)"ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        UserVo user = super.getLoginUser(principal);
        ProcessTemplateEntity processTemplate = this.findDetailsById(id);
        this.deployValidation(processTemplate);
        ProcessTemplateEntity lastDeployedVersion = this.processTemplateRepository.findLastDeployVersionByProcessKey(processTemplate.getProcessKey());
        if (lastDeployedVersion != null) {
            lastDeployedVersion.setModifyTime(new Date());
            lastDeployedVersion.setModifyUser(user);
            lastDeployedVersion.setModifyAccount(user.getAccount());
            lastDeployedVersion.setLastDeployedVersion(false);
            this.processTemplateRepository.save((Object)lastDeployedVersion);
        }
        String deployName = processTemplate.getProcessKey() + ".bpmn";
        Deployment deployment = this.repositoryService.createDeployment().addString(deployName, processTemplate.getProcessXml()).name(processTemplate.getProcessKey()).key(processTemplate.getProcessKey()).deploy();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).latestVersion().singleResult();
        processTemplate.setLastDeployedVersion(true);
        processTemplate.setModifyTime(new Date());
        processTemplate.setModifyUser(user);
        processTemplate.setModifyAccount(user.getAccount());
        processTemplate.setDeployTime(new Date());
        processTemplate.setProcessDefinitionId(processDefinition.getId());
        processTemplate.setProcessState(ProcessTemplateState.PUBLISHED.getState());
        this.processTemplateRepository.save((Object)processTemplate);
    }

    @Override
    @Transactional
    public void deleteById(String id, Principal principal) {
        Validate.notBlank((CharSequence)id, (String)"ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        UserVo user = super.getLoginUser(principal);
        Optional op = this.processTemplateRepository.findById(id);
        ProcessTemplateEntity processTemplate = op.orElse(null);
        if (processTemplate == null) {
            return;
        }
        Validate.isTrue((boolean)processTemplate.getProcessState().equals(ProcessTemplateState.DRAFT.getState()), (String)"\u6d41\u7a0b\u5df2\u53d1\u5e03\uff0c\u4e0d\u80fd\u5220\u9664", (Object[])new Object[0]);
        ProcessTemplateEntity lastDeployedVersion = this.processTemplateRepository.findLastDeployVersionByProcessKey(processTemplate.getProcessKey());
        if (lastDeployedVersion != null) {
            lastDeployedVersion.setLastVersion(true);
            lastDeployedVersion.setModifyUser(user);
            lastDeployedVersion.setModifyAccount(user.getAccount());
            lastDeployedVersion.setModifyTime(new Date());
            this.processTemplateRepository.save((Object)lastDeployedVersion);
        }
        this.processCheckRecordService.deleteByTemplateId(id);
        this.processTemplateRepository.delete((Object)processTemplate);
        String fileName = processTemplate.getFileName();
        this.kuiperFileService.deleteFile(processTemplate.getFilePath(), fileName, fileName);
    }

    @Override
    public ProcessTemplateEntity findById(String id) {
        Optional op = this.processTemplateRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    public Page<ProcessTemplateEntity> findStartableByConditions(Pageable pageable, ProcessTemplateEntity processTemplate, Principal principal) {
        if (principal == null) {
            return null;
        }
        UserVo user = super.getLoginUser(principal);
        UserVo userVo = this.userService.findDetailsById(user.getId());
        return this.processTemplateRepository.findStartableByConditions(pageable, processTemplate, userVo);
    }

    @Override
    public String getEndActivityId(ProcessTemplateEntity processTemplate) {
        Validate.notNull((Object)((Object)processTemplate), (String)"\u6d41\u7a0b\u6a21\u7248\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processTemplate.getProcessDefinitionId());
        Process process = bpmnModel.getProcessById(processTemplate.getProcessKey());
        Collection flowElements = process.getFlowElements();
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof EndEvent)) continue;
            return flowElement.getId();
        }
        throw new IllegalArgumentException("\u672a\u627e\u5230\u6d41\u7a0b\u7ed3\u675f\u8282\u70b9");
    }

    @Override
    public List<String> getStartEventAndOutLine(Process process) {
        ArrayList<String> activities = new ArrayList<String>();
        Collection flowElements = process.getFlowElements();
        String startEventId = null;
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof StartEvent)) continue;
            startEventId = flowElement.getId();
            activities.add(startEventId);
            break;
        }
        if (startEventId != null) {
            for (FlowElement flowElement : flowElements) {
                SequenceFlow sequenceFlow;
                if (!(flowElement instanceof SequenceFlow) || !(sequenceFlow = (SequenceFlow)flowElement).getSourceFlowElement().getId().equals(startEventId)) continue;
                activities.add(sequenceFlow.getId());
                break;
            }
        }
        return activities;
    }

    @Override
    public FlowElement findFlowElement(String processDefinitionId, String taskDefinitionKey) {
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
        Validate.notNull((Object)bpmnModel, (String)"\u672a\u627e\u5230\u6d41\u7a0b\u5b9a\u4e49[%s]", (Object[])new Object[]{processDefinitionId});
        Process process = (Process)bpmnModel.getProcesses().get(0);
        return process.getFlowElement(taskDefinitionKey);
    }

    @Override
    public String findProcessXmlById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.processTemplateRepository.findById(id);
        ProcessTemplateEntity template = op.orElse(null);
        Validate.notNull((Object)((Object)template), (String)"\u672a\u627e\u5230\u6d41\u7a0b\u6a21\u7248\u5bf9\u8c61", (Object[])new Object[0]);
        byte[] bytes = this.kuiperFileService.readFileContent(template.getFilePath(), template.getFileName());
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @Override
    public BpmnModel findBpmnById(String id) {
        BpmnModel bpmnModel;
        Optional op = this.processTemplateRepository.findById(id);
        ProcessTemplateEntity template = op.orElse(null);
        Validate.notNull((Object)((Object)template), (String)"\u672a\u627e\u5230\u6d41\u7a0b\u6a21\u7248\u5bf9\u8c61", (Object[])new Object[0]);
        byte[] bytes = this.kuiperFileService.readFileContent(template.getFilePath(), template.getFileName());
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        BytesStreamSource inputStreamProvider = new BytesStreamSource(bytes);
        BpmnXMLConverter bpmnXMLConverter = new BpmnXMLConverter();
        try {
            bpmnModel = bpmnXMLConverter.convertToBpmnModel((InputStreamProvider)inputStreamProvider, true, false, StandardCharsets.UTF_8.name());
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            return null;
        }
        return bpmnModel;
    }

    @Override
    public void loadUser(ProcessTemplateEntity template) {
        if (template == null) {
            return;
        }
        UserVo creator = super.getUserByAccount(template.getCreateAccount());
        UserVo modifyUser = super.getUserByAccount(template.getModifyAccount());
        template.setCreateUser(creator);
        template.setModifyUser(modifyUser);
    }

    @Override
    public ProcessTemplateEntity findLatestDeployByProcessKey(String processKey) {
        Validate.notBlank((CharSequence)processKey, (String)"\u6d41\u7a0bkey\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.processTemplateRepository.findLastDeployVersionByProcessKey(processKey);
    }

    private void deployValidation(ProcessTemplateEntity processTemplate) {
        Validate.notNull((Object)((Object)processTemplate), (String)"\u6d41\u7a0b\u6a21\u7248\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((boolean)processTemplate.getProcessState().equals(ProcessTemplateState.DRAFT.getState()), (String)"\u6d41\u7a0b\u6a21\u7248\u5df2\u53d1\u5e03\uff0c\u4e0d\u80fd\u91cd\u590d\u53d1\u5e03", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTemplate.getProcessKey(), (String)"\u6d41\u7a0bKey\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTemplate.getProcessName(), (String)"\u6d41\u7a0b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processTemplate.getProcessXml(), (String)"\u6d41\u7a0b\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)processTemplate.getFormType(), (String)"\u8868\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (ProcessFormType.FORM_TEMPLATE.getType().equals(processTemplate.getFormType())) {
            Validate.notBlank((CharSequence)processTemplate.getFormTemplateId(), (String)"\u8868\u5355\u6a21\u7248Id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        } else if (ProcessFormType.FORM_URL.getType().equals(processTemplate.getFormType())) {
            Validate.notBlank((CharSequence)processTemplate.getFormUrl(), (String)"\u8868\u5355\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        Set<ProcessTemplateNodeEntity> nodes = processTemplate.getProcessTemplateNodes();
        Validate.isTrue((!CollectionUtils.isEmpty(nodes) ? 1 : 0) != 0, (String)"\u6d41\u7a0b\u5fc5\u987b\u5305\u542b\u4e00\u4e2a\u8282\u70b9", (Object[])new Object[0]);
        HashSet<String> nodeIds = new HashSet<String>();
        for (ProcessTemplateNodeEntity node : nodes) {
            boolean isMultiAssignment;
            Validate.notBlank((CharSequence)node.getProcessNodeId(), (String)"\u8282\u70b9ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)node.getProcessNodeName(), (String)"\u8282\u70b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            if (ProcessFormType.FORM_TEMPLATE.getType().equals(processTemplate.getFormType())) {
                Validate.notBlank((CharSequence)node.getFormVisibilityName(), (String)"\u6d41\u7a0b\u8282\u70b9\u5fc5\u987b\u9009\u62e9\u8868\u5355\u53ef\u89c1\u6027", (Object[])new Object[0]);
            }
            Validate.isTrue((!nodeIds.contains(node.getProcessNodeId()) ? 1 : 0) != 0, (String)"\u8282\u70b9ID\u4e0d\u80fd\u91cd\u590d", (Object[])new Object[0]);
            nodeIds.add(node.getProcessNodeId());
            ProcessTemplateNodeMultiEntity nodeMulti = node.getProcessTemplateNodeMulti();
            if (nodeMulti != null) {
                Validate.notNull((Object)nodeMulti.getMiType(), (String)"\u4f1a\u7b7e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                if (!nodeMulti.getMiType().equals(MultiType.NONE_MULTI.getType())) {
                    Validate.notNull((Object)nodeMulti.getPresetMiAssignments(), (String)"\u662f\u5426\u9884\u7f6e\u4f1a\u7b7e\u4eba\u5458\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    Validate.notNull((Object)nodeMulti.getCompletionCondition(), (String)"\u4f1a\u7b7e\u901a\u8fc7\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    if (Boolean.TRUE.equals(nodeMulti.getPresetMiAssignments())) {
                        Validate.notEmpty(nodeMulti.getAssignments(), (String)"\u672a\u914d\u7f6e\u4f1a\u7b7e\u4eba\u5458", (Object[])new Object[0]);
                        for (ProcessAssignmentEntity processAssignmentEntity : nodeMulti.getAssignments()) {
                            this.processAssignmentService.valid(processAssignmentEntity.getAssignment());
                        }
                    }
                }
            }
            if (!(isMultiAssignment = nodeMulti == null || nodeMulti.getMiType().equals(MultiType.NONE_MULTI.getType()) || !nodeMulti.getMiType().equals(MultiType.NONE_MULTI.getType()) && CollectionUtils.isEmpty(nodeMulti.getAssignments()))) continue;
            ProcessTemplateNodeAssignmentEntity processTemplateNodeAssignmentEntity = node.getAssignment();
            Validate.notNull((Object)((Object)processTemplateNodeAssignmentEntity), (String)"\u6d41\u7a0b\u8282\u70b9\u5fc5\u987b\u914d\u7f6e\u5ba1\u6279\u4eba", (Object[])new Object[0]);
            Validate.notNull((Object)processTemplateNodeAssignmentEntity.getType(), (String)"\u5ba1\u6279\u4eba\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            if (processTemplateNodeAssignmentEntity.getType().equals(ProcessTemplateNodeAssignmentType.USERNAME.getType()) || processTemplateNodeAssignmentEntity.getType().equals(ProcessTemplateNodeAssignmentType.EXPRESSION.getType())) {
                Validate.notNull(processTemplateNodeAssignmentEntity.getVariables(), (String)"\u6d41\u7a0b\u8282\u70b9[%s]\u672a\u914d\u7f6e\u5ba1\u6279\u53d8\u91cf", (Object[])new Object[]{node.getProcessNodeId()});
                continue;
            }
            if (!processTemplateNodeAssignmentEntity.getType().equals(ProcessTemplateNodeAssignmentType.LISTENER.getType())) continue;
            Validate.notNull((Object)((Object)processTemplateNodeAssignmentEntity.getProcessListener()), (String)"\u6d41\u7a0b\u8282\u70b9[%s]\u672a\u914d\u7f6e\u5ba1\u6279\u4eba\u76d1\u542c\u5668", (Object[])new Object[]{node.getProcessNodeId()});
            if (!processTemplateNodeAssignmentEntity.getProcessListener().getExecuteMode().equals(ProcessListenerExecuteMode.SCRIPT.getMode())) continue;
            Validate.notNull((Object)processTemplateNodeAssignmentEntity.getScript(), (String)"\u6d41\u7a0b\u8282\u70b9[%s]\u672a\u914d\u7f6e\u5ba1\u6279\u4eba\u76d1\u542c\u5668\u811a\u672c", (Object[])new Object[]{node.getProcessNodeId()});
        }
        Validate.notNull(processTemplate.getPermissions(), (String)"\u6d41\u7a0b\u6a21\u7248\u672a\u914d\u7f6e\u6743\u9650\u4fe1\u606f", (Object[])new Object[0]);
        Set<ProcessTemplatePermissionEntity> permissions = processTemplate.getPermissions();
        for (ProcessTemplatePermissionEntity permission : permissions) {
            if (permission.getType() <= 0) continue;
            Validate.notBlank((CharSequence)permission.getPermissionValue(), (String)"\u6d41\u7a0b\u6a21\u7248\u672a\u914d\u7f6e\u6743\u9650\u503c", (Object[])new Object[0]);
        }
        if (!CollectionUtils.isEmpty(processTemplate.getProcessTemplateListeners())) {
            for (ProcessTemplateListenerEntity listener : processTemplate.getProcessTemplateListeners()) {
                Validate.notBlank((CharSequence)listener.getTargetId(), (String)"\u76d1\u542c\u5668\u914d\u7f6e\u6d41\u7a0b\u5143\u7d20ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notNull((Object)((Object)listener.getProcessListener()), (String)"\u76d1\u542c\u5668\u914d\u7f6e\u76d1\u542c\u5668\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                if (!listener.getProcessListener().getExecuteMode().equals(ProcessListenerExecuteMode.SCRIPT.getMode())) continue;
                Validate.notNull((Object)listener.getScript(), (String)"\u811a\u672c\u76d1\u542c\u5668\u672a\u914d\u7f6e\u811a\u672c\u4fe1\u606f", (Object[])new Object[0]);
            }
        }
        this.validateProcessXml(processTemplate, true);
    }
}

