/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.repository;

import com.bizunited.platform.titan.starter.entity.ProcessTemplateEntity;
import com.bizunited.platform.titan.starter.repository.internal.ProcessTemplateRepositoryCustom;
import java.util.List;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository(value="ProcessTemplateRepository")
public interface ProcessTemplateRepository
extends JpaRepository<ProcessTemplateEntity, String>,
JpaSpecificationExecutor<ProcessTemplateEntity>,
ProcessTemplateRepositoryCustom {
    @Query(value="select count(*) from ProcessTemplateEntity pt where pt.processKey = :processKey")
    public Long countByProcessKey(@Param(value="processKey") String var1);

    @Query(value="select count(*) from ProcessTemplateEntity pt where pt.processKey = :processKey and pt.id <> :id")
    public Long countByProcessKeyWithoutId(@Param(value="processKey") String var1, @Param(value="id") String var2);

    @Query(value="select distinct pt from ProcessTemplateEntity pt left join fetch pt.onSubmitScript ss where pt.id = :id")
    public ProcessTemplateEntity findDetailsById(@Param(value="id") String var1);

    @Query(value="select distinct pt from ProcessInstanceEntity pi inner join pi.processTemplate pt left join fetch pt.onSubmitScript ss where pi.processInstanceId = :processInstanceId")
    public ProcessTemplateEntity findDetailsByProcessInstanceId(@Param(value="processInstanceId") String var1);

    @Query(value="from ProcessTemplateEntity pt where pt.isLastDeployedVersion = 1 and pt.processKey = :processKey")
    public ProcessTemplateEntity findLastDeployVersionByProcessKey(@Param(value="processKey") String var1);

    @Query(value="from ProcessTemplateEntity pt where pt.isLastVersion = 1 and pt.processKey = :processKey")
    public ProcessTemplateEntity findLastVersionByProcessKey(@Param(value="processKey") String var1);

    public List<ProcessTemplateEntity> findByProcessKey(String var1, Sort var2);
}

