/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.repository.internal;

import com.bizunited.platform.titan.starter.entity.ProcessListenerEntity;
import com.bizunited.platform.titan.starter.repository.internal.ProcessListenerRepositoryCustom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class ProcessListenerRepositoryImpl
implements ProcessListenerRepositoryCustom {
    @Autowired
    private EntityManager entityManager;

    @Override
    public Page<ProcessListenerEntity> findByConditions(ProcessListenerEntity processListener, Pageable pageable) {
        StringBuilder hql = new StringBuilder("select pl from ProcessListenerEntity pl where 1=1 ");
        StringBuilder countHql = new StringBuilder("select count(*) from ProcessListenerEntity pl where 1=1 ");
        StringBuilder condition = new StringBuilder();
        HashMap<String, Object> parameter = new HashMap<String, Object>(16);
        if (StringUtils.isNotBlank((CharSequence)processListener.getListenerEvent())) {
            condition.append(" and pl.listenerEvent = :listenerEvent");
            parameter.put("listenerEvent", processListener.getListenerEvent());
        }
        if (StringUtils.isNotBlank((CharSequence)processListener.getName())) {
            condition.append(" and pl.name = :name");
            parameter.put("name", processListener.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)processListener.getListenerClass())) {
            condition.append(" and pl.listenerClass = :listenerClass");
            parameter.put("listenerClass", processListener.getListenerClass());
        }
        if (processListener.getState() != null) {
            condition.append(" and pl.state = :state");
            parameter.put("state", processListener.getState());
        }
        if (processListener.getType() != null) {
            condition.append(" and pl.type = :type");
            parameter.put("type", processListener.getType());
        }
        if (processListener.getExecuteMode() != null) {
            condition.append(" and pl.executeMode = :executeMode");
            parameter.put("executeMode", processListener.getExecuteMode());
        }
        hql.append((CharSequence)condition);
        countHql.append((CharSequence)condition);
        Query query = this.entityManager.createQuery(hql.toString());
        Query countQuery = this.entityManager.createQuery(countHql.toString());
        parameter.forEach((k, v) -> {
            query.setParameter(k, v);
            countQuery.setParameter(k, v);
        });
        query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
        query.setMaxResults(pageable.getPageSize());
        List result = new ArrayList();
        long count = (Long)countQuery.getResultList().get(0);
        if (count > 0L) {
            result = query.getResultList();
        }
        return new PageImpl(result, pageable, count);
    }
}

