/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.service.internal;

import com.bizunited.platform.rbac.server.service.PositionService;
import com.bizunited.platform.rbac.server.service.UserService;
import com.bizunited.platform.rbac.server.vo.PositionVo;
import com.bizunited.platform.rbac.server.vo.UserVo;
import java.security.Principal;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.util.CollectionUtils;

public class BaseService {
    @Autowired
    protected UserService userService;
    @Autowired
    protected PositionService positionService;
    private static final String ERROR_USER_INFO = "\u767b\u5f55\u4eba\u4e0d\u5b58\u5728\uff0c\u6216\u767b\u5f55\u4fe1\u606f\u5df2\u5931\u6548!";

    public UserVo getLoginUser(Principal principal) {
        Validate.notNull((Object)principal, (String)"\u672a\u767b\u5f55\u7cfb\u7edf", (Object[])new Object[0]);
        String userAccount = principal.getName();
        Validate.notBlank((CharSequence)userAccount, (String)ERROR_USER_INFO, (Object[])new Object[0]);
        UserVo user = this.getUserByAccount(principal.getName());
        Validate.notNull((Object)user, (String)ERROR_USER_INFO, (Object[])new Object[0]);
        return user;
    }

    public UserVo getUserByAccount(String account) {
        if (StringUtils.isBlank((CharSequence)account)) {
            return null;
        }
        return this.userService.findByAccount(account);
    }

    public PositionVo findPositionByCode(String positionCode) {
        List positionVos;
        if (StringUtils.isBlank((CharSequence)positionCode)) {
            return null;
        }
        Page page = this.positionService.findByConditions(positionCode, null, null, null);
        if (page != null && !CollectionUtils.isEmpty((Collection)(positionVos = page.getContent()))) {
            return (PositionVo)positionVos.get(0);
        }
        return null;
    }
}

