/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.service.internal;

import com.bizunited.platform.titan.starter.entity.ProcessListenerEntity;
import com.bizunited.platform.titan.starter.repository.ProcessListenerRepository;
import com.bizunited.platform.titan.starter.service.ProcessListenerService;
import java.util.Date;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service(value="ProcessListenerServiceImpl")
public class ProcessListenerServiceImpl
implements ProcessListenerService {
    @Autowired
    private ProcessListenerRepository processListenerRepository;

    @Override
    public Page<ProcessListenerEntity> findByConditions(ProcessListenerEntity processListener, Pageable pageable) {
        return this.processListenerRepository.findByConditions(processListener, pageable);
    }

    private void createValidation(ProcessListenerEntity processListener) {
        Validate.notNull((Object)((Object)processListener), (String)"\u521b\u5efa\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((processListener.getId() == null ? 1 : 0) != 0, (String)"\u521b\u5efa\u5bf9\u8c61\u4e0d\u80fd\u6709ID", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processListener.getListenerEvent(), (String)"\u4e8b\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)processListener.getState(), (String)"\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.inclusiveBetween((long)0L, (long)1L, (long)processListener.getState().intValue(), (String)"\u72b6\u6001\u975e\u6cd5");
        Validate.notBlank((CharSequence)processListener.getName(), (String)"\u76d1\u542c\u5668\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processListener.getListenerClass(), (String)"\u76d1\u542c\u5668\u7c7b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)processListener.getType(), (String)"\u76d1\u542c\u5668\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.inclusiveBetween((long)1L, (long)3L, (long)processListener.getType().intValue(), (String)"\u76d1\u542c\u5668\u7c7b\u578b\u4e0d\u5408\u6cd5");
        Validate.notNull((Object)processListener.getExecuteMode(), (String)"\u6267\u884c\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.inclusiveBetween((long)0L, (long)1L, (long)processListener.getExecuteMode().intValue(), (String)"\u6267\u884c\u65b9\u5f0f\u4e0d\u5408\u6cd5");
        Long count = this.processListenerRepository.countByName(processListener.getName());
        Validate.isTrue((count == null || count == 0L ? 1 : 0) != 0, (String)"\u76d1\u542c\u5668\u540d\u79f0\u91cd\u590d:%s", (Object[])new Object[]{processListener.getName()});
    }

    @Override
    @Transactional
    public ProcessListenerEntity create(ProcessListenerEntity processListener) {
        this.createValidation(processListener);
        processListener.setCreateTime(new Date());
        processListener.setModifyTime(new Date());
        return (ProcessListenerEntity)((Object)this.processListenerRepository.save((Object)processListener));
    }

    private void updateValidation(ProcessListenerEntity processListener) {
        Validate.notNull((Object)((Object)processListener), (String)"\u66f4\u65b0\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processListener.getId(), (String)"\u66f4\u65b0\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ProcessListenerEntity listenerEntity = this.processListenerRepository.findById(processListener.getId()).orElse(null);
        Validate.notNull((Object)((Object)listenerEntity), (String)"\u66f4\u65b0\u5bf9\u8c61\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processListener.getListenerEvent(), (String)"\u4e8b\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processListener.getName(), (String)"\u76d1\u542c\u5668\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processListener.getListenerClass(), (String)"\u76d1\u542c\u5668\u7c7b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)processListener.getType(), (String)"\u76d1\u542c\u5668\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.inclusiveBetween((long)1L, (long)3L, (long)processListener.getType().intValue(), (String)"\u76d1\u542c\u5668\u7c7b\u578b\u4e0d\u5408\u6cd5");
        Validate.notNull((Object)processListener.getExecuteMode(), (String)"\u6267\u884c\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.inclusiveBetween((long)0L, (long)1L, (long)processListener.getExecuteMode().intValue(), (String)"\u6267\u884c\u65b9\u5f0f\u4e0d\u5408\u6cd5");
        Validate.isTrue((processListener.getExecuteMode() == 0 ? 1 : 0) != 0, (String)"\u811a\u672c\u76d1\u542c\u5668\u4e0d\u80fd\u7f16\u8f91", (Object[])new Object[0]);
        Long count = this.processListenerRepository.countByNameExclusiveId(processListener.getName(), processListener.getId());
        Validate.isTrue((count == null || count == 0L ? 1 : 0) != 0, (String)"\u76d1\u542c\u5668\u540d\u79f0\u91cd\u590d:%s", (Object[])new Object[]{processListener.getName()});
    }

    @Override
    @Transactional
    public ProcessListenerEntity update(ProcessListenerEntity processListener) {
        this.updateValidation(processListener);
        ProcessListenerEntity oldListener = this.processListenerRepository.findById(processListener.getId()).orElse(null);
        Validate.notNull((Object)((Object)oldListener), (String)"\u4e3a\u627e\u5230\u9700\u8981\u66f4\u65b0\u7684\u76d1\u542c\u5668\uff01", (Object[])new Object[0]);
        processListener.setModifyTime(new Date());
        processListener.setCreateTime(oldListener.getCreateTime());
        return (ProcessListenerEntity)((Object)this.processListenerRepository.save((Object)processListener));
    }

    @Override
    @Transactional
    public void handleState(String id, Integer state) {
        Validate.notBlank((CharSequence)id, (String)"ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)state, (String)"\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.inclusiveBetween((long)0L, (long)1L, (long)state.intValue(), (String)"\u72b6\u6001\u975e\u6cd5");
        ProcessListenerEntity listener = this.processListenerRepository.findById(id).orElse(null);
        Validate.notNull((Object)((Object)listener), (String)"\u66f4\u65b0\u5bf9\u8c61\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((listener.getExecuteMode() == 0 || state == 1 ? 1 : 0) != 0, (String)"\u811a\u672c\u76d1\u542c\u5668\u4e0d\u80fd\u7981\u7528", (Object[])new Object[0]);
        if (!listener.getState().equals(state)) {
            listener.setState(state);
            this.processListenerRepository.save((Object)listener);
        }
    }

    @Override
    public ProcessListenerEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.processListenerRepository.findById(id).orElse(null);
    }
}

