/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.common.PlatformContext;
import com.bizunited.platform.core.service.invoke.InvokeProxy;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.serviceable.model.InputParamsModel;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.service.TemplateService;
import com.bizunited.platform.rbac.server.vo.UserVo;
import com.bizunited.platform.titan.starter.command.ProphesyMultiCompletionBeforeRejectCommand;
import com.bizunited.platform.titan.starter.common.Constants;
import com.bizunited.platform.titan.starter.common.enums.ProcessFormType;
import com.bizunited.platform.titan.starter.common.enums.ProcessInstanceState;
import com.bizunited.platform.titan.starter.common.enums.TaskOperateBtn;
import com.bizunited.platform.titan.starter.entity.ProcessAssignmentEntity;
import com.bizunited.platform.titan.starter.entity.ProcessCarbonCopyEntity;
import com.bizunited.platform.titan.starter.entity.ProcessInstanceEntity;
import com.bizunited.platform.titan.starter.entity.ProcessInstanceOperateRecordEntity;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateEntity;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateNodeEntity;
import com.bizunited.platform.titan.starter.repository.internal.ExecutionRepositoryCustom;
import com.bizunited.platform.titan.starter.repository.internal.HistoricActivityInstanceRepositoryCustom;
import com.bizunited.platform.titan.starter.repository.internal.ProcessTaskRepositoryCustom;
import com.bizunited.platform.titan.starter.service.ProcessAssignmentService;
import com.bizunited.platform.titan.starter.service.ProcessCarbonCopyService;
import com.bizunited.platform.titan.starter.service.ProcessInstanceOperateRecordService;
import com.bizunited.platform.titan.starter.service.ProcessInstanceService;
import com.bizunited.platform.titan.starter.service.ProcessTaskService;
import com.bizunited.platform.titan.starter.service.ProcessTemplateNodeService;
import com.bizunited.platform.titan.starter.service.ProcessTemplateService;
import com.bizunited.platform.titan.starter.service.internal.BaseService;
import com.bizunited.platform.titan.starter.service.invoke.model.ProcessInputParamsModel;
import com.bizunited.platform.titan.starter.vo.TaskVo;
import com.google.common.collect.Sets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.MultiInstanceLoopCharacteristics;
import org.flowable.bpmn.model.ParallelGateway;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.engine.HistoryService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.history.HistoricActivityInstance;
import org.flowable.engine.history.HistoricActivityInstanceQuery;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.impl.RuntimeServiceImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityImpl;
import org.flowable.engine.runtime.Execution;
import org.flowable.engine.runtime.ExecutionQuery;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskInfo;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.flowable.task.service.impl.persistence.entity.TaskEntityImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="ProcessTaskServiceImpl")
public class ProcessTaskServiceImpl
extends BaseService
implements ProcessTaskService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessTaskServiceImpl.class);
    @Autowired
    private ExecutionRepositoryCustom executionRepositoryCustom;
    @Autowired
    private ProcessTaskRepositoryCustom processTaskRepositoryCustom;
    @Autowired
    private HistoricActivityInstanceRepositoryCustom historicActivityInstanceRepositoryCustom;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private TaskService taskService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private PlatformContext platformContext;
    @Autowired(required=false)
    private TemplateService templateService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ProcessInstanceService processInstanceService;
    @Autowired
    private ProcessTemplateService processTemplateService;
    @Autowired
    private ProcessAssignmentService processAssignmentService;
    @Autowired
    private ProcessCarbonCopyService processCarbonCopyService;
    @Autowired
    private ProcessTemplateNodeService processTemplateNodeService;
    @Autowired
    private ProcessInstanceOperateRecordService processInstanceOperateRecordService;

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Object handleTask(ProcessInputParamsModel model) throws InvokeProxyException {
        Validate.notNull((Object)model, (String)"\u5982\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)model.getBtn(), (String)"btn\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)model.getProcessInstanceId(), (String)"\u6d41\u7a0b\u5b9e\u4f8bID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ProcessInstanceEntity processInstance = this.processInstanceService.findByProcessInstanceId(model.getProcessInstanceId());
        Validate.notNull((Object)((Object)processInstance), (String)"\u672a\u627e\u5230\u6d41\u7a0b\u5b9e\u4f8b\u5bf9\u8c61", (Object[])new Object[0]);
        ProcessTemplateEntity processTemplate = processInstance.getProcessTemplate();
        Validate.notNull((Object)((Object)processTemplate), (String)"\u672a\u627e\u5230\u6d41\u7a0b\u6a21\u7248\u5bf9\u8c61", (Object[])new Object[0]);
        Object result = null;
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put(ProcessInputParamsModel.class.getName(), model);
        if (processTemplate.getFormType().equals(ProcessFormType.FORM_TEMPLATE.getType()) && !this.isRecoveryOperate(model.getBtn())) {
            Validate.isTrue((boolean)this.platformContext.isEnableKuiper(), (String)"\u7cfb\u7edf\u672a\u542f\u7528\u8868\u5355\u5f15\u64ce\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (Object[])new Object[0]);
            TemplateEntity formTemplate = this.templateService.findById(processTemplate.getFormTemplateId());
            Validate.notNull((Object)formTemplate, (String)"\u672a\u627e\u5230\u8868\u5355\u6a21\u7248\u5bf9\u8c61", (Object[])new Object[0]);
            if ("static".equals(formTemplate.getType())) {
                params.put(InputParamsModel.class.getName(), model.getInputParamsModel());
                InvokeProxy invokeProxy = (InvokeProxy)this.applicationContext.getBean("ProcessOperateAndWriteFormServicableProxy");
                result = invokeProxy.doHandle(params);
            } else if ("dynamic".equals(formTemplate.getType())) {
                InputParamsModel inputParamsModel = model.getInputParamsModel();
                JSONObject formData = inputParamsModel.getFormData();
                String opType = "update";
                if (StringUtils.isBlank((CharSequence)formData.getString("id"))) {
                    opType = "create";
                }
                params.put("opType", opType);
                params.put("instanceActivityId", inputParamsModel.getInstanceActivityId());
                String formInstanceId = formData.getString("formInstanceId");
                params.put("formInstanceId", formInstanceId);
                params.put("formData", formData);
                InvokeProxy invokeProxy = (InvokeProxy)this.applicationContext.getBean("ProcessOperateAndDynamicFormWriteProxy");
                result = invokeProxy.doHandle(params);
            }
        } else {
            InvokeProxy invokeProxy = (InvokeProxy)this.applicationContext.getBean("ProcessOperateServicableProxy");
            result = invokeProxy.doHandle(params);
        }
        return result;
    }

    private boolean isRecoveryOperate(String btnCode) {
        TaskOperateBtn btn = Constants.getOperateBtn(btnCode);
        Validate.notNull((Object)((Object)btn), (String)"\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\uff1a%s", (Object[])new Object[]{btnCode});
        switch (btn) {
            case BTN_002: {
                return true;
            }
            case BTN_003: {
                return true;
            }
            case BTN_004: {
                return true;
            }
            case BTN_012: {
                return true;
            }
        }
        return false;
    }

    @Override
    @Transactional
    public void handleSubmitForm(String processInstanceId, Principal principal, Map<String, Object> variables) {
        Validate.notBlank((CharSequence)processInstanceId, (String)"processInstanceId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        UserVo user = super.getLoginUser(principal);
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).singleResult();
        Validate.notNull((Object)task, (String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((boolean)"DEFAULT_START".equals(task.getTaskDefinitionKey()), (String)"\u5f53\u524d\u4efb\u52a1\u8282\u70b9\u4e0d\u662f\u53d1\u8d77\u8282\u70b9", (Object[])new Object[0]);
        Validate.isTrue((boolean)this.processAssignmentService.equals(user, task.getAssignee()), (String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u5c5e\u4e8e\u5f53\u524d\u767b\u5f55\u4eba", (Object[])new Object[0]);
        ProcessInstanceEntity processInstance = this.processInstanceService.findByProcessInstanceId(task.getProcessInstanceId());
        Validate.notNull((Object)((Object)processInstance), (String)"\u6570\u636e\u5f02\u5e38\uff0c\u672a\u627e\u5230\u6d41\u7a0b\u5b9e\u4f8b\u5bf9\u8c61", (Object[])new Object[0]);
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstance.getProcessInstanceId())).list();
        this.taskService.complete(task.getId(), variables);
        Set<ProcessAssignmentEntity> nextAssignments = this.findCurrentAssignments(processInstance);
        Set<ProcessTemplateNodeEntity> nextNodes = this.findCurrentNodes(processInstance);
        ProcessTemplateNodeEntity currentNode = this.processTemplateNodeService.findByProcessTemplateIdAndProcessNodeId(processInstance.getProcessTemplate().getId(), task.getTaskDefinitionKey());
        processInstance.setLatestSubmitTime(task.getCreateTime());
        this.processInstanceService.update(processInstance, user, currentNode, nextAssignments, nextNodes, ProcessInstanceState.APPROVING.getState());
        this.processInstanceOperateRecordService.create(task, processInstance, user, TaskOperateBtn.BTN_011, "\u63d0\u4ea4\u7533\u8bf7");
        this.autoSkipTasks(tasks, processInstance, user);
    }

    @Override
    @Transactional
    public ProcessInstanceEntity handleComplete(String taskId, Principal principal, String content, Map<String, Object> variables) {
        Validate.notBlank((CharSequence)taskId, (String)"taskId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        UserVo user = super.getLoginUser(principal);
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        Validate.notNull((Object)task, (String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((!"DEFAULT_START".equals(task.getTaskDefinitionKey()) ? 1 : 0) != 0, (String)"\u53d1\u8d77\u8282\u70b9\u4e0d\u80fd\u505a\u5ba1\u6279\u64cd\u4f5c", (Object[])new Object[0]);
        Validate.isTrue((boolean)this.processAssignmentService.equals(user, task.getAssignee()), (String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u5c5e\u4e8e\u5f53\u524d\u767b\u5f55\u4eba", (Object[])new Object[0]);
        ProcessInstanceEntity processInstance = this.processInstanceService.findByProcessInstanceId(task.getProcessInstanceId());
        Validate.notNull((Object)((Object)processInstance), (String)"\u6570\u636e\u5f02\u5e38\uff0c\u672a\u627e\u5230\u6d41\u7a0b\u5b9e\u4f8b\u5bf9\u8c61", (Object[])new Object[0]);
        UserTask userTask = (UserTask)this.processTemplateService.findFlowElement(processInstance.getProcessTemplate().getProcessDefinitionId(), task.getTaskDefinitionKey());
        Validate.notNull((Object)userTask, (String)"\u672a\u627e\u5230\u7528\u6237\u4efb\u52a1\u8282\u70b9\u5b9a\u4e49\u3010%s\u3011", (Object[])new Object[]{task.getTaskDefinitionKey()});
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstance.getProcessInstanceId())).list();
        if (StringUtils.isBlank((CharSequence)content)) {
            content = TaskOperateBtn.BTN_001.getDesc();
        }
        this.taskService.setAssignee(task.getId(), task.getAssignee());
        this.taskService.complete(task.getId(), variables);
        this.handleSequentialMultiAfterComplete(processInstance, task, userTask);
        this.handleMultiAssignmentsAfterComplete(task, userTask);
        Set<ProcessAssignmentEntity> nextAssignments = this.findCurrentAssignments(processInstance);
        Set<ProcessTemplateNodeEntity> nextNodes = this.findCurrentNodes(processInstance);
        ProcessTemplateNodeEntity currentNode = this.processTemplateNodeService.findByProcessTemplateIdAndProcessNodeId(processInstance.getProcessTemplate().getId(), task.getTaskDefinitionKey());
        int state = processInstance.getProcessState();
        if (this.isProcessEnd(processInstance.getProcessInstanceId())) {
            state = ProcessInstanceState.COMPLETED.getState();
        }
        this.processInstanceService.update(processInstance, user, currentNode, nextAssignments, nextNodes, state);
        this.processInstanceOperateRecordService.create(task, processInstance, user, TaskOperateBtn.BTN_001, content);
        this.autoSkipTasks(tasks, processInstance, user);
        return processInstance;
    }

    private void handleSequentialMultiAfterComplete(ProcessInstanceEntity processInstance, Task task, UserTask userTask) {
        MultiInstanceLoopCharacteristics loopCharacteristics = userTask.getLoopCharacteristics();
        if (loopCharacteristics == null) {
            return;
        }
        Boolean isSequential = loopCharacteristics.isSequential();
        if (!isSequential.booleanValue()) {
            return;
        }
        ProcessTemplateNodeEntity node = this.processTemplateNodeService.findByProcessTemplateIdAndProcessNodeId(processInstance.getProcessTemplate().getId(), task.getTaskDefinitionKey());
        Validate.notNull((Object)((Object)node), (String)"\u672a\u627e\u5230\u8282\u70b9\u3010%s\u3011\u7684\u914d\u7f6e\u4fe1\u606f", (Object[])new Object[]{task.getTaskDefinitionKey()});
        Task nextTask = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(task.getProcessInstanceId())).taskDefinitionKey(task.getTaskDefinitionKey())).singleResult();
        if (nextTask == null) {
            return;
        }
        Execution processExecution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getProcessInstanceId()).onlyProcessInstanceExecutions().singleResult();
        String collection = StringUtils.join((Object[])new String[]{task.getTaskDefinitionKey(), "_mi_assignments"});
        List<String> miAssignments = this.getEditableMultiAssignments(processExecution.getId(), collection, false);
        int loopCounter = (Integer)this.runtimeService.getVariable(nextTask.getExecutionId(), "loopCounter");
        if (!node.getProcessTemplateNodeMulti().getPresetMiAssignments().booleanValue()) {
            --loopCounter;
        }
        String assignment = miAssignments.get(loopCounter);
        this.taskService.setAssignee(nextTask.getId(), assignment);
    }

    private void handleMultiAssignmentsAfterComplete(Task task, UserTask userTask) {
        MultiInstanceLoopCharacteristics loopCharacteristics = userTask.getLoopCharacteristics();
        if (loopCharacteristics == null) {
            return;
        }
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().executionId(task.getExecutionId()).singleResult();
        if (execution == null) {
            return;
        }
        String parentExecutionId = execution.getParentId();
        String collection = StringUtils.join((Object[])new String[]{task.getTaskDefinitionKey(), "_mi_completed_assignments"});
        List<String> completeAssignments = this.getEditableMultiAssignments(parentExecutionId, collection, true);
        completeAssignments.add(task.getAssignee());
        this.runtimeService.setVariableLocal(parentExecutionId, collection, completeAssignments);
    }

    private void autoSkipTasks(List<Task> excludeTasks, ProcessInstanceEntity processInstance, UserVo user) {
        Set excludeTaskSet = excludeTasks.stream().map(TaskInfo::getTaskDefinitionKey).collect(Collectors.toSet());
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstance.getProcessInstanceId())).list();
        if (CollectionUtils.isEmpty((Collection)tasks)) {
            return;
        }
        boolean haveSkipTask = false;
        Task latestSkipTask = null;
        for (Task task : tasks) {
            if (excludeTaskSet.contains(task.getTaskDefinitionKey()) || !this.autoSkipTask(processInstance, task, user)) continue;
            haveSkipTask = true;
            latestSkipTask = task;
        }
        if (haveSkipTask) {
            Set<ProcessAssignmentEntity> nextAssignments = this.findCurrentAssignments(processInstance);
            Set<ProcessTemplateNodeEntity> nextNodes = this.findCurrentNodes(processInstance);
            ProcessTemplateNodeEntity currentNode = this.processTemplateNodeService.findByProcessTemplateIdAndProcessNodeId(processInstance.getProcessTemplate().getId(), latestSkipTask.getTaskDefinitionKey());
            int state = processInstance.getProcessState();
            if (this.isProcessEnd(processInstance.getProcessInstanceId())) {
                state = ProcessInstanceState.COMPLETED.getState();
            }
            this.processInstanceService.update(processInstance, user, currentNode, nextAssignments, nextNodes, state);
            this.autoSkipTasks(excludeTasks, processInstance, user);
        }
    }

    private boolean autoSkipTask(ProcessInstanceEntity processInstance, Task task, UserVo user) {
        ProcessTemplateNodeEntity node = this.processTemplateNodeService.findByProcessTemplateIdAndProcessNodeId(processInstance.getProcessTemplate().getId(), task.getTaskDefinitionKey());
        boolean skip = false;
        String content = "\u81ea\u52a8\u8df3\u8fc7";
        UserVo operator = user;
        if (StringUtils.isBlank((CharSequence)task.getAssignee()) && node.getNullSkip().booleanValue()) {
            skip = true;
            this.taskService.complete(task.getId());
            content = "\u5ba1\u6279\u4eba\u4e3a\u7a7a\u81ea\u52a8\u8df3\u8fc7";
        }
        if (StringUtils.isNotBlank((CharSequence)task.getAssignee()) && Boolean.TRUE.equals(node.getRepeatSkip())) {
            Set<ProcessInstanceOperateRecordEntity> records;
            List taskInstances = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstance.getProcessInstanceId())).taskCompletedAfter(processInstance.getLatestSubmitTime()).taskAssignee(task.getAssignee())).orderByTaskCreateTime()).desc()).list();
            if (!CollectionUtils.isEmpty(taskInstances = taskInstances.stream().filter(t -> StringUtils.isBlank((CharSequence)t.getDeleteReason())).collect(Collectors.toList())) && !CollectionUtils.isEmpty(records = this.processInstanceOperateRecordService.findByTaskIdAndBtns(((HistoricTaskInstance)taskInstances.get(0)).getId(), TaskOperateBtn.BTN_001.getBtn()))) {
                skip = true;
                operator = records.iterator().next().getOperator();
                this.taskService.setAssignee(task.getId(), task.getAssignee());
                this.taskService.complete(task.getId());
                content = "\u5ba1\u6279\u4eba\u91cd\u590d\u5ba1\u6279\u81ea\u52a8\u8df3\u8fc7";
            }
        }
        if (skip) {
            this.processInstanceOperateRecordService.create(task, processInstance, operator, TaskOperateBtn.BTN_001, content);
        }
        return skip;
    }

    @Override
    @Transactional
    public void handleReject(String taskId, Principal principal, String content, Map<String, Object> variables) {
        Validate.notBlank((CharSequence)taskId, (String)"taskId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)content, (String)"\u5ba1\u6279\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        UserVo user = super.getLoginUser(principal);
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        Validate.notNull((Object)task, (String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((!"DEFAULT_START".equals(task.getTaskDefinitionKey()) ? 1 : 0) != 0, (String)"\u53d1\u8d77\u8282\u70b9\u4e0d\u80fd\u505a\u9a73\u56de\u64cd\u4f5c", (Object[])new Object[0]);
        Validate.isTrue((boolean)this.processAssignmentService.equals(user, task.getAssignee()), (String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u5c5e\u4e8e\u5f53\u524d\u767b\u5f55\u4eba", (Object[])new Object[0]);
        ProcessInstanceEntity processInstance = this.processInstanceService.findByProcessInstanceId(task.getProcessInstanceId());
        Validate.notNull((Object)((Object)processInstance), (String)"\u6570\u636e\u5f02\u5e38\uff0c\u672a\u627e\u5230\u6d41\u7a0b\u5b9e\u4f8b\u5bf9\u8c61", (Object[])new Object[0]);
        UserTask userTask = (UserTask)this.processTemplateService.findFlowElement(processInstance.getProcessTemplate().getProcessDefinitionId(), task.getTaskDefinitionKey());
        Validate.notNull((Object)userTask, (String)"\u672a\u627e\u5230\u7528\u6237\u4efb\u52a1\u8282\u70b9\u5b9a\u4e49\u3010%s\u3011", (Object[])new Object[]{task.getTaskDefinitionKey()});
        MultiInstanceLoopCharacteristics loopCharacteristics = userTask.getLoopCharacteristics();
        Boolean isMultiTask = false;
        Boolean isSequential = false;
        Boolean prophesyCompletion = false;
        if (loopCharacteristics != null) {
            isMultiTask = true;
            isSequential = loopCharacteristics.isSequential();
            if (!isSequential.booleanValue()) {
                prophesyCompletion = (Boolean)((RuntimeServiceImpl)this.runtimeService).getCommandExecutor().execute((Command)new ProphesyMultiCompletionBeforeRejectCommand(this.runtimeService, task, userTask, 1));
            }
        }
        if (isMultiTask.booleanValue() && !isSequential.booleanValue() && prophesyCompletion.booleanValue()) {
            Execution execution = (Execution)this.runtimeService.createExecutionQuery().executionId(task.getExecutionId()).singleResult();
            String executionId = task.getExecutionId();
            String parentExecutionId = execution.getParentId();
            Integer nrOfRejectedInstances = (Integer)this.runtimeService.getVariableLocal(parentExecutionId, "nrOfRejectedInstances");
            if (nrOfRejectedInstances == null) {
                nrOfRejectedInstances = 0;
            }
            nrOfRejectedInstances = nrOfRejectedInstances + 1;
            this.runtimeService.setVariableLocal(parentExecutionId, "nrOfRejectedInstances", (Object)nrOfRejectedInstances);
            String collection = StringUtils.join((Object[])new String[]{task.getTaskDefinitionKey(), "_mi_completed_assignments"});
            List<String> completeAssignments = this.getEditableMultiAssignments(parentExecutionId, collection, true);
            completeAssignments.add(task.getAssignee());
            this.runtimeService.setVariableLocal(parentExecutionId, collection, completeAssignments);
            TaskEntityImpl taskEntity = (TaskEntityImpl)task;
            taskEntity.setExecutionId(null);
            this.taskService.saveTask((Task)taskEntity);
            this.taskService.deleteTask(taskId, "\u4f1a\u7b7e\u9a73\u56de");
            this.historyService.deleteHistoricTaskInstance(taskId);
            this.executionRepositoryCustom.updateIsActiveById(executionId, 0);
            this.historicActivityInstanceRepositoryCustom.deleteByTaskId(taskId);
            this.processInstanceOperateRecordService.create(task, processInstance, user, TaskOperateBtn.BTN_002, content);
        } else {
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstance.getProcessInstanceId())).list();
            List activityIds = tasks.stream().map(TaskInfo::getTaskDefinitionKey).collect(Collectors.toCollection(() -> new ArrayList(tasks.size())));
            List deleteActivities = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getProcessInstanceId()).startedAfter(task.getCreateTime()).list();
            this.processInstanceService.initInstanceMulti(processInstance);
            this.runtimeService.createChangeActivityStateBuilder().processInstanceId(processInstance.getProcessInstanceId()).processVariables(variables).moveActivityIdsToSingleActivityId(activityIds, "DEFAULT_START").changeState();
            this.historicActivityInstanceRepositoryCustom.delete(deleteActivities);
            this.deleteParallelGetawayExecutions(processInstance);
            this.processInstanceOperateRecordService.create(task, processInstance, user, TaskOperateBtn.BTN_002, content);
            Set<ProcessAssignmentEntity> nextAssignments = this.findCurrentAssignments(processInstance);
            Set<ProcessTemplateNodeEntity> nextNodes = this.findCurrentNodes(processInstance);
            ProcessTemplateNodeEntity currentNode = this.processTemplateNodeService.findByProcessTemplateIdAndProcessNodeId(processInstance.getProcessTemplate().getId(), task.getTaskDefinitionKey());
            ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstance.getProcessInstanceId())).taskDefinitionKey("DEFAULT_START")).singleResult();
            processInstance.setLatestSubmitTime(new Date());
            this.processInstanceService.update(processInstance, user, currentNode, nextAssignments, nextNodes, ProcessInstanceState.REJECTED.getState());
        }
    }

    private void deleteParallelGetawayExecutions(ProcessInstanceEntity processInstance) {
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getProcessInstanceId()).list();
        if (CollectionUtils.isEmpty((Collection)executions)) {
            return;
        }
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processInstance.getProcessTemplate().getProcessDefinitionId());
        Validate.notNull((Object)bpmnModel, (String)"\u672a\u627e\u5230\u6d41\u7a0b\u5b9a\u4e49\u5bf9\u8c61", (Object[])new Object[0]);
        Process process = (Process)bpmnModel.getProcesses().get(0);
        for (Execution execution : executions) {
            FlowElement flowElement;
            if (StringUtils.isBlank((CharSequence)execution.getActivityId()) || !((flowElement = process.getFlowElement(execution.getActivityId())) instanceof ParallelGateway)) continue;
            this.executionRepositoryCustom.deleteRuExecutionById(execution.getId());
        }
    }

    @Override
    @Transactional
    public void handleTransferAssignee(String taskId, String targetAssignment, Principal principal, String content) {
        Validate.notBlank((CharSequence)taskId, (String)"taskId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)targetAssignment, (String)"\u8f6c\u529e\u76ee\u6807\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.processAssignmentService.valid(targetAssignment);
        UserVo user = super.getLoginUser(principal);
        Validate.isTrue((!this.processAssignmentService.equals(user, targetAssignment) ? 1 : 0) != 0, (String)"\u4efb\u52a1\u4eba\u4e0d\u80fd\u8f6c\u529e\u7ed9\u81ea\u5df1", (Object[])new Object[0]);
        ProcessAssignmentEntity assignment = this.processAssignmentService.findAssignment(targetAssignment);
        Validate.notNull((Object)((Object)assignment), (String)"\u672a\u627e\u5230\u8f6c\u529e\u4eba\uff1a%s", (Object[])new Object[]{targetAssignment});
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        Validate.notNull((Object)task, (String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((boolean)this.processAssignmentService.equals(user, task.getAssignee()), (String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u5c5e\u4e8e\u5f53\u524d\u767b\u5f55\u4eba", (Object[])new Object[0]);
        ProcessInstanceEntity processInstance = this.processInstanceService.findByProcessInstanceId(task.getProcessInstanceId());
        Validate.notNull((Object)((Object)processInstance), (String)"\u6570\u636e\u5f02\u5e38\uff0c\u672a\u627e\u5230\u6d41\u7a0b\u5b9e\u4f8b\u5bf9\u8c61", (Object[])new Object[0]);
        if (content == null) {
            content = "";
        }
        content = content + String.format("  \u7528\u6237\u4efb\u52a1\u8f6c\u529e\u7ed9\u4ee3\u7406\u4eba\u3010%s\u3011", assignment.getAssignmentName());
        this.processInstanceOperateRecordService.create(task, processInstance, user, TaskOperateBtn.BTN_007, content);
        this.taskService.setAssignee(taskId, targetAssignment);
    }

    @Override
    @Transactional
    public void handleBackTask(String taskId, String targetActivitiId, Principal principal, String content, Map<String, Object> variables) {
        Validate.notBlank((CharSequence)taskId, (String)"taskId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)content, (String)"\u5ba1\u6279\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)targetActivitiId, (String)"\u76ee\u6807\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((!"DEFAULT_START".equals(targetActivitiId) ? 1 : 0) != 0, (String)"\u4e0d\u80fd\u56de\u9000\u5230\u53d1\u8d77\u8282\u70b9", (Object[])new Object[0]);
        UserVo user = super.getLoginUser(principal);
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        Validate.notNull((Object)task, (String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((boolean)this.processAssignmentService.equals(user, task.getAssignee()), (String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u5c5e\u4e8e\u5f53\u524d\u767b\u5f55\u4eba", (Object[])new Object[0]);
        Validate.isTrue((!targetActivitiId.equals(task.getTaskDefinitionKey()) ? 1 : 0) != 0, (String)"\u56de\u9000\u8282\u70b9\u4e0d\u80fd\u662f\u5f53\u524d\u8282\u70b9", (Object[])new Object[0]);
        ProcessInstanceEntity processInstance = this.processInstanceService.findByProcessInstanceId(task.getProcessInstanceId());
        Validate.notNull((Object)((Object)processInstance), (String)"\u6570\u636e\u5f02\u5e38\uff0c\u672a\u627e\u5230\u6d41\u7a0b\u5b9e\u4f8b\u5bf9\u8c61", (Object[])new Object[0]);
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processInstance.getProcessTemplate().getProcessDefinitionId());
        Validate.notNull((Object)bpmnModel, (String)"\u672a\u627e\u5230\u53d1\u5e03\u7684\u6d41\u7a0b\u5b9a\u4e49\u5bf9\u8c61", (Object[])new Object[0]);
        this.validateBackTaskTargetActivity(processInstance, targetActivitiId);
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstance.getProcessInstanceId())).list();
        List activityIds = tasks.stream().map(TaskInfo::getTaskDefinitionKey).collect(Collectors.toCollection(() -> new ArrayList(tasks.size())));
        this.processInstanceService.initInstanceMulti(processInstance);
        this.runtimeService.createChangeActivityStateBuilder().processInstanceId(processInstance.getProcessInstanceId()).processVariables(variables).moveActivityIdsToSingleActivityId(activityIds, targetActivitiId).changeState();
        this.handleGetaway(bpmnModel, processInstance, task.getTaskDefinitionKey(), targetActivitiId);
        this.deleteHistoricActivityInstanceAfterActivity(bpmnModel, processInstance, targetActivitiId);
        Set<ProcessAssignmentEntity> nextAssignments = this.findCurrentAssignments(processInstance);
        Set<ProcessTemplateNodeEntity> nextNodes = this.findCurrentNodes(processInstance);
        ProcessTemplateNodeEntity currentNode = this.processTemplateNodeService.findByProcessTemplateIdAndProcessNodeId(processInstance.getProcessTemplate().getId(), task.getTaskDefinitionKey());
        this.processInstanceService.update(processInstance, user, currentNode, nextAssignments, nextNodes, processInstance.getProcessState());
        this.processInstanceOperateRecordService.create(task, processInstance, user, TaskOperateBtn.BTN_003, content);
    }

    private void handleGetaway(BpmnModel bpmnModel, ProcessInstanceEntity processInstance, String activityId, String targetActivityId) {
        Process process = (Process)bpmnModel.getProcesses().get(0);
        FlowElement flowElement = process.getFlowElement(targetActivityId);
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getProcessInstanceId()).list();
        HashMap<String, List> executionMap = new HashMap<String, List>(8);
        for (Execution execution : executions) {
            if (StringUtils.isBlank((CharSequence)execution.getActivityId()) || !(process.getFlowElement(execution.getActivityId()) instanceof ParallelGateway)) continue;
            ArrayList<Execution> list = (ArrayList<Execution>)executionMap.get(execution.getActivityId());
            if (list == null) {
                list = new ArrayList<Execution>();
            }
            list.add(execution);
            executionMap.put(execution.getActivityId(), list);
        }
        executionMap.forEach((k, v) -> {
            FlowElement current = process.getFlowElement(k);
            int lines = this.getCanGotoTheTargetLines(flowElement, current);
            --lines;
            for (Execution execution : v) {
                if (lines > 0) {
                    this.executionRepositoryCustom.deleteRuExecutionById(execution.getId());
                }
                --lines;
            }
        });
        HashMap<String, Integer> parallelGetaways = new HashMap<String, Integer>(8);
        this.getParallelGetaways(parallelGetaways, flowElement, flowElement, activityId);
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstance.getProcessInstanceId())).list().get(0);
        ExecutionEntityImpl execution = (ExecutionEntityImpl)this.runtimeService.createExecutionQuery().executionId(task.getExecutionId()).singleResult();
        parallelGetaways.forEach((k, v) -> {
            if (v > 0) {
                Integer i = 0;
                while (i < v) {
                    execution.setActivityId(k);
                    execution.setActive(false);
                    this.executionRepositoryCustom.insert(execution);
                    Integer n = i;
                    Integer n2 = i = Integer.valueOf(i + 1);
                }
            }
        });
    }

    private int getCanGotoTheTargetLines(FlowElement start, FlowElement target) {
        int line = 0;
        List<FlowElement> elements = this.getSourceFlowElements(target);
        for (FlowElement element : elements) {
            boolean result = this.canGotoTheTarget(start, element);
            if (!result) continue;
            ++line;
        }
        return line;
    }

    private boolean canGotoTheTarget(FlowElement start, FlowElement target) {
        List<FlowElement> elements = this.getNextFlowElements(start);
        if (!CollectionUtils.isEmpty(elements)) {
            for (FlowElement element : elements) {
                if (element.getId().equals(target.getId())) {
                    return true;
                }
                boolean result = this.canGotoTheTarget(element, target);
                if (!result) continue;
                return true;
            }
        }
        return false;
    }

    private boolean getParallelGetaways(Map<String, Integer> parallelGetaways, FlowElement startFlowElement, FlowElement currentFlowElement, String targetFlowId) {
        List<FlowElement> nextFlowElements = this.getNextFlowElements(currentFlowElement);
        boolean result = false;
        if (!CollectionUtils.isEmpty(nextFlowElements)) {
            for (FlowElement flowElement : nextFlowElements) {
                if (flowElement.getId().equals(targetFlowId)) {
                    return true;
                }
                boolean canGoToTheTargetFlowId = this.getParallelGetaways(parallelGetaways, startFlowElement, flowElement, targetFlowId);
                if (canGoToTheTargetFlowId) {
                    result = true;
                }
                if (!(flowElement instanceof ParallelGateway) || !canGoToTheTargetFlowId || parallelGetaways.containsKey(flowElement.getId())) continue;
                int totalLines = this.getSourceFlowElements(flowElement).size();
                int canBackLines = this.getCanBackLines(flowElement, startFlowElement.getId());
                int autoCompleteLines = totalLines - canBackLines;
                parallelGetaways.put(flowElement.getId(), autoCompleteLines);
            }
        }
        return result;
    }

    private int getCanBackLines(FlowElement currentFlowElement, String targetFlowId) {
        int lines = 0;
        List<FlowElement> sourceElements = this.getSourceFlowElements(currentFlowElement);
        if (!CollectionUtils.isEmpty(sourceElements)) {
            for (FlowElement sourceElement : sourceElements) {
                boolean result = this.canBackToTheTargetFlowId(sourceElement, targetFlowId);
                if (!result) continue;
                ++lines;
            }
        }
        return lines;
    }

    private boolean canBackToTheTargetFlowId(FlowElement currentFlowElement, String targetFlowId) {
        List<FlowElement> sourceElements = this.getSourceFlowElements(currentFlowElement);
        if (!CollectionUtils.isEmpty(sourceElements)) {
            for (FlowElement sourceElement : sourceElements) {
                if (sourceElement.getId().equals(targetFlowId)) {
                    return true;
                }
                boolean canBackToTheTargetFlowId = this.canBackToTheTargetFlowId(sourceElement, targetFlowId);
                if (!canBackToTheTargetFlowId) continue;
                return true;
            }
        }
        return false;
    }

    private List<FlowElement> getNextFlowElements(FlowElement flowElement) {
        ArrayList<FlowElement> nextFlowElements = new ArrayList<FlowElement>();
        if (flowElement instanceof FlowNode) {
            nextFlowElements.addAll(((FlowNode)flowElement).getOutgoingFlows());
        } else if (flowElement instanceof SequenceFlow) {
            nextFlowElements.add(((SequenceFlow)flowElement).getTargetFlowElement());
        }
        return nextFlowElements;
    }

    private List<FlowElement> getSourceFlowElements(FlowElement flowElement) {
        ArrayList<FlowElement> sourceElements = new ArrayList<FlowElement>();
        if (flowElement instanceof FlowNode) {
            sourceElements.addAll(((FlowNode)flowElement).getIncomingFlows());
        } else if (flowElement instanceof SequenceFlow) {
            sourceElements.add(((SequenceFlow)flowElement).getSourceFlowElement());
        }
        return sourceElements;
    }

    @Override
    @Transactional
    public List<ProcessCarbonCopyEntity> handleCarbonCopy(String taskId, List<String> assignments, Principal principal) {
        Validate.notBlank((CharSequence)taskId, (String)"taskId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty(assignments, (String)"\u4efb\u52a1\u4efb\u52a1\u6284\u9001\u63a5\u6536\u4eba\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.processAssignmentService.valid(assignments);
        UserVo user = super.getLoginUser(principal);
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        Validate.notNull((Object)task, (String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((boolean)this.processAssignmentService.equals(user, task.getAssignee()), (String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u5c5e\u4e8e\u5f53\u524d\u767b\u5f55\u4eba", (Object[])new Object[0]);
        ProcessInstanceEntity processInstance = this.processInstanceService.findByProcessInstanceId(task.getProcessInstanceId());
        Validate.notNull((Object)((Object)processInstance), (String)"\u6570\u636e\u5f02\u5e38\uff0c\u672a\u627e\u5230\u6d41\u7a0b\u5b9e\u4f8b\u5bf9\u8c61", (Object[])new Object[0]);
        return this.processCarbonCopyService.create(task, processInstance, user, assignments);
    }

    @Override
    public Set<ProcessTemplateNodeEntity> findCurrentNodes(ProcessInstanceEntity instance) {
        HashSet<ProcessTemplateNodeEntity> nodes = new HashSet<ProcessTemplateNodeEntity>();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(instance.getProcessInstanceId())).list();
        if (!CollectionUtils.isEmpty((Collection)tasks)) {
            for (Task task : tasks) {
                ProcessTemplateNodeEntity node = this.processTemplateNodeService.findByProcessTemplateIdAndProcessNodeId(instance.getProcessTemplate().getId(), task.getTaskDefinitionKey());
                nodes.add(node);
            }
        }
        return nodes;
    }

    @Override
    public Set<ProcessAssignmentEntity> findCurrentAssignments(ProcessInstanceEntity instance) {
        HashSet<ProcessAssignmentEntity> assignments = new HashSet<ProcessAssignmentEntity>();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(instance.getProcessInstanceId())).list();
        if (!CollectionUtils.isEmpty((Collection)tasks)) {
            for (Task task : tasks) {
                if (!StringUtils.isNotBlank((CharSequence)task.getAssignee())) continue;
                ProcessAssignmentEntity assignment = this.processAssignmentService.findAssignment(task.getAssignee());
                assignments.add(assignment);
            }
        }
        return this.processAssignmentService.save(instance.getId(), assignments);
    }

    @Override
    public Page<TaskVo> findMyTasksByConditions(TaskVo taskVo, Principal principal, Pageable pageable) {
        UserVo user = this.getLoginUser(principal);
        UserVo userVo = this.userService.findDetailsById(user.getId());
        Page<TaskVo> page = this.processTaskRepositoryCustom.findMyTasksByConditions(userVo, taskVo, pageable);
        this.loadUser(page.getContent());
        return page;
    }

    private void loadUser(List<TaskVo> tasks) {
        if (CollectionUtils.isEmpty(tasks)) {
            return;
        }
        for (TaskVo task : tasks) {
            UserVo user = super.getUserByAccount(task.getApplicantAccount());
            if (user == null) continue;
            task.setApplicantUserName(user.getUserName());
        }
    }

    @Override
    @Transactional
    public void handleStop(String taskId, Principal principal, String content) {
        Validate.notBlank((CharSequence)taskId, (String)"taskId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)content, (String)"\u5ba1\u6279\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        UserVo user = super.getLoginUser(principal);
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        Validate.notNull((Object)task, (String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((!"DEFAULT_START".equals(task.getTaskDefinitionKey()) ? 1 : 0) != 0, (String)"\u53d1\u8d77\u8282\u70b9\u4e0d\u80fd\u505a\u7ec8\u6b62\u64cd\u4f5c\uff0c\u8bf7\u505a\u64a4\u9500\u64cd\u4f5c", (Object[])new Object[0]);
        Validate.isTrue((boolean)this.processAssignmentService.equals(user, task.getAssignee()), (String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u5c5e\u4e8e\u5f53\u524d\u767b\u5f55\u4eba", (Object[])new Object[0]);
        ProcessInstanceEntity processInstance = this.processInstanceService.findByProcessInstanceId(task.getProcessInstanceId());
        Validate.notNull((Object)((Object)processInstance), (String)"\u6570\u636e\u5f02\u5e38\uff0c\u672a\u627e\u5230\u6d41\u7a0b\u5b9e\u4f8b\u5bf9\u8c61", (Object[])new Object[0]);
        String endActivitiId = this.processTemplateService.getEndActivityId(processInstance.getProcessTemplate());
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstance.getProcessInstanceId())).list();
        List activityIds = tasks.stream().map(TaskInfo::getTaskDefinitionKey).collect(Collectors.toCollection(() -> new ArrayList(tasks.size())));
        this.runtimeService.createChangeActivityStateBuilder().processInstanceId(processInstance.getProcessInstanceId()).moveActivityIdsToSingleActivityId(activityIds, endActivitiId).changeState();
        ProcessTemplateNodeEntity currentNode = this.processTemplateNodeService.findByProcessTemplateIdAndProcessNodeId(processInstance.getProcessTemplate().getId(), task.getTaskDefinitionKey());
        this.processInstanceService.update(processInstance, user, currentNode, null, null, ProcessInstanceState.STOPPED.getState());
        this.processInstanceOperateRecordService.create(task, processInstance, user, TaskOperateBtn.BTN_013, content);
    }

    @Override
    public List<Task> findCurrentTasks(String processInstanceId) {
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        return ((TaskQuery)taskQuery.processInstanceId(processInstanceId)).list();
    }

    @Override
    @Transactional
    public void handleCancel(String processInstanceId, Principal principal, String content, Map<String, Object> variables) {
        Validate.notBlank((CharSequence)processInstanceId, (String)"processInstanceId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)content, (String)"\u5ba1\u6279\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        UserVo user = super.getLoginUser(principal);
        ProcessInstanceEntity processInstance = this.processInstanceService.findByProcessInstanceId(processInstanceId);
        Validate.notNull((Object)((Object)processInstance), (String)"\u6570\u636e\u5f02\u5e38\uff0c\u672a\u627e\u5230\u6d41\u7a0b\u5b9e\u4f8b\u5bf9\u8c61", (Object[])new Object[0]);
        Validate.isTrue((boolean)user.getAccount().equals(processInstance.getApplicantUser().getAccount()), (String)"\u5f53\u524d\u767b\u5f55\u4eba\u4e0d\u662f\u5f53\u524d\u6d41\u7a0b\u7684\u53d1\u8d77\u8005", (Object[])new Object[0]);
        this.validateTaskCancel(processInstance);
        String endActivitiId = this.processTemplateService.getEndActivityId(processInstance.getProcessTemplate());
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstance.getProcessInstanceId())).list();
        List activityIds = tasks.stream().map(TaskInfo::getTaskDefinitionKey).collect(Collectors.toCollection(() -> new ArrayList(tasks.size())));
        this.runtimeService.createChangeActivityStateBuilder().processInstanceId(processInstance.getProcessInstanceId()).processVariables(variables).moveActivityIdsToSingleActivityId(activityIds, endActivitiId).changeState();
        ProcessTemplateNodeEntity currentNode = this.processTemplateNodeService.findByProcessTemplateIdAndProcessNodeId(processInstance.getProcessTemplate().getId(), "DEFAULT_START");
        this.processInstanceService.update(processInstance, user, currentNode, null, null, ProcessInstanceState.CANCELED.getState());
        HistoricTaskInstance task = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).taskDefinitionKey("DEFAULT_START")).taskCreatedAfter(processInstance.getLatestSubmitTime())).singleResult();
        if (task == null) {
            task = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).taskDefinitionKey("DEFAULT_START")).taskCompletedAfter(processInstance.getLatestSubmitTime()).singleResult();
        }
        TaskEntityImpl newTask = (TaskEntityImpl)this.taskService.newTask(task.getId());
        newTask.setTaskDefinitionKey(task.getTaskDefinitionKey());
        this.processInstanceOperateRecordService.create((Task)newTask, processInstance, user, TaskOperateBtn.BTN_012, content);
    }

    private List<HistoricActivityInstance> findUserHistoricActivityInstances(UserVo user, ProcessInstanceEntity processInstance, String activityId) {
        List activityInstances;
        HistoricActivityInstanceQuery query = (HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().finishedAfter(processInstance.getLatestSubmitTime()).processInstanceId(processInstance.getProcessInstanceId()).orderByHistoricActivityInstanceEndTime().desc();
        if (StringUtils.isNotBlank((CharSequence)activityId)) {
            query.activityId(activityId);
        }
        if (!CollectionUtils.isEmpty((Collection)(activityInstances = query.list()))) {
            activityInstances = activityInstances.stream().filter(a -> this.isTaskAssignment(a.getTaskId(), user)).collect(Collectors.toList());
        }
        return activityInstances;
    }

    private boolean isTaskAssignment(String taskId, UserVo user) {
        Long count = this.processInstanceOperateRecordService.countByTaskIdAndUserAccountAndBtns(taskId, user.getAccount(), TaskOperateBtn.BTN_001.getBtn());
        return count != null && count > 0L;
    }

    @Override
    @Transactional
    public void handleRetrieve(String processInstanceId, String activityId, Principal principal) {
        String nextActivityId;
        Validate.notBlank((CharSequence)processInstanceId, (String)"processInstanceId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((!"DEFAULT_START".equals(activityId) ? 1 : 0) != 0, (String)"\u4e0d\u80fd\u53d6\u56de\u5230\u53d1\u8d77\u8282\u70b9", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityId, (String)"activityId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        UserVo user = this.getLoginUser(principal);
        ProcessInstanceEntity processInstance = this.processInstanceService.findByProcessInstanceId(processInstanceId);
        Validate.notNull((Object)((Object)processInstance), (String)"\u6570\u636e\u5f02\u5e38\uff0c\u672a\u627e\u5230\u6d41\u7a0b\u5b9e\u4f8b\u5bf9\u8c61", (Object[])new Object[0]);
        Validate.isTrue((!processInstance.getProcessState().equals(ProcessInstanceState.COMPLETED.getState()) ? 1 : 0) != 0, (String)"\u6d41\u7a0b\u5df2\u5b8c\u6210\uff0c\u4e0d\u80fd\u53d6\u56de", (Object[])new Object[0]);
        Validate.isTrue((!processInstance.getProcessState().equals(ProcessInstanceState.STOPPED.getState()) ? 1 : 0) != 0, (String)"\u6d41\u7a0b\u5df2\u7ec8\u6b62\uff0c\u4e0d\u80fd\u53d6\u56de", (Object[])new Object[0]);
        Validate.isTrue((!processInstance.getProcessState().equals(ProcessInstanceState.CANCELED.getState()) ? 1 : 0) != 0, (String)"\u6d41\u7a0b\u5df2\u64a4\u9500\uff0c\u4e0d\u80fd\u53d6\u56de", (Object[])new Object[0]);
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processInstance.getProcessTemplate().getProcessDefinitionId());
        Validate.notNull((Object)bpmnModel, (String)"\u672a\u627e\u5230\u6d41\u7a0b\u5b9a\u4e49\u5bf9\u8c61", (Object[])new Object[0]);
        List<HistoricActivityInstance> activityInstances = this.findUserHistoricActivityInstances(user, processInstance, activityId);
        Validate.notEmpty(activityInstances, (String)"\u672a\u627e\u5230\u5386\u53f2\u4efb\u52a1\u8282\u70b9", (Object[])new Object[0]);
        List<String> currentActivities = this.validateTaskIsCanRetrieveAndFindCurrentTask(bpmnModel, processInstance, activityId, activityInstances);
        HistoricActivityInstance activityInstance = activityInstances.get(0);
        this.processInstanceService.initInstanceMulti(processInstance);
        if (!CollectionUtils.isEmpty(currentActivities)) {
            nextActivityId = currentActivities.get(0);
            this.runtimeService.createChangeActivityStateBuilder().processInstanceId(processInstanceId).moveActivityIdsToSingleActivityId(currentActivities, activityId).changeState();
        } else {
            List<Execution> executions = this.getNextParallelExecutions(bpmnModel, processInstance, activityId);
            Execution execution = executions.get(0);
            nextActivityId = execution.getActivityId();
            this.runtimeService.createChangeActivityStateBuilder().processInstanceId(processInstanceId).moveExecutionToActivityId(execution.getId(), activityId).changeState();
        }
        Set<ProcessAssignmentEntity> nextAssignments = this.findCurrentAssignments(processInstance);
        Set<ProcessTemplateNodeEntity> nextNodes = this.findCurrentNodes(processInstance);
        List historicActivityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).finishedBefore(activityInstance.getStartTime()).activityType("userTask").orderByHistoricActivityInstanceEndTime().desc()).list();
        String currentTaskKey = "";
        for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
            if (historicActivityInstance.getActivityId().equals(activityId)) continue;
            currentTaskKey = historicActivityInstance.getActivityId();
            break;
        }
        this.handleGetaway(bpmnModel, processInstance, nextActivityId, activityId);
        this.deleteHistoricActivityInstanceAfterActivity(bpmnModel, processInstance, activityId);
        ProcessTemplateNodeEntity currentNode = this.processTemplateNodeService.findByProcessTemplateIdAndProcessNodeId(processInstance.getProcessTemplate().getId(), currentTaskKey);
        this.processInstanceService.update(processInstance, user, currentNode, nextAssignments, nextNodes, processInstance.getProcessState());
        TaskEntityImpl newTask = (TaskEntityImpl)this.taskService.newTask(activityInstance.getId());
        newTask.setTaskDefinitionKey(activityInstance.getActivityId());
        this.processInstanceOperateRecordService.create((Task)newTask, processInstance, user, TaskOperateBtn.BTN_004, "\u53d6\u56de\u4efb\u52a1");
    }

    private void deleteHistoricActivityInstanceAfterActivity(BpmnModel bpmnModel, ProcessInstanceEntity processInstance, String activityId) {
        Process process = (Process)bpmnModel.getProcesses().get(0);
        FlowElement flowElement = process.getFlowElement(activityId);
        this.deleteHistoricActivityInstanceAfterActivity(flowElement, processInstance);
    }

    private void deleteHistoricActivityInstanceAfterActivity(FlowElement flowElement, ProcessInstanceEntity processInstance) {
        List<FlowElement> elements = this.getNextFlowElements(flowElement);
        if (!CollectionUtils.isEmpty(elements)) {
            for (FlowElement element : elements) {
                List<HistoricActivityInstance> activityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getProcessInstanceId()).activityId(element.getId()).startedAfter(processInstance.getLatestSubmitTime()).list();
                if (!CollectionUtils.isEmpty((Collection)activityInstances)) {
                    if (element instanceof ParallelGateway) {
                        HistoricActivityInstance activityInstance = (HistoricActivityInstance)activityInstances.get(0);
                        activityInstances = Collections.singletonList(activityInstance);
                    }
                    this.historicActivityInstanceRepositoryCustom.delete(activityInstances);
                }
                this.deleteHistoricActivityInstanceAfterActivity(element, processInstance);
            }
        }
    }

    private List<String> validateTaskIsCanRetrieveAndFindCurrentTask(BpmnModel bpmnModel, ProcessInstanceEntity processInstance, String activityId, List<HistoricActivityInstance> activityInstances) {
        Validate.notEmpty(activityInstances, (String)"\u672a\u627e\u5230\u5386\u53f2\u4efb\u52a1\u8282\u70b9", (Object[])new Object[0]);
        HistoricActivityInstance historicActivityInstance = activityInstances.get(0);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)historicActivityInstance.getDeleteReason()), (String)"\u8be5\u8282\u70b9\u4efb\u52a1\u975e\u6b63\u5e38\u5ba1\u6279\uff0c\u4e0d\u80fd\u53d6\u56de", (Object[])new Object[0]);
        List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstance.getProcessInstanceId())).taskDefinitionKey(activityId)).list();
        Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)tasks), (String)"\u5f53\u524d\u4efb\u52a1\u8282\u70b9\u6709\u6b63\u5728\u5ba1\u6279\u7684\u4efb\u52a1\uff0c\u4e0d\u80fd\u53d6\u56de\u8be5\u4efb\u52a1", (Object[])new Object[0]);
        Process process = (Process)bpmnModel.getProcesses().get(0);
        FlowElement flowElement = process.getFlowElement(activityId);
        List<UserTask> nextUserTasks = this.findNextUserTask(flowElement);
        ArrayList<String> currentTasks = new ArrayList<String>();
        for (UserTask userTask : nextUserTasks) {
            List taskInstances = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstance.getProcessInstanceId())).taskCompletedAfter(historicActivityInstance.getEndTime()).taskDefinitionKey(userTask.getId())).finished().list();
            if (!CollectionUtils.isEmpty((Collection)taskInstances)) {
                Iterator iterator = taskInstances.iterator();
                while (iterator.hasNext()) {
                    HistoricTaskInstance next = (HistoricTaskInstance)iterator.next();
                    if (!StringUtils.isNotBlank((CharSequence)next.getDeleteReason())) continue;
                    iterator.remove();
                }
            }
            Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)taskInstances), (String)"\u540e\u7eed\u4efb\u52a1\u5df2\u5ba1\u6279\uff0c\u4e0d\u80fd\u53d6\u56de\u8be5\u4efb\u52a1", (Object[])new Object[0]);
            List list = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstance.getProcessInstanceId())).taskDefinitionKey(userTask.getId())).list();
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            currentTasks.add(userTask.getId());
        }
        return currentTasks;
    }

    private List<Execution> getNextParallelExecutions(BpmnModel bpmnModel, ProcessInstanceEntity processInstance, String activityId) {
        Process process = (Process)bpmnModel.getProcesses().get(0);
        FlowElement flowElement = process.getFlowElement(activityId);
        ParallelGateway parallelGateway = this.findNextParallelGateway(flowElement);
        Validate.notNull((Object)parallelGateway, (String)"\u672a\u627e\u5230\u6d3b\u52a8\u8282\u70b9\u7684\u4e0b\u4e00\u5e73\u884c\u7f51\u5173", (Object[])new Object[0]);
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getProcessInstanceId()).list();
        return executions.stream().filter(execution -> parallelGateway.getId().equals(execution.getActivityId())).collect(Collectors.toList());
    }

    private ParallelGateway findNextParallelGateway(FlowElement flowElement) {
        List<FlowElement> elements = this.getNextFlowElements(flowElement);
        if (!CollectionUtils.isEmpty(elements)) {
            for (FlowElement element : elements) {
                if (element instanceof ParallelGateway) {
                    return (ParallelGateway)element;
                }
                ParallelGateway parallelGateway = this.findNextParallelGateway(element);
                if (parallelGateway == null) continue;
                return parallelGateway;
            }
        }
        return null;
    }

    private List<UserTask> findNextUserTask(FlowElement flowElement) {
        ArrayList<UserTask> userTasks = new ArrayList<UserTask>();
        List<FlowElement> elements = this.getNextFlowElements(flowElement);
        if (!CollectionUtils.isEmpty(elements)) {
            for (FlowElement element : elements) {
                if (element instanceof UserTask) {
                    userTasks.add((UserTask)element);
                    continue;
                }
                userTasks.addAll(this.findNextUserTask(element));
            }
        }
        return userTasks;
    }

    @Override
    @Transactional
    public void handleAddMulti(String taskId, List<String> assignments, Principal principal, String content) {
        Validate.notBlank((CharSequence)taskId, (String)"\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty(assignments, (String)"\u4f1a\u7b7e\u4eba\u5458\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        content = content == null ? "" : content;
        UserVo user = this.getLoginUser(principal);
        Validate.isTrue((!this.processAssignmentService.contains(assignments, user) ? 1 : 0) != 0, (String)"\u4e0d\u80fd\u6dfb\u52a0\u81ea\u5df1", (Object[])new Object[0]);
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        Validate.notNull((Object)task, (String)"\u672a\u627e\u5230\u8be5\u4efb\u52a1\u5bf9\u8c61", (Object[])new Object[0]);
        Validate.isTrue((boolean)this.processAssignmentService.equals(user, task.getAssignee()), (String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u5c5e\u4e8e\u5f53\u524d\u767b\u5f55\u4eba", (Object[])new Object[0]);
        ProcessInstanceEntity processInstance = this.processInstanceService.findByProcessInstanceId(task.getProcessInstanceId());
        Validate.notNull((Object)((Object)processInstance), (String)"\u6570\u636e\u5f02\u5e38\uff0c\u672a\u627e\u5230\u6d41\u7a0b\u5b9e\u4f8b\u5bf9\u8c61", (Object[])new Object[0]);
        UserTask userTask = (UserTask)this.processTemplateService.findFlowElement(processInstance.getProcessTemplate().getProcessDefinitionId(), task.getTaskDefinitionKey());
        Validate.notNull((Object)userTask, (String)"\u672a\u627e\u5230\u7528\u6237\u4efb\u52a1\u8282\u70b9\u5b9a\u4e49\u3010%s\u3011", (Object[])new Object[]{task.getTaskDefinitionKey()});
        MultiInstanceLoopCharacteristics loopCharacteristics = userTask.getLoopCharacteristics();
        Validate.notNull((Object)loopCharacteristics, (String)"\u8be5\u4efb\u52a1\u8282\u70b9\u4e0d\u662f\u4f1a\u7b7e\u8282\u70b9\uff0c\u4e0d\u80fd\u52a0\u7b7e", (Object[])new Object[0]);
        StringBuilder contentSb = new StringBuilder(content).append(" ===>\u589e\u52a0\u4f1a\u7b7e\u4eba\u5458[");
        Boolean isSequential = loopCharacteristics.isSequential();
        Execution processExecution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getProcessInstanceId()).onlyProcessInstanceExecutions().singleResult();
        Execution taskExecution = (Execution)this.runtimeService.createExecutionQuery().executionId(task.getExecutionId()).singleResult();
        String collection = StringUtils.join((Object[])new String[]{task.getTaskDefinitionKey(), "_mi_assignments"});
        String taskAssignmentKey = StringUtils.join((Object[])new String[]{task.getTaskDefinitionKey(), "_mi_assignment"});
        String completedCollection = StringUtils.join((Object[])new String[]{task.getTaskDefinitionKey(), "_mi_completed_assignments"});
        List<String> miAssignments = this.getEditableMultiAssignments(processExecution.getId(), collection, false);
        List<String> completedMiAssignments = this.getEditableMultiAssignments(taskExecution.getParentId(), completedCollection, true);
        this.validateAddMultiAssignments(miAssignments, completedMiAssignments, assignments);
        miAssignments.addAll(assignments);
        this.runtimeService.setVariable(task.getExecutionId(), collection, miAssignments);
        for (int i = 0; i < assignments.size(); ++i) {
            String assignment = assignments.get(i);
            ProcessAssignmentEntity assignmentEntity = this.processAssignmentService.findAssignment(assignment);
            Validate.notNull((Object)((Object)assignmentEntity), (String)"\u672a\u627e\u5230\u52a0\u7b7e\u7528\u6237:%s", (Object[])new Object[]{assignment});
            if (i > 0) {
                contentSb.append(",");
            }
            contentSb.append(assignmentEntity.getAssignmentName());
            HashMap<String, String> variables = new HashMap<String, String>(2);
            if (!isSequential.booleanValue()) {
                variables.put(taskAssignmentKey, assignment);
            }
            Execution execution = this.runtimeService.addMultiInstanceExecution(task.getTaskDefinitionKey(), task.getProcessInstanceId(), variables);
            if (isSequential.booleanValue()) continue;
            Task addTask = (Task)((TaskQuery)this.taskService.createTaskQuery().executionId(execution.getId())).singleResult();
            this.taskService.setAssignee(addTask.getId(), assignment);
        }
        contentSb.append("]");
        this.processInstanceOperateRecordService.create(task, processInstance, user, TaskOperateBtn.BTN_009, contentSb.toString());
    }

    @Override
    @Transactional
    public void handleSubMulti(String taskId, List<String> assignments, Principal principal, String content) {
        Validate.notBlank((CharSequence)taskId, (String)"\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty(assignments, (String)"\u4f1a\u7b7e\u4eba\u5458\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        content = content == null ? "" : content;
        UserVo user = super.getLoginUser(principal);
        Validate.isTrue((!this.processAssignmentService.contains(assignments, user) ? 1 : 0) != 0, (String)"\u4e0d\u80fd\u5220\u9664\u81ea\u5df1", (Object[])new Object[0]);
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        Validate.notNull((Object)task, (String)"\u672a\u627e\u5230\u8be5\u4efb\u52a1\u5bf9\u8c61", (Object[])new Object[0]);
        Validate.isTrue((boolean)this.processAssignmentService.equals(user, task.getAssignee()), (String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u5c5e\u4e8e\u5f53\u524d\u767b\u5f55\u4eba", (Object[])new Object[0]);
        ProcessInstanceEntity processInstance = this.processInstanceService.findByProcessInstanceId(task.getProcessInstanceId());
        Validate.notNull((Object)((Object)processInstance), (String)"\u6570\u636e\u5f02\u5e38\uff0c\u672a\u627e\u5230\u6d41\u7a0b\u5b9e\u4f8b\u5bf9\u8c61", (Object[])new Object[0]);
        UserTask userTask = (UserTask)this.processTemplateService.findFlowElement(processInstance.getProcessTemplate().getProcessDefinitionId(), task.getTaskDefinitionKey());
        Validate.notNull((Object)userTask, (String)"\u672a\u627e\u5230\u7528\u6237\u4efb\u52a1\u8282\u70b9\u5b9a\u4e49\u3010%s\u3011", (Object[])new Object[]{task.getTaskDefinitionKey()});
        MultiInstanceLoopCharacteristics loopCharacteristics = userTask.getLoopCharacteristics();
        Validate.notNull((Object)loopCharacteristics, (String)"\u8be5\u4efb\u52a1\u8282\u70b9\u4e0d\u662f\u4f1a\u7b7e\u8282\u70b9\uff0c\u4e0d\u80fd\u51cf\u7b7e", (Object[])new Object[0]);
        Boolean isSequential = loopCharacteristics.isSequential();
        StringBuilder contentSb = new StringBuilder(content).append(" ===>\u5220\u9664\u4f1a\u7b7e\u4eba\u5458[");
        Execution processExecution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getProcessInstanceId()).onlyProcessInstanceExecutions().singleResult();
        Execution taskExecution = (Execution)this.runtimeService.createExecutionQuery().executionId(task.getExecutionId()).singleResult();
        String collection = StringUtils.join((Object[])new String[]{task.getTaskDefinitionKey(), "_mi_assignments"});
        String completedCollection = StringUtils.join((Object[])new String[]{task.getTaskDefinitionKey(), "_mi_completed_assignments"});
        List<String> miAssignments = this.getEditableMultiAssignments(processExecution.getId(), collection, false);
        List<String> completedMiAssignments = this.getEditableMultiAssignments(taskExecution.getParentId(), completedCollection, true);
        this.validateSubMultiAssignments(miAssignments, completedMiAssignments, assignments, user, task, userTask);
        for (int i = 0; i < assignments.size(); ++i) {
            String assignment = assignments.get(i);
            ProcessAssignmentEntity assignmentEntity = this.processAssignmentService.findAssignment(assignment);
            Validate.notNull((Object)((Object)assignmentEntity), (String)"\u672a\u627e\u5230\u51cf\u7b7e\u7528\u6237:%s", (Object[])new Object[]{assignment});
            if (i > 0) {
                contentSb.append(",");
            }
            contentSb.append(assignmentEntity.getAssignmentName());
            miAssignments.remove(assignment);
            if (isSequential.booleanValue()) continue;
            Task multiTask = (Task)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(task.getProcessInstanceId())).taskDefinitionKey(task.getTaskDefinitionKey())).taskAssignee(assignment)).singleResult();
            Validate.notNull((Object)multiTask, (String)"\u4f1a\u7b7e\u4efb\u52a1\u4e0d\u5b58\u5728\uff1a%s", (Object[])new Object[]{assignment});
            this.runtimeService.deleteMultiInstanceExecution(multiTask.getExecutionId(), false);
        }
        if (Boolean.TRUE.equals(isSequential)) {
            Integer nrOnInstance = (Integer)this.runtimeService.getVariable(taskExecution.getParentId(), "nrOfInstances");
            this.runtimeService.setVariable(taskExecution.getParentId(), "nrOfInstances", (Object)(nrOnInstance - assignments.size()));
        }
        this.runtimeService.setVariable(processExecution.getId(), collection, miAssignments);
        contentSb.append("]");
        this.processInstanceOperateRecordService.create(task, processInstance, user, TaskOperateBtn.BTN_010, contentSb.toString());
    }

    private List<String> getEditableMultiAssignments(String executionId, String collection, boolean local) {
        ArrayList<String> assignments = new ArrayList<String>();
        List list = local ? (List)this.runtimeService.getVariableLocal(executionId, collection, List.class) : (List)this.runtimeService.getVariable(executionId, collection, List.class);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            list.forEach(a -> assignments.add((String)a));
        }
        return assignments;
    }

    private void validateSubMultiAssignments(List<String> miAssignments, List<String> completedMiAssignments, List<String> assignments, UserVo user, Task task, UserTask userTask) {
        HashSet assignmentSet = new HashSet();
        for (String assignment : assignments) {
            Validate.isTrue((!this.processAssignmentService.equals(user, assignment) ? 1 : 0) != 0, (String)"\u4e0d\u80fd\u5220\u9664\u81ea\u5df1", (Object[])new Object[0]);
            Validate.isTrue((!assignmentSet.contains(assignment) ? 1 : 0) != 0, (String)"\u91cd\u590d\u7684\u5220\u9664\u4f1a\u7b7e\u4eba\u5458\uff1a%s", (Object[])new Object[]{assignment});
            Validate.isTrue((boolean)miAssignments.contains(assignment), (String)"\u4eba\u5458\u3010%s\u3011\u4e0d\u5728\u4f1a\u7b7e\u4eba\u5458\u4e2d", (Object[])new Object[]{assignment});
            Validate.isTrue((!completedMiAssignments.contains(assignment) ? 1 : 0) != 0, (String)"\u4eba\u5458\u3010%s\u3011\u5df2\u5904\u7406\u5f53\u524d\u4f1a\u7b7e\uff0c\u4e0d\u80fd\u5220\u9664", (Object[])new Object[]{assignment});
        }
        boolean prophesyCompletion = (Boolean)((RuntimeServiceImpl)this.runtimeService).getCommandExecutor().execute((Command)new ProphesyMultiCompletionBeforeRejectCommand(this.runtimeService, task, userTask, assignments.size()));
        Validate.isTrue((boolean)prophesyCompletion, (String)"\u6b64\u64cd\u4f5c\u5c06\u5bfc\u81f4\u4f1a\u7b7e\u65e0\u6cd5\u7ee7\u7eed\uff0c\u8bf7\u51cf\u5c11\u5220\u9664\u7684\u4f1a\u7b7e\u4eba\u5458", (Object[])new Object[0]);
    }

    private void validateAddMultiAssignments(List<String> miAssignments, List<String> completedMiAssignments, List<String> assignments) {
        HashSet<String> assignmentSet = new HashSet<String>();
        for (String assignment : assignments) {
            Validate.isTrue((!miAssignments.contains(assignment) ? 1 : 0) != 0, (String)"\u5f53\u524d\u4f1a\u7b7e\u4e2d\u5df2\u6709\u4f1a\u7b7e\u4eba\u5458:%s", (Object[])new Object[]{assignment});
            Validate.isTrue((!completedMiAssignments.contains(assignment) ? 1 : 0) != 0, (String)"\u5f53\u524d\u4f1a\u7b7e\u4e2d\u5df2\u6709\u4f1a\u7b7e\u4eba\u5458:%s", (Object[])new Object[]{assignment});
            Validate.isTrue((!assignmentSet.contains(assignment) ? 1 : 0) != 0, (String)"\u91cd\u590d\u7684\u4f1a\u7b7e\u4eba\u5458:%s", (Object[])new Object[]{assignment});
            assignmentSet.add(assignment);
        }
    }

    private void validateTaskCancel(ProcessInstanceEntity processInstance) {
        Validate.isTrue((!processInstance.getProcessState().equals(ProcessInstanceState.COMPLETED.getState()) ? 1 : 0) != 0, (String)"\u6d41\u7a0b\u5df2\u5b8c\u6210\uff0c\u4e0d\u80fd\u64a4\u9500", (Object[])new Object[0]);
        Validate.isTrue((!processInstance.getProcessState().equals(ProcessInstanceState.STOPPED.getState()) ? 1 : 0) != 0, (String)"\u6d41\u7a0b\u5df2\u7ec8\u6b62\uff0c\u4e0d\u80fd\u64a4\u9500", (Object[])new Object[0]);
        Validate.isTrue((!processInstance.getProcessState().equals(ProcessInstanceState.CANCELED.getState()) ? 1 : 0) != 0, (String)"\u6d41\u7a0b\u5df2\u64a4\u9500\uff0c\u4e0d\u80fd\u518d\u6b21\u64a4\u9500", (Object[])new Object[0]);
        List<ProcessTemplateNodeEntity> nodes = this.processTemplateNodeService.findByProcessTemplateIdAndCancelFlag(processInstance.getProcessTemplate().getId(), true);
        List activities = this.historyService.createHistoricActivityInstanceQuery().startedAfter(processInstance.getLatestSubmitTime()).list();
        if (CollectionUtils.isEmpty(nodes) || CollectionUtils.isEmpty((Collection)activities)) {
            return;
        }
        Set nodesSet = nodes.stream().map(ProcessTemplateNodeEntity::getProcessNodeId).collect(Collectors.toSet());
        Set activitiesSet = activities.stream().map(HistoricActivityInstance::getActivityId).collect(Collectors.toSet());
        Sets.SetView intersection = Sets.intersection(nodesSet, activitiesSet);
        Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)intersection), (String)"\u4efb\u52a1\u5df2\u5230\u64a4\u9500\u6807\u8bc6\u7684\u8282\u70b9\uff0c\u4e0d\u80fd\u64a4\u9500", (Object[])new Object[0]);
    }

    private void validateBackTaskTargetActivity(ProcessInstanceEntity processInstance, String targetActivitiId) {
        List<ProcessInstanceOperateRecordEntity> records = this.processInstanceOperateRecordService.findByProcessInstanceIdAndLatestSubmitTimeAndBtns(processInstance.getProcessInstanceId(), processInstance.getLatestSubmitTime(), TaskOperateBtn.BTN_001.getBtn());
        if (!CollectionUtils.isEmpty(records)) {
            for (ProcessInstanceOperateRecordEntity record : records) {
                if (!targetActivitiId.equals(record.getProcessTemplateNode().getProcessNodeId())) continue;
                Validate.isTrue((boolean)record.getProcessTemplateNode().getCanBack(), (String)"\u76ee\u6807\u8282\u70b9\u4e0d\u5141\u8bb8\u56de\u9000", (Object[])new Object[0]);
                return;
            }
        }
        throw new IllegalArgumentException("\u76ee\u6807\u8282\u70b9\u4e0d\u5728\u5386\u53f2\u4efb\u52a1\u4e2d");
    }

    private boolean isProcessEnd(String processInstanceId) {
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).finished().singleResult();
        return historicProcessInstance != null;
    }

    @Override
    public List<ProcessTemplateNodeEntity> findBackableNodes(String processInstanceId) {
        if (StringUtils.isBlank((CharSequence)processInstanceId)) {
            return Collections.emptyList();
        }
        ProcessInstanceEntity processInstance = this.processInstanceService.findDetailsByProcessInstanceId(processInstanceId);
        if (processInstance == null) {
            return Collections.emptyList();
        }
        if (processInstance.getProcessTemplate() == null) {
            return Collections.emptyList();
        }
        List<ProcessTemplateNodeEntity> nodes = this.processTemplateNodeService.findByProcessTemplateId(processInstance.getProcessTemplate().getId());
        if (CollectionUtils.isEmpty(nodes)) {
            return Collections.emptyList();
        }
        Map nodesMap = nodes.stream().collect(Collectors.toMap(ProcessTemplateNodeEntity::getProcessNodeId, node -> node, (a, b) -> b, () -> new HashMap(16)));
        ArrayList<ProcessTemplateNodeEntity> backables = new ArrayList<ProcessTemplateNodeEntity>();
        HistoricTaskInstanceQuery historicTaskInstanceQuery = this.historyService.createHistoricTaskInstanceQuery();
        List tasks = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)historicTaskInstanceQuery.processInstanceId(processInstanceId)).taskCompletedAfter(processInstance.getLatestSubmitTime()).orderByTaskCreateTime()).asc()).list();
        if (CollectionUtils.isEmpty((Collection)tasks)) {
            return Collections.emptyList();
        }
        HashSet<String> nodeIds = new HashSet<String>();
        for (HistoricTaskInstance task : tasks) {
            ProcessTemplateNodeEntity node2 = (ProcessTemplateNodeEntity)((Object)nodesMap.get(task.getTaskDefinitionKey()));
            if (nodeIds.contains(node2.getProcessNodeId()) || !node2.getCanBack().booleanValue() || "DEFAULT_START".equals(task.getTaskDefinitionKey()) || !StringUtils.isBlank((CharSequence)task.getDeleteReason())) continue;
            backables.add(node2);
            nodeIds.add(node2.getProcessNodeId());
        }
        return backables;
    }

    @Override
    public Page<ProcessInstanceOperateRecordEntity> findDoneByConditions(Pageable pageable, ProcessInstanceOperateRecordEntity record, Principal principal) {
        UserVo user = super.getLoginUser(principal);
        Page<ProcessInstanceOperateRecordEntity> page = this.processTaskRepositoryCustom.findDoneByConditions(pageable, record, user);
        this.loadUser(page);
        return page;
    }

    private void loadUser(Page<ProcessInstanceOperateRecordEntity> page) {
        List records = page.getContent();
        if (CollectionUtils.isEmpty((Collection)records)) {
            return;
        }
        for (ProcessInstanceOperateRecordEntity record : records) {
            UserVo operator = super.getUserByAccount(record.getOperatorAccount());
            record.setOperator(operator);
            ProcessInstanceEntity instance = record.getProcessInstance();
            if (instance == null) continue;
            UserVo applicant = super.getUserByAccount(instance.getApplicantAccount());
            instance.setApplicantUser(applicant);
        }
    }

    @Override
    public TaskVo findTaskInfoByInstanceIdAndTaskKey(String processInstanceId, String taskKey) {
        List taskInstances;
        if (StringUtils.isBlank((CharSequence)processInstanceId)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)taskKey)) {
            return null;
        }
        ProcessTemplateEntity processTemplate = this.processTemplateService.findDetailsByProcessInstanceId(processInstanceId);
        if (processTemplate == null) {
            return null;
        }
        ProcessInstanceEntity processInstance = this.processInstanceService.findDetailsByProcessInstanceId(processInstanceId);
        if (processInstance == null) {
            return null;
        }
        TaskInfo task = null;
        List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).taskDefinitionKey(taskKey)).list();
        if (!CollectionUtils.isEmpty((Collection)tasks)) {
            task = (TaskInfo)tasks.get(0);
        }
        if (task == null && !CollectionUtils.isEmpty((Collection)(taskInstances = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).taskDefinitionKey(taskKey)).orderByTaskCreateTime()).desc()).list()))) {
            task = (TaskInfo)taskInstances.get(0);
        }
        if (task == null) {
            return null;
        }
        ProcessTemplateNodeEntity node = this.processTemplateNodeService.findDetailByProcessTemplateIdAndProcessNodeId(processTemplate.getId(), taskKey);
        return this.initTaskInfo(processInstance, processTemplate, task, node);
    }

    private TaskVo initTaskInfo(ProcessInstanceEntity processInstance, ProcessTemplateEntity processTemplate, TaskInfo task, ProcessTemplateNodeEntity node) {
        TaskVo taskVO = new TaskVo();
        taskVO.setCreateTime(task.getCreateTime());
        taskVO.setFormNo(processInstance.getFormNo());
        taskVO.setProcessInstanceId(processInstance.getProcessInstanceId());
        taskVO.setProcessKey(processTemplate.getProcessKey());
        taskVO.setProcessName(processTemplate.getProcessName());
        taskVO.setProcessState(processInstance.getProcessState());
        taskVO.setTaskDefinitionKey(task.getTaskDefinitionKey());
        taskVO.setTaskId(task.getId());
        taskVO.setTaskName(task.getName());
        taskVO.setNode(node);
        return taskVO;
    }

    @Override
    public TaskVo findTaskInfoByTaskId(String taskId) {
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return null;
        }
        TaskInfo task = (TaskInfo)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            task = (TaskInfo)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
        }
        if (task == null) {
            return null;
        }
        ProcessTemplateEntity processTemplate = this.processTemplateService.findDetailsByProcessInstanceId(task.getProcessInstanceId());
        if (processTemplate == null) {
            return null;
        }
        ProcessInstanceEntity processInstance = this.processInstanceService.findDetailsByProcessInstanceId(task.getProcessInstanceId());
        if (processInstance == null) {
            return null;
        }
        ProcessTemplateNodeEntity node = this.processTemplateNodeService.findDetailByProcessTemplateIdAndProcessNodeId(processTemplate.getId(), task.getTaskDefinitionKey());
        return this.initTaskInfo(processInstance, processTemplate, task, node);
    }

    @Override
    public List<ProcessAssignmentEntity> findCanSubMultiAssignments(String taskId, Principal principal) {
        Validate.notBlank((CharSequence)taskId, (String)"\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        Validate.notNull((Object)task, (String)"\u672a\u627e\u5230\u6d41\u7a0b\u4efb\u52a1", (Object[])new Object[0]);
        UserVo user = super.getLoginUser(principal);
        ExecutionQuery processExecutionQuery = this.runtimeService.createExecutionQuery();
        Validate.notNull((Object)processExecutionQuery, (String)"\u521b\u5efa\u67e5\u8be2\u5bf9\u8c61\u5931\u8d25\uff0c\u67e5\u8be2\u5bf9\u8c61\u4e3a\u7a7a", (Object[])new Object[0]);
        Execution processExecution = (Execution)processExecutionQuery.processInstanceId(task.getProcessInstanceId()).onlyProcessInstanceExecutions().singleResult();
        Validate.notNull((Object)processExecution, (String)"\u672a\u627e\u5230\u6d41\u7a0b\u6267\u884c\u5b9e\u4f8b", (Object[])new Object[0]);
        ExecutionQuery taskExecutionQuery = this.runtimeService.createExecutionQuery();
        Validate.notNull((Object)processExecutionQuery, (String)"\u521b\u5efa\u67e5\u8be2\u5bf9\u8c61\u5931\u8d25\uff0c\u67e5\u8be2\u5bf9\u8c61\u4e3a\u7a7a", (Object[])new Object[0]);
        Execution taskExecution = (Execution)taskExecutionQuery.executionId(task.getExecutionId()).singleResult();
        Validate.notNull((Object)taskExecution, (String)"\u6d41\u7a0b\u4efb\u52a1\u6267\u884c\u5bf9\u8c61\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        String collection = StringUtils.join((Object[])new String[]{task.getTaskDefinitionKey(), "_mi_assignments"});
        String completedCollection = StringUtils.join((Object[])new String[]{task.getTaskDefinitionKey(), "_mi_completed_assignments"});
        List<String> miAssignments = this.getEditableMultiAssignments(processExecution.getId(), collection, false);
        List<String> completedMiAssignments = this.getEditableMultiAssignments(taskExecution.getParentId(), completedCollection, true);
        if (CollectionUtils.isEmpty(miAssignments)) {
            return Collections.emptyList();
        }
        ArrayList<ProcessAssignmentEntity> assignments = new ArrayList<ProcessAssignmentEntity>();
        for (String miAssignment : miAssignments) {
            if (this.processAssignmentService.equals(user, miAssignment) || completedMiAssignments.contains(miAssignment)) continue;
            try {
                ProcessAssignmentEntity assignment = this.processAssignmentService.findAssignment(miAssignment);
                assignments.add(assignment);
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        return assignments;
    }

    @Override
    public List<ProcessAssignmentEntity> findTaskMultiAssignments(String taskId) {
        Validate.notBlank((CharSequence)taskId, (String)"\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        Validate.notNull((Object)task, (String)"\u672a\u627e\u5230\u6d41\u7a0b\u4efb\u52a1", (Object[])new Object[0]);
        ExecutionQuery processExecutionQuery = this.runtimeService.createExecutionQuery();
        Validate.notNull((Object)processExecutionQuery, (String)"\u521b\u5efa\u67e5\u8be2\u5bf9\u8c61\u5931\u8d25\uff0c\u67e5\u8be2\u5bf9\u8c61\u4e3a\u7a7a", (Object[])new Object[0]);
        Execution processExecution = (Execution)processExecutionQuery.processInstanceId(task.getProcessInstanceId()).onlyProcessInstanceExecutions().singleResult();
        Validate.notNull((Object)processExecution, (String)"\u672a\u627e\u5230\u6d41\u7a0b\u6267\u884c\u5b9e\u4f8b", (Object[])new Object[0]);
        String collection = StringUtils.join((Object[])new String[]{task.getTaskDefinitionKey(), "_mi_assignments"});
        List<String> miAssignments = this.getEditableMultiAssignments(processExecution.getId(), collection, false);
        if (CollectionUtils.isEmpty(miAssignments)) {
            return Collections.emptyList();
        }
        ArrayList<ProcessAssignmentEntity> assignments = new ArrayList<ProcessAssignmentEntity>();
        for (String miAssignment : miAssignments) {
            try {
                ProcessAssignmentEntity assignment = this.processAssignmentService.findAssignment(miAssignment);
                assignments.add(assignment);
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        return assignments;
    }
}

