/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.service.internal;

import com.bizunited.platform.titan.starter.common.enums.MultiType;
import com.bizunited.platform.titan.starter.entity.ProcessAssignmentEntity;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateNodeEntity;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateNodeMultiEntity;
import com.bizunited.platform.titan.starter.repository.ProcessTemplateNodeMultiRepository;
import com.bizunited.platform.titan.starter.service.ProcessAssignmentService;
import com.bizunited.platform.titan.starter.service.ProcessTemplateNodeMultiService;
import com.bizunited.platform.titan.starter.service.internal.BaseService;
import java.util.Date;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ProcessTemplateNodeMultiServiceImpl")
public class ProcessTemplateNodeMultiServiceImpl
extends BaseService
implements ProcessTemplateNodeMultiService {
    @Autowired
    private ProcessTemplateNodeMultiRepository processTemplateNodeMultiRepository;
    @Autowired
    private ProcessAssignmentService processAssignmentService;

    private void saveValidation(ProcessTemplateNodeMultiEntity processTemplateNodeMulti) {
        Validate.notNull((Object)processTemplateNodeMulti.getMiType(), (String)"\u4f1a\u7b7e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (!processTemplateNodeMulti.getMiType().equals(MultiType.NONE_MULTI.getType())) {
            Validate.notNull((Object)processTemplateNodeMulti.getPresetMiAssignments(), (String)"\u662f\u5426\u9884\u7f6e\u4f1a\u7b7e\u4eba\u5458\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)processTemplateNodeMulti.getCompletionCondition(), (String)"\u4f1a\u7b7e\u901a\u8fc7\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            if (Boolean.TRUE.equals(processTemplateNodeMulti.getPresetMiAssignments())) {
                Validate.notEmpty(processTemplateNodeMulti.getAssignments(), (String)"\u9884\u7f6e\u4f1a\u7b7e\u4eba\u5458\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            }
        }
    }

    @Override
    @Transactional
    public ProcessTemplateNodeMultiEntity save(ProcessTemplateNodeEntity node, ProcessTemplateNodeMultiEntity processTemplateNodeMulti) {
        if (processTemplateNodeMulti == null) {
            return null;
        }
        Validate.notNull((Object)((Object)node), (String)"\u6d41\u7a0b\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.saveValidation(processTemplateNodeMulti);
        ProcessTemplateNodeMultiEntity entity = this.processTemplateNodeMultiRepository.findByTemplateNodeId(node.getId());
        if (entity == null) {
            entity = processTemplateNodeMulti;
            entity.setId(null);
            entity.setProcessTemplateNode(node);
            entity.setCreateTime(new Date());
        } else {
            entity.setCompletionCondition(processTemplateNodeMulti.getCompletionCondition());
            entity.setMiType(processTemplateNodeMulti.getMiType());
            entity.setPresetMiAssignments(processTemplateNodeMulti.getPresetMiAssignments());
        }
        entity.setModifyTime(new Date());
        this.processTemplateNodeMultiRepository.save((Object)entity);
        Set<ProcessAssignmentEntity> assignments = this.processAssignmentService.save(entity.getId(), processTemplateNodeMulti.getAssignments());
        entity.setAssignments(assignments);
        return entity;
    }
}

