/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.controller;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.titan.starter.entity.ProcessCarbonCopyEntity;
import com.bizunited.platform.titan.starter.entity.ProcessInstanceEntity;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateEntity;
import com.bizunited.platform.titan.starter.service.ProcessCarbonCopyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.security.Principal;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6d41\u7a0b\u6284\u9001\u529f\u80fd\u4e1a\u52a1\u6a21\u578b\u7684MVC Controller\u5c42\u5b9e\u73b0"})
@RequestMapping(value={"v1/titan/carbonCopies"})
public class ProcessCarbonCopyController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessCarbonCopyController.class);
    @Autowired
    private ProcessCarbonCopyService processCarbonCopyService;

    @GetMapping(value={"findMyByConditions"})
    @ApiOperation(value="\u6761\u4ef6\u5206\u9875\u67e5\u8be2\u6211\u7684\u6284\u9001\u5217\u8868", notes="\u9875\u6570\u53c2\u6570\u4e3apage\uff0c\u7b2c\u4e00\u9875\u4ece0\u5f00\u59cb\uff0c\u5206\u9875\u5927\u5c0f\u53c2\u6570\u4e3asize\uff08size\u9ed8\u8ba4\u4e3a50\uff09")
    public ResponseModel findMyByConditions(@PageableDefault(value=50) Pageable pageable, @RequestParam(value="formNo", required=false) @ApiParam(value="\u8868\u5355\u7f16\u53f7") String formNo, @RequestParam(value="submitDate", required=false) @ApiParam(value="\u63d0\u4ea4\u65f6\u95f4(yyyy-MM-dd)") @DateTimeFormat(pattern="yyyy-MM-dd") Date submitDate, @RequestParam(value="processKey", required=false) @ApiParam(value="\u6d41\u7a0bkey") String processKey, @RequestParam(value="processName", required=false) @ApiParam(value="\u6d41\u7a0b\u540d\u79f0") String processName) {
        try {
            Principal principal = this.getPrincipal();
            ProcessCarbonCopyEntity carbonCopy = new ProcessCarbonCopyEntity();
            ProcessInstanceEntity processInstance = new ProcessInstanceEntity();
            ProcessTemplateEntity processTemplate = new ProcessTemplateEntity();
            processTemplate.setProcessKey(processKey);
            processTemplate.setProcessName(processName);
            processInstance.setFormNo(formNo);
            processInstance.setLatestSubmitTime(submitDate);
            processInstance.setProcessTemplate(processTemplate);
            carbonCopy.setProcessInstance(processInstance);
            Page<ProcessCarbonCopyEntity> page = this.processCarbonCopyService.findMyByConditions(pageable, principal, carbonCopy);
            return this.buildHttpResultW(page, new String[]{"processInstance", "ccUser", "receiveAssignment", "processInstance.processTemplate", "processInstance.applicantUser"});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"read"})
    @ApiOperation(value="\u9605\u8bfb\u6284\u9001\u4fe1\u606f")
    public ResponseModel read(@RequestParam(value="id") @ApiParam(value="\u4e3b\u952eID") String id) {
        try {
            Principal principal = this.getPrincipal();
            this.processCarbonCopyService.read(id, principal);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

