/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.repository.internal;

import com.bizunited.platform.core.repository.internal.PageRepositoryImpl;
import com.bizunited.platform.rbac.server.vo.UserVo;
import com.bizunited.platform.titan.starter.entity.ProcessInstanceEntity;
import com.bizunited.platform.titan.starter.entity.ProcessInstanceOperateRecordEntity;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateEntity;
import com.bizunited.platform.titan.starter.repository.internal.ProcessTaskRepositoryCustom;
import com.bizunited.platform.titan.starter.service.TitanToolkitService;
import com.bizunited.platform.titan.starter.vo.TaskVo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository(value="ProcessTaskRepositoryImpl")
public class ProcessTaskRepositoryImpl
implements ProcessTaskRepositoryCustom,
PageRepositoryImpl {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    @Qualifier(value="TitanToolkitService")
    private TitanToolkitService titanToolkitService;

    @Override
    public Page<TaskVo> findMyTasksByConditions(UserVo user, TaskVo taskVo, Pageable pageable, String projectName) {
        StringBuilder sql = new StringBuilder("SELECT art.ID_ AS taskId, art.TASK_DEF_KEY_ AS taskDefinitionKey, art.NAME_ AS taskName, ");
        sql.append(" ept.process_name AS processName, epi.form_no AS formNo, epi.form_title AS formTitle, art.PROC_INST_ID_ AS processInstanceId,");
        sql.append(" epi.process_state AS processState, epi.applicant_account AS applicantAccount, epi.create_time AS createTime, ept.process_key AS processKey");
        sql.append(" FROM ACT_RU_TASK art ");
        sql.append(" inner JOIN engine_process_instance epi ON art.PROC_INST_ID_ = epi.process_instance_id");
        sql.append(" inner JOIN engine_process_template ept ON ept.id = epi.process_template");
        sql.append(" WHERE (art.ASSIGNEE_ = :userAccount or art.ASSIGNEE_ in :positionCodes or art.ASSIGNEE_ in :roleCodes) ");
        StringBuilder countSql = new StringBuilder("SELECT COUNT(*) ");
        countSql.append(" FROM ACT_RU_TASK art ");
        countSql.append(" inner JOIN engine_process_instance epi ON art.PROC_INST_ID_ = epi.process_instance_id");
        countSql.append(" inner JOIN engine_process_template ept ON ept.id = epi.process_template");
        countSql.append(" WHERE (art.ASSIGNEE_ = :userAccount or art.ASSIGNEE_ in :positionCodes or art.ASSIGNEE_ in :roleCodes) ");
        StringBuilder conditions = new StringBuilder();
        HashMap<String, Object> parameter = new HashMap<String, Object>(16);
        parameter.put("userAccount", StringUtils.join((Object[])new String[]{"username:", user.getAccount()}));
        List<String> roleCodes = this.titanToolkitService.getAssignmentRoleCodes(user.getRoles());
        if (roleCodes == null) {
            roleCodes = new ArrayList<String>();
        }
        if (roleCodes.isEmpty()) {
            roleCodes.add("-0101010101");
        }
        parameter.put("roleCodes", roleCodes);
        List<String> positionCodes = this.titanToolkitService.getAssignmentPositionCodes(user.getPositions());
        if (positionCodes == null) {
            positionCodes = new ArrayList<String>();
        }
        if (positionCodes.isEmpty()) {
            positionCodes.add("-0101010101");
        }
        parameter.put("positionCodes", positionCodes);
        if (taskVo != null) {
            if (StringUtils.isNotBlank((CharSequence)taskVo.getFormNo())) {
                conditions.append(" and epi.form_no = :formNo");
                parameter.put("formNo", taskVo.getFormNo());
            }
            if (StringUtils.isNotBlank((CharSequence)taskVo.getFormTitle())) {
                conditions.append(" and epi.form_title = :formTitle");
                parameter.put("formTitle", taskVo.getFormTitle());
            }
            if (StringUtils.isNotBlank((CharSequence)taskVo.getProcessKey())) {
                conditions.append(" and ept.process_key = :processKey");
                parameter.put("processKey", taskVo.getProcessKey());
            }
            if (StringUtils.isNotBlank((CharSequence)taskVo.getProcessName())) {
                conditions.append(" and ept.process_name = :processName");
                parameter.put("processName", taskVo.getProcessName());
            }
            if (StringUtils.isNotBlank((CharSequence)taskVo.getProcessInstanceId())) {
                conditions.append(" and art.PROC_INST_ID_ = :processInstanceId");
                parameter.put("processInstanceId", taskVo.getProcessInstanceId());
            }
            if (taskVo.getProcessState() != null) {
                conditions.append(" and epi.process_state = :processState");
                parameter.put("processState", taskVo.getProcessState());
            }
            if (StringUtils.isNotBlank((CharSequence)taskVo.getTaskName())) {
                conditions.append(" and art.NAME_ = :taskName");
                parameter.put("taskName", taskVo.getTaskName());
            }
            if (StringUtils.isNotBlank((CharSequence)taskVo.getTaskId())) {
                conditions.append(" and art.ID_ = :taskId");
                parameter.put("taskId", taskVo.getTaskId());
            }
            if (taskVo.getCreateTime() != null) {
                conditions.append(" and epi.create_time >= :createTime");
                parameter.put("createTime", taskVo.getCreateTime());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)projectName)) {
            conditions.append(" and epi.project_name = :projectName");
            parameter.put("projectName", projectName);
        } else {
            conditions.append(" and (epi.project_name = '' or epi.project_name IS NULL)");
        }
        sql.append((CharSequence)conditions).append(" order by art.CREATE_TIME_ ASC");
        countSql.append((CharSequence)conditions);
        return this.queryByConditions(this.entityManager, sql.toString(), countSql.toString(), parameter, pageable, true, TaskVo.class);
    }

    @Override
    public Page<ProcessInstanceOperateRecordEntity> findDoneByConditions(Pageable pageable, ProcessInstanceOperateRecordEntity record, UserVo user, String projectName) {
        StringBuilder hql = new StringBuilder("select pior from ProcessInstanceOperateRecordEntity pior ");
        hql.append(" inner join fetch pior.processInstance pi ");
        hql.append(" inner join fetch pior.processTemplateNode ptn ");
        hql.append(" inner join fetch pi.processTemplate pt");
        hql.append(" where pior.operatorAccount = :operator and pior.operation in ('BTN_001','BTN_002','BTN_003','BTN_012','BTN_013') ");
        StringBuilder countHql = new StringBuilder("select count(*) from ProcessInstanceOperateRecordEntity pior ");
        countHql.append(" inner join pior.processInstance pi ");
        countHql.append(" inner join pior.processTemplateNode ptn ");
        countHql.append(" inner join pi.processTemplate pt");
        countHql.append(" where pior.operatorAccount = :operator and pior.operation in ('BTN_001','BTN_002','BTN_003','BTN_012','BTN_013') ");
        StringBuilder condition = new StringBuilder();
        HashMap<String, Object> parameter = new HashMap<String, Object>(16);
        parameter.put("operator", user.getAccount());
        ProcessInstanceEntity processInstance = record.getProcessInstance();
        if (processInstance != null) {
            ProcessTemplateEntity processTemplate;
            if (processInstance.getProcessState() != null) {
                condition.append(" and pi.processState = :processState ");
                parameter.put("processState", processInstance.getProcessState());
            }
            if (StringUtils.isNotBlank((CharSequence)processInstance.getFormNo())) {
                condition.append(" and pi.formNo = :formNo ");
                parameter.put("formNo", processInstance.getFormNo());
            }
            if ((processTemplate = processInstance.getProcessTemplate()) != null) {
                if (StringUtils.isNotBlank((CharSequence)processTemplate.getProcessKey())) {
                    condition.append(" and pt.processKey = :processKey ");
                    parameter.put("processKey", processTemplate.getProcessKey());
                }
                if (StringUtils.isNotBlank((CharSequence)processTemplate.getProcessName())) {
                    condition.append(" and pt.processName = :processName ");
                    parameter.put("processName", processTemplate.getProcessName());
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)projectName)) {
            condition.append(" and pi.projectName = :projectName ");
            parameter.put("projectName", projectName);
        } else {
            condition.append(" and pi.projectName = '' or pi.projectName is null");
        }
        hql.append((CharSequence)condition).append(" order by pior.createTime desc");
        countHql.append((CharSequence)condition);
        return this.queryByConditions(this.entityManager, hql.toString(), countHql.toString(), parameter, pageable, false, null);
    }
}

