/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.titan.starter.entity.ProcessCheckRecordEntity;
import com.bizunited.platform.titan.starter.service.ProcessCheckRecordService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6d41\u7a0b\u68c0\u6d4b\u529f\u80fd\u4e1a\u52a1\u6a21\u578b\u7684MVC Controller\u5c42\u5b9e\u73b0"})
@RequestMapping(value={"v1/titan/process/checks"})
public class ProcessCheckController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessCheckController.class);
    @Autowired
    private ProcessCheckRecordService processCheckRecordService;

    @PostMapping(value={""})
    @ApiOperation(value="\u6d41\u7a0b\u68c0\u6d4b")
    public ResponseModel checkProcess(@RequestParam(value="templateId") @ApiParam(value="\u6a21\u7248ID", required=true) String templateId, @RequestParam(value="assignment") @ApiParam(value="\u53d1\u8d77\u4eba", required=true) String assignment, @RequestBody Map<String, Object> variables) {
        try {
            Principal principal = this.getPrincipal();
            ProcessCheckRecordEntity record = this.processCheckRecordService.checkProcess(templateId, assignment, variables, principal);
            return this.buildHttpResultW((Object)record, new String[]{"processCheckRecordItems", "createUser", "processTemplate"});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByTemplateId"})
    @ApiOperation(value="\u6839\u636e\u6a21\u7248ID\u67e5\u8be2\u6d41\u7a0b\u68c0\u6d4b\u8bb0\u5f55")
    public ResponseModel findByTemplateId(@RequestParam(value="templateId") @ApiParam(value="\u6a21\u7248ID", required=true) String templateId) {
        try {
            List<ProcessCheckRecordEntity> records = this.processCheckRecordService.findByTemplateId(templateId);
            return this.buildHttpResultW(records, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findDetailById"})
    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u68c0\u6d4b\u8be6\u60c5")
    public ResponseModel findDetailById(@RequestParam(value="id") @ApiParam(value="ID", required=true) String id) {
        try {
            ProcessCheckRecordEntity record = this.processCheckRecordService.findDetailById(id);
            return this.buildHttpResultW((Object)record, new String[]{"processCheckRecordItems", "createUser", "processTemplate"});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

