/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.titan.starter.entity.ProcessGroupEntity;
import com.bizunited.platform.titan.starter.service.ProcessGroupService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/titan/process/groups"})
@Api(value="\u6d41\u7a0b\u5206\u7ec4\u63a5\u53e3", tags={"\u6d41\u7a0b\u5206\u7ec4\u63a5\u53e3"})
public class ProcessGroupController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessGroupController.class);
    @Autowired
    private ProcessGroupService processGroupService;

    @PostMapping(value={""})
    @ApiOperation(value="\u521b\u5efa\u5206\u7ec4")
    public ResponseModel create(@RequestBody ProcessGroupEntity group) {
        try {
            ProcessGroupEntity dbGroup = this.processGroupService.create(group);
            return this.buildHttpResultW((Object)dbGroup, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PatchMapping(value={""})
    @ApiOperation(value="\u66f4\u65b0\u5206\u7ec4")
    public ResponseModel update(@RequestBody ProcessGroupEntity group) {
        try {
            ProcessGroupEntity updatedGroup = this.processGroupService.update(group);
            return this.buildHttpResultW((Object)updatedGroup, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @DeleteMapping(value={"deleteById"})
    @ApiOperation(value="\u6839\u636eID\u5220\u9664\u5206\u7ec4")
    public ResponseModel deleteById(String id) {
        try {
            this.processGroupService.deleteById(id);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={""})
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u5206\u7ec4")
    public ResponseModel findAll() {
        try {
            List<ProcessGroupEntity> groups = this.processGroupService.findAll();
            return this.buildHttpResultW(groups, new String[]{"processTemplates"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

