/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.titan.starter.entity.ProcessInstanceAttachmentEntity;
import com.bizunited.platform.titan.starter.service.ProcessInstanceAttachmentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.security.Principal;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6d41\u7a0b\u5b9e\u4f8b\u9644\u4ef6\u529f\u80fd\u4e1a\u52a1\u6a21\u578b\u7684MVC Controller\u5c42\u5b9e\u73b0"})
@RestController
@RequestMapping(value={"v1/titan/instance/attachments"})
public class ProcessInstanceAttachmentController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessInstanceAttachmentController.class);
    @Autowired
    private ProcessInstanceAttachmentService processInstanceAttachmentService;

    @PostMapping(value={""})
    @ApiOperation(value="\u4fdd\u5b58\u9644\u4ef6\u4fe1\u606f")
    public ResponseModel create(@RequestParam(name="processInstanceId") @ApiParam(value="\u6d41\u7a0b\u5b9e\u4f8bID", required=true) String processInstanceId, @RequestBody Set<ProcessInstanceAttachmentEntity> attachments) {
        try {
            Principal principal = this.getPrincipal();
            Set<ProcessInstanceAttachmentEntity> attachmentEntities = this.processInstanceAttachmentService.create(processInstanceId, attachments, principal);
            return this.buildHttpResultW(attachmentEntities, new String[]{"ordinaryFile"});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @DeleteMapping(value={"deleteById"})
    @ApiOperation(value="\u6839\u636eID\u5220\u9664\u9644\u4ef6\u4fe1\u606f", notes="\u8fd9\u91cc\u7684ID\u4e0d\u662f\u6e90\u6587\u4ef6\u7684ID\uff0c\u662f\u6d41\u7a0b\u5b9e\u4f8b\u9644\u4ef6\u4fe1\u606f\u7684ID")
    public ResponseModel deleteById(@RequestParam(name="id") @ApiParam(value="\u4e3b\u952eID", required=true) String id) {
        try {
            this.processInstanceAttachmentService.deleteById(id);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

