/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.titan.starter.entity.ProcessAssignmentEntity;
import com.bizunited.platform.titan.starter.entity.ProcessCarbonCopyEntity;
import com.bizunited.platform.titan.starter.entity.ProcessInstanceEntity;
import com.bizunited.platform.titan.starter.entity.ProcessInstanceOperateRecordEntity;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateEntity;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateNodeEntity;
import com.bizunited.platform.titan.starter.service.ProcessTaskService;
import com.bizunited.platform.titan.starter.service.invoke.model.ProcessInputParamsModel;
import com.bizunited.platform.titan.starter.vo.TaskVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.security.Principal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6d41\u7a0b\u4efb\u52a1\u529f\u80fd\u4e1a\u52a1\u6a21\u578b\u7684MVC Controller\u5c42\u5b9e\u73b0"})
@RestController
@RequestMapping(value={"v1/titan/tasks"})
public class ProcessTaskController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessTaskController.class);
    @Autowired
    private ProcessTaskService processTaskService;

    @PostMapping(value={"handleTask"})
    @ApiOperation(value="\u4efb\u52a1\u64cd\u4f5c", notes="\u652f\u6301\u64cd\u4f5c\uff1aBTN_001(\u5ba1\u6279\u901a\u8fc7),BTN_002(\u9a73\u56de),BTN_003(\u56de\u9000),BTN_004(\u53d6\u56de),BTN_011(\u63d0\u4ea4),BTN_012(\u64a4\u9500),BTN_013(\u7ec8\u6b62)")
    public ResponseModel handleTask(@RequestBody ProcessInputParamsModel model) {
        try {
            Object result = this.processTaskService.handleTask(model);
            return this.buildHttpResultW(result, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PostMapping(value={"handleTransferAssignee"})
    @ApiOperation(value="\u4efb\u52a1\u8f6c\u529e")
    public ResponseModel handleTransferAssignee(@RequestParam(value="taskId") @ApiParam(value="\u4efb\u52a1ID", required=true) String taskId, @RequestParam(value="targetAssignment") @ApiParam(value="\u4efb\u52a1\u8f6c\u529e\u76ee\u6807\u7528\u6237", required=true) String targetAssignment, @RequestParam(value="content", required=false) @ApiParam(value="\u5ba1\u6279\u5185\u5bb9") String content) {
        try {
            Principal principal = this.getPrincipal();
            this.processTaskService.handleTransferAssignee(taskId, targetAssignment, principal, content);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PostMapping(value={"handleCarbonCopy"})
    @ApiOperation(value="\u4efb\u52a1\u6284\u9001")
    public ResponseModel handleCarbonCopy(@RequestParam(value="taskId") @ApiParam(value="\u4efb\u52a1ID", required=true) String taskId, @RequestBody @ApiParam(value="\u6284\u9001\u7684\u7528\u6237\u540d\u7ec4") List<String> assignments) {
        try {
            Principal principal = this.getPrincipal();
            List<ProcessCarbonCopyEntity> carbonCopies = this.processTaskService.handleCarbonCopy(taskId, assignments, principal);
            return this.buildHttpResultW(carbonCopies, new String[]{"processInstance", "ccUser", "receiveAssignment"});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PostMapping(value={"handleAddMulti"})
    @ApiOperation(value="\u6dfb\u52a0\u4f1a\u7b7e\u4eba\u5458")
    public ResponseModel handleAddMulti(@RequestParam(value="taskId") @ApiParam(value="\u4efb\u52a1ID", required=true) String taskId, @RequestParam(value="content", required=false) @ApiParam(value="\u610f\u89c1") String content, @RequestBody @ApiParam(value="\u4f1a\u7b7e\u4eba\u5458") List<String> assignments) {
        try {
            Principal principal = this.getPrincipal();
            this.processTaskService.handleAddMulti(taskId, assignments, principal, content);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PostMapping(value={"handleSubMulti"})
    @ApiOperation(value="\u5220\u9664\u4f1a\u7b7e\u4eba\u5458")
    public ResponseModel handleSubMulti(@RequestParam(value="taskId") @ApiParam(value="\u4efb\u52a1ID", required=true) String taskId, @RequestParam(value="content", required=false) @ApiParam(value="\u610f\u89c1") String content, @RequestBody @ApiParam(value="\u5220\u9664\u4f1a\u7b7e\u4eba\u5458", required=true) List<String> assignments) {
        try {
            Principal principal = this.getPrincipal();
            this.processTaskService.handleSubMulti(taskId, assignments, principal, content);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PostMapping(value={"batchComplete"})
    @ApiOperation(value="\u6279\u91cf\u5ba1\u6279\u901a\u8fc7", notes="\u6279\u91cf\u5ba1\u6279\u901a\u8fc7,\u8bb0\u5f55\u7684\u64cd\u4f5c\u4f9d\u7136\u662fBTN_001(\u5ba1\u6279\u901a\u8fc7)\uff0c\u4f46\u5728\u5ba1\u6279\u610f\u89c1\u4e2d\u4f1a\u6dfb\u52a0\u3010\u6279\u91cf\u5ba1\u6279\u3011\u6807\u8bc6")
    public ResponseModel batchComplete(@RequestParam @ApiParam(value="\u4efb\u52a1ID", required=true) String[] taskIds, @RequestParam(required=false) @ApiParam(value="\u610f\u89c1") String content) {
        try {
            this.processTaskService.batchComplete(taskIds, content);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PostMapping(value={"batchReject"})
    @ApiOperation(value="\u6279\u91cf\u9a73\u56de", notes="\u6279\u91cf\u9a73\u56de,\u8bb0\u5f55\u7684\u64cd\u4f5c\u4f9d\u7136\u662fBTN_001(\u5ba1\u6279\u901a\u8fc7)\uff0c\u4f46\u5728\u5ba1\u6279\u610f\u89c1\u4e2d\u4f1a\u6dfb\u52a0\u3010\u6279\u91cf\u9a73\u56de\u3011\u6807\u8bc6")
    public ResponseModel batchReject(@RequestParam @ApiParam(value="\u4efb\u52a1ID", required=true) String[] taskIds, @RequestParam @ApiParam(value="\u610f\u89c1", required=true) String content) {
        try {
            this.processTaskService.batchReject(taskIds, content);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findMyTasksByConditions"})
    @ApiOperation(value="\u67e5\u8be2\u6211\u7684\u5f85\u529e")
    public ResponseModel findMyTasksByConditions(@PageableDefault(value=50) Pageable pageable, TaskVo taskVo) {
        try {
            Principal principal = this.getPrincipal();
            Page<TaskVo> carbonCopies = this.processTaskService.findMyTasksByConditions(taskVo, principal, pageable);
            return this.buildHttpResultW((Iterable)carbonCopies, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findDoneByConditions"})
    @ApiOperation(value="\u67e5\u8be2\u6211\u5df2\u529e\u7684\u4efb\u52a1", notes="\u9875\u6570\u53c2\u6570\u4e3apage\uff0c\u7b2c\u4e00\u9875\u4ece0\u5f00\u59cb\uff0c\u5206\u9875\u5927\u5c0f\u53c2\u6570\u4e3asize\uff08size\u9ed8\u8ba4\u4e3a50\uff09")
    public ResponseModel findDoneByConditions(@PageableDefault(value=50) Pageable pageable, @RequestParam(name="processKey", required=false) @ApiParam(value="\u6a21\u7248key") String processKey, @RequestParam(name="processName", required=false) @ApiParam(value="\u6a21\u7248\u540d\u79f0") String processName, @RequestParam(name="formNo", required=false) @ApiParam(value="\u8868\u5355\u7f16\u53f7") String formNo, @RequestParam(name="state", required=false) @ApiParam(value="\u6d41\u7a0b\u72b6\u6001") Integer state) {
        try {
            Principal principal = this.getPrincipal();
            ProcessInstanceOperateRecordEntity record = new ProcessInstanceOperateRecordEntity();
            ProcessInstanceEntity processInstance = new ProcessInstanceEntity();
            ProcessTemplateEntity processTemplate = new ProcessTemplateEntity();
            processTemplate.setProcessKey(processKey);
            processTemplate.setProcessName(processName);
            processInstance.setProcessTemplate(processTemplate);
            processInstance.setFormNo(formNo);
            processInstance.setProcessState(state);
            record.setProcessInstance(processInstance);
            Page<ProcessInstanceOperateRecordEntity> page = this.processTaskService.findDoneByConditions(pageable, record, principal);
            return this.buildHttpResultW((Iterable)page, new String[]{"processInstance", "processInstance.processTemplate", "processTemplateNode", "processInstance.applicantUser"});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findBackableNodes"})
    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u5b9e\u4f8b\u53ef\u56de\u9000\u7684\u8282\u70b9")
    public ResponseModel findBackableNodes(@RequestParam(value="processInstanceId") @ApiParam(value="\u6d41\u7a0b\u5b9e\u4f8bID") String processInstanceId) {
        try {
            List<ProcessTemplateNodeEntity> nodes = this.processTaskService.findBackableNodes(processInstanceId);
            return this.buildHttpResultW(nodes, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findTaskInfoByInstanceIdAndTaskKey"})
    @ApiOperation(value="\u6839\u636e\u5b9e\u4f8bID\u548c\u8282\u70b9key\u67e5\u8be2\u4efb\u52a1\u4fe1\u606f")
    public ResponseModel findTaskInfoByInstanceIdAndTaskKey(@RequestParam(value="processInstanceId") @ApiParam(value="\u6d41\u7a0b\u5b9e\u4f8bID") String processInstanceId, @RequestParam(value="taskKey") @ApiParam(value="\u6d41\u7a0b\u8282\u70b9key") String taskKey) {
        try {
            TaskVo taskVO = this.processTaskService.findTaskInfoByInstanceIdAndTaskKey(processInstanceId, taskKey);
            return this.buildHttpResultW(taskVO, new String[]{"node", "node.processTemplateNodePermission", "node.processTemplateNodeMulti", "node.assignment", "node.processTemplateNodeMulti.assignments"});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findTaskInfoByTaskId"})
    @ApiOperation(value="\u6839\u636e\u8282\u70b9\u5b9e\u4f8bID\u67e5\u8be2\u4efb\u52a1\u4fe1\u606f")
    public ResponseModel findTaskInfoByTaskId(@RequestParam(value="taskId") @ApiParam(value="\u6d41\u7a0b\u5b9e\u4f8b\u4efb\u52a1ID") String taskId) {
        try {
            TaskVo taskVO = this.processTaskService.findTaskInfoByTaskId(taskId);
            return this.buildHttpResultW(taskVO, new String[]{"node", "node.processTemplateNodePermission", "node.processTemplateNodeMulti", "node.assignment", "node.processTemplateNodeMulti.assignments"});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findCanSubMultiAssignments"})
    @ApiOperation(value="\u6839\u636e\u8282\u70b9\u5b9e\u4f8bID\u67e5\u8be2\u53ef\u51cf\u7b7e\u4eba\u5458")
    public ResponseModel findCanSubMultiAssignments(@RequestParam(value="taskId") @ApiParam(value="\u6d41\u7a0b\u5b9e\u4f8b\u4efb\u52a1ID") String taskId) {
        try {
            Principal principal = this.getPrincipal();
            List<ProcessAssignmentEntity> assignments = this.processTaskService.findCanSubMultiAssignments(taskId, principal);
            return this.buildHttpResultW(assignments, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findTaskMultiAssignments"})
    @ApiOperation(value="\u6839\u636e\u8282\u70b9\u5b9e\u4f8bID\u67e5\u8be2\u4f1a\u7b7e\u4eba\u5458")
    public ResponseModel findTaskMultiAssignments(@RequestParam(value="taskId") @ApiParam(value="\u6d41\u7a0b\u5b9e\u4f8b\u4efb\u52a1ID") String taskId) {
        try {
            List<ProcessAssignmentEntity> assignments = this.processTaskService.findTaskMultiAssignments(taskId);
            return this.buildHttpResultW(assignments, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

