/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.listener.proxy;

import com.bizunited.platform.core.service.ScriptService;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.core.service.invoke.InvokeProxy;
import com.bizunited.platform.core.service.invoke.InvokeProxyBuilder;
import com.bizunited.platform.core.service.invoke.InvokeRequestHandle;
import com.bizunited.platform.core.service.invoke.InvokeResponseHandle;
import com.bizunited.platform.core.service.invoke.handle.request.PrincipalHandle;
import com.bizunited.platform.core.service.invoke.handle.request.TransactionalHandle;
import com.bizunited.platform.titan.starter.common.enums.ProcessListenerExecuteMode;
import com.bizunited.platform.titan.starter.entity.ProcessListenerEntity;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateListenerEntity;
import com.bizunited.platform.titan.starter.service.ProcessTemplateListenerService;
import com.bizunited.platform.titan.starter.service.invoke.handle.request.AbstractListenerHandle;
import com.bizunited.platform.titan.starter.service.invoke.handle.request.ExecutionListenerNotifyHandle;
import com.bizunited.platform.titan.starter.service.invoke.handle.request.ExecutionScriptListenerHandle;
import com.bizunited.platform.titan.starter.service.invoke.handle.response.ListenerResponseHandle;
import java.util.List;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.ExecutionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="ExecutionProxyListener")
public class ExecutionProxyListener
implements ExecutionListener {
    private static final long serialVersionUID = 6330718602637397814L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionProxyListener.class);
    @Autowired
    private ScriptService scriptService;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private PrincipalHandle principalHandle;
    @Autowired
    private TransactionalHandle transactionalHandle;
    @Autowired
    private ListenerResponseHandle listenerResponseHandle;
    @Autowired
    private ProcessTemplateListenerService processTemplateListenerService;

    public void notify(DelegateExecution execution) {
        LOGGER.info("\u8282\u70b9\uff1a{}", (Object)execution.getCurrentActivityId());
        LOGGER.info("EventName: {}", (Object)execution.getEventName());
        List<ProcessTemplateListenerEntity> listeners = this.processTemplateListenerService.findDetailsByProcessDefinitionIdAndTargetIdAndEvent(execution.getProcessDefinitionId(), execution.getCurrentActivityId(), execution.getEventName());
        if (!CollectionUtils.isEmpty(listeners)) {
            InvokeProxyBuilder build = new InvokeProxyBuilder();
            build.addClassLoader(this.applicationContext.getClassLoader());
            build.addInvokeRequestFilter(new InvokeRequestHandle[]{this.principalHandle, this.transactionalHandle});
            for (ProcessTemplateListenerEntity listener : listeners) {
                AbstractListenerHandle handle;
                ProcessListenerEntity processListener = listener.getProcessListener();
                if (processListener.getExecuteMode().equals(ProcessListenerExecuteMode.ORIGIN.getMode())) {
                    handle = new ExecutionListenerNotifyHandle(execution, processListener, listener.getVariables());
                    build.addInvokeRequestFilter(new InvokeRequestHandle[]{handle});
                    continue;
                }
                if (!processListener.getExecuteMode().equals(ProcessListenerExecuteMode.SCRIPT.getMode())) continue;
                handle = new ExecutionScriptListenerHandle(listener.getScript(), execution, this.scriptService, listener.getVariables());
                build.addInvokeRequestFilter(new InvokeRequestHandle[]{handle});
            }
            build.addInvokeResponseFilter(new InvokeResponseHandle[]{this.listenerResponseHandle});
            InvokeProxy invokeProxy = build.build();
            try {
                invokeProxy.invoke(new InvokeParams());
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
    }
}

