/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.repository.internal;

import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.titan.starter.entity.ProcessCarbonCopyEntity;
import com.bizunited.platform.titan.starter.entity.ProcessInstanceEntity;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateEntity;
import com.bizunited.platform.titan.starter.repository.internal.ProcessCarbonCopyRepositoryCustom;
import com.bizunited.platform.titan.starter.service.TitanToolkitService;
import com.bizunited.platform.user.common.vo.UserVo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository(value="ProcessCarbonCopyRepositoryImpl")
public class ProcessCarbonCopyRepositoryImpl
implements ProcessCarbonCopyRepositoryCustom,
PageRepositoryImpl {
    @Autowired
    private EntityManager entityManager;
    @Autowired
    private RoleService roleService;
    @Autowired
    @Qualifier(value="TitanToolkitService")
    private TitanToolkitService titanToolkitService;

    @Override
    public Page<ProcessCarbonCopyEntity> findMyByConditions(Pageable pageable, ProcessCarbonCopyEntity carbonCopy, UserVo user, String projectName) {
        ProcessInstanceEntity processInstance;
        StringBuilder hql = new StringBuilder("select pcc from ProcessCarbonCopyEntity pcc ");
        hql.append(" inner join fetch pcc.processInstance pi ");
        hql.append(" inner join fetch pi.processTemplate pt");
        hql.append(" inner join fetch pcc.receiveAssignment pcca");
        hql.append(" where (pcca.assignment = :account or pcca.assignment in :positionCodes or pcca.assignment in :roleCodes) ");
        StringBuilder countHql = new StringBuilder("select count(*) from ProcessCarbonCopyEntity pcc ");
        countHql.append(" inner join pcc.processInstance pi ");
        countHql.append(" inner join pi.processTemplate pt");
        countHql.append(" inner join pcc.receiveAssignment pcca");
        countHql.append(" where (pcca.assignment = :account or pcca.assignment in :positionCodes or pcca.assignment in :roleCodes) ");
        StringBuilder conditions = new StringBuilder();
        HashMap<String, Object> parameter = new HashMap<String, Object>(16);
        parameter.put("account", StringUtils.join((Object[])new String[]{"username:", user.getAccount()}));
        List<String> positionCodes = this.titanToolkitService.getAssignmentPositionCodes(user.getPositions());
        if (positionCodes == null) {
            positionCodes = new ArrayList<String>();
        }
        if (positionCodes.isEmpty()) {
            positionCodes.add("-0101010101");
        }
        parameter.put("positionCodes", positionCodes);
        List roles = this.roleService.findAllByUserId(user.getId(), Integer.valueOf(0));
        List<String> roleCodes = this.titanToolkitService.getAssignmentRoleCodes(roles);
        if (roleCodes == null) {
            roleCodes = new ArrayList<String>();
        }
        if (roleCodes.isEmpty()) {
            roleCodes.add("-0101010101");
        }
        parameter.put("roleCodes", roleCodes);
        if (carbonCopy != null && (processInstance = carbonCopy.getProcessInstance()) != null) {
            ProcessTemplateEntity processTemplate = processInstance.getProcessTemplate();
            if (StringUtils.isNotBlank((CharSequence)processInstance.getFormNo())) {
                conditions.append(" and pi.formNo = :formNo ");
                parameter.put("formNo", processInstance.getFormNo());
            }
            if (processInstance.getLatestSubmitTime() != null) {
                conditions.append(" and pi.latestSubmitTime >= :latestSubmitTime ");
                parameter.put("latestSubmitTime", processInstance.getLatestSubmitTime());
            }
            if (processTemplate != null) {
                if (StringUtils.isNotBlank((CharSequence)processTemplate.getProcessKey())) {
                    conditions.append(" and pt.processKey = :processKey ");
                    parameter.put("processKey", processTemplate.getProcessKey());
                }
                if (StringUtils.isNotBlank((CharSequence)processTemplate.getProcessName())) {
                    conditions.append(" and pt.processName = :processName ");
                    parameter.put("processName", processTemplate.getProcessName());
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)projectName)) {
            conditions.append(" and pi.projectName = :projectName ");
            parameter.put("projectName", projectName);
        } else {
            conditions.append(" and (pi.projectName = '' or pi.projectName is null )");
        }
        hql.append(conditions.toString()).append(" order by pcc.state asc, pcc.createTime desc ");
        countHql.append(conditions.toString());
        return this.queryByConditions(this.entityManager, hql.toString(), countHql.toString(), parameter, pageable, false, null);
    }
}

