/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.repository.internal;

import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.titan.starter.entity.ProcessInstanceEntity;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateEntity;
import com.bizunited.platform.titan.starter.repository.internal.ProcessInstanceRepositoryCustom;
import java.util.HashMap;
import javax.persistence.EntityManager;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository(value="ProcessInstanceRepositoryImpl")
public class ProcessInstanceRepositoryImpl
implements ProcessInstanceRepositoryCustom,
PageRepositoryImpl {
    @Autowired
    private EntityManager entityManager;

    @Override
    public Page<ProcessInstanceEntity> findByConditions(Pageable pageable, ProcessInstanceEntity processInstance) {
        StringBuilder hql = new StringBuilder("select distinct pi from ProcessInstanceEntity pi ");
        hql.append(" inner join fetch pi.processTemplate pipt ");
        hql.append(" left join fetch pi.latestNode piln ");
        hql.append(" where 1=1 ");
        StringBuilder countHql = new StringBuilder("select count(distinct pi) from ProcessInstanceEntity pi ");
        countHql.append(" inner join pi.processTemplate pipt ");
        countHql.append(" left join pi.latestNode piln ");
        countHql.append(" where 1=1 ");
        StringBuilder condition = new StringBuilder();
        HashMap<String, Object> parameter = new HashMap<String, Object>(16);
        if (processInstance != null) {
            ProcessTemplateEntity processTemplate;
            if (processInstance.getProcessState() != null) {
                condition.append(" and pi.processState = :processState ");
                parameter.put("processState", processInstance.getProcessState());
            }
            if (StringUtils.isNotBlank((CharSequence)processInstance.getFormNo())) {
                condition.append(" and pi.formNo = :formNo ");
                parameter.put("formNo", processInstance.getFormNo());
            }
            if (processInstance.getLatestSubmitTime() != null) {
                condition.append(" and pi.latestSubmitTime >= :latestSubmitTime ");
                parameter.put("latestSubmitTime", processInstance.getLatestSubmitTime());
            }
            if (processInstance.getApplicantAccount() != null) {
                condition.append(" and pi.applicantAccount = :applicantAccount ");
                parameter.put("applicantAccount", processInstance.getApplicantAccount());
            }
            if ((processTemplate = processInstance.getProcessTemplate()) != null) {
                if (StringUtils.isNotBlank((CharSequence)processTemplate.getProcessKey())) {
                    condition.append(" and pipt.processKey = :processKey ");
                    parameter.put("processKey", processTemplate.getProcessKey());
                }
                if (StringUtils.isNotBlank((CharSequence)processTemplate.getProcessName())) {
                    condition.append(" and pipt.processName = :processName ");
                    parameter.put("processName", processTemplate.getProcessName());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)processInstance.getProjectName())) {
                condition.append(" AND pi.projectName = :projectName");
                parameter.put("projectName", processInstance.getProjectName());
            } else {
                condition.append(" AND (pi.projectName = '' OR pi.projectName IS NULL)");
            }
        }
        hql.append((CharSequence)condition).append(" order by pi.latestSubmitTime desc");
        countHql.append((CharSequence)condition);
        return this.queryByConditions(this.entityManager, hql.toString(), countHql.toString(), parameter, pageable, false, null);
    }
}

