/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.repository.internal;

import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateEntity;
import com.bizunited.platform.titan.starter.repository.internal.ProcessTemplateRepositoryCustom;
import com.bizunited.platform.user.common.vo.OrganizationVo;
import com.bizunited.platform.user.common.vo.PositionVo;
import com.bizunited.platform.user.common.vo.UserVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository(value="ProcessTemplateRepositoryCustomImpl")
public class ProcessTemplateRepositoryImpl
implements ProcessTemplateRepositoryCustom,
PageRepositoryImpl {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private RoleService roleService;

    @Override
    public Page<ProcessTemplateEntity> findByConditions(Pageable pageable, ProcessTemplateEntity processTemplate) {
        StringBuilder hql = new StringBuilder("select pt from ProcessTemplateEntity pt where 1=1 ");
        StringBuilder countHql = new StringBuilder("select count(*) from ProcessTemplateEntity pt where 1=1 ");
        StringBuilder condition = new StringBuilder();
        HashMap<String, Object> parameter = new HashMap<String, Object>(4);
        if (processTemplate != null) {
            if (StringUtils.isNotBlank((CharSequence)processTemplate.getProcessKey())) {
                condition.append(" AND pt.processKey = :processKey");
                parameter.put("processKey", processTemplate.getProcessKey());
            }
            if (StringUtils.isNotBlank((CharSequence)processTemplate.getProcessName())) {
                condition.append(" AND pt.processName = :processName");
                parameter.put("processName", processTemplate.getProcessName());
            }
            if (StringUtils.isNotBlank((CharSequence)processTemplate.getFormName())) {
                condition.append(" AND pt.formName = :getFormName");
                parameter.put("formName", processTemplate.getProcessName());
            }
            if (processTemplate.getLastVersion() != null) {
                condition.append(" AND pt.isLastVersion = :isLastVersion");
                parameter.put("isLastVersion", processTemplate.getLastVersion());
            }
            if (processTemplate.getFormType() != null) {
                condition.append(" AND pt.formType = :formType");
                parameter.put("formType", processTemplate.getFormType());
            }
            if (processTemplate.getProcessState() != null) {
                condition.append(" AND pt.processState = :processState");
                parameter.put("processState", processTemplate.getProcessState());
            }
            if (StringUtils.isNotBlank((CharSequence)processTemplate.getProjectName())) {
                condition.append(" AND pt.projectName = :projectName");
                parameter.put("projectName", processTemplate.getProjectName());
            } else {
                condition.append(" AND (pt.projectName = '' OR pt.projectName IS NULL)");
            }
        }
        hql.append((CharSequence)condition).append(" order by pt.modifyTime desc");
        countHql.append((CharSequence)condition);
        return this.queryByConditions(this.entityManager, hql.toString(), countHql.toString(), parameter, pageable, false, null);
    }

    @Override
    public Page<ProcessTemplateEntity> findStartableByConditions(Pageable pageable, ProcessTemplateEntity processTemplate, UserVo user) {
        StringBuilder hql = new StringBuilder("select distinct pt from ProcessTemplateEntity pt left join pt.permissions ptp left join fetch pt.processGroup pg where pt.isLastDeployedVersion = 1 and pt.processState = 1 ");
        StringBuilder countHql = new StringBuilder("select count(distinct pt) from ProcessTemplateEntity pt left join pt.permissions ptp where pt.isLastDeployedVersion = 1 and pt.processState = 1 ");
        StringBuilder condition = new StringBuilder();
        HashMap<String, Object> parameter = new HashMap<String, Object>(16);
        if (processTemplate != null) {
            if (StringUtils.isNotBlank((CharSequence)processTemplate.getProcessKey())) {
                condition.append(" AND pt.processKey = :processKey");
                parameter.put("processKey", processTemplate.getProcessKey());
            }
            if (StringUtils.isNotBlank((CharSequence)processTemplate.getProcessName())) {
                condition.append(" AND pt.processName = :processName");
                parameter.put("processName", processTemplate.getProcessName());
            }
            if (StringUtils.isNotBlank((CharSequence)processTemplate.getFormName())) {
                condition.append(" AND pt.formName = :formName");
                parameter.put("formName", processTemplate.getFormName());
            }
            if (StringUtils.isNotBlank((CharSequence)processTemplate.getProjectName())) {
                condition.append(" AND pt.projectName = :projectName");
                parameter.put("projectName", processTemplate.getProjectName());
            } else {
                condition.append(" AND (pt.projectName = '' OR pt.projectName IS NULL)");
            }
        }
        condition.append((CharSequence)this.getPermissionCondition(user, parameter));
        hql.append((CharSequence)condition).append(" order by pt.deployTime desc");
        countHql.append((CharSequence)condition);
        return this.queryByConditions(this.entityManager, hql.toString(), countHql.toString(), parameter, pageable, false, null);
    }

    private StringBuilder getPermissionCondition(UserVo user, Map<String, Object> parameter) {
        List allRoles = this.roleService.findAllByUserId(user.getId(), Integer.valueOf(0));
        List<String> roles = new ArrayList<String>();
        if (!CollectionUtils.isEmpty((Collection)allRoles)) {
            roles = allRoles.stream().map(RoleVo::getRoleCode).collect(Collectors.toList());
        } else {
            roles.add("-0101010101");
        }
        List<String> positions = new ArrayList<String>();
        if (!CollectionUtils.isEmpty((Collection)user.getPositions())) {
            positions = user.getPositions().stream().map(PositionVo::getCode).collect(Collectors.toList());
        } else {
            positions.add("-0101010101");
        }
        List<String> orgs = new ArrayList<String>();
        if (!CollectionUtils.isEmpty((Collection)user.getOrgs())) {
            orgs = user.getOrgs().stream().map(OrganizationVo::getCode).collect(Collectors.toList());
        } else {
            orgs.add("-0101010101");
        }
        List<String> groups = new ArrayList<String>();
        if (!CollectionUtils.isEmpty((Collection)user.getGroups())) {
            groups = user.getGroups().stream().map(UuidVo::getId).collect(Collectors.toList());
        } else {
            groups.add("-0101010101");
        }
        parameter.put("account", user.getAccount());
        parameter.put("roles", roles);
        parameter.put("positions", positions);
        parameter.put("orgs", orgs);
        parameter.put("groups", groups);
        StringBuilder condition = new StringBuilder(" and (ptp.id is null ");
        condition.append(" or ptp.type = 0 ");
        condition.append(" or (ptp.type = 1 and ptp.permissionValue = :account) ");
        condition.append(" or (ptp.type = 2 and ptp.permissionValue in :roles)");
        condition.append(" or (ptp.type = 3 and ptp.permissionValue in :groups) ");
        condition.append(" or (ptp.type = 4 and ptp.permissionValue in :positions) ");
        condition.append(" or (ptp.type = 5 and ptp.permissionValue in :orgs) ");
        condition.append(")");
        return condition;
    }
}

