/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.service.internal;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.bizunited.platform.titan.starter.entity.ProcessAssignmentEntity;
import com.bizunited.platform.titan.starter.repository.ProcessAssignmentRepository;
import com.bizunited.platform.titan.starter.service.ProcessAssignmentService;
import com.bizunited.platform.titan.starter.service.TitanToolkitService;
import com.bizunited.platform.user.common.service.position.PositionService;
import com.bizunited.platform.user.common.service.user.UserService;
import com.bizunited.platform.user.common.vo.PositionVo;
import com.bizunited.platform.user.common.vo.UserVo;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="ProcessAssignmentServiceImpl")
public class ProcessAssignmentServiceImpl
implements ProcessAssignmentService {
    @Autowired
    private ProcessAssignmentRepository processAssignmentRepository;
    @Autowired
    private RoleService roleService;
    @Autowired
    private UserService userService;
    @Autowired
    private PositionService positionService;
    @Autowired
    @Qualifier(value="TitanToolkitService")
    private TitanToolkitService titanToolkitService;

    private void saveValidation(Set<ProcessAssignmentEntity> assignments) {
        for (ProcessAssignmentEntity assignment : assignments) {
            this.saveValidation(assignment);
        }
    }

    private void saveValidation(ProcessAssignmentEntity assignment) {
        this.valid(assignment.getAssignment());
        Validate.notBlank((CharSequence)assignment.getAssignmentName(), (String)"\u5ba1\u6279\u4ee3\u7406\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public Set<ProcessAssignmentEntity> save(String resourceId, Set<ProcessAssignmentEntity> assignments) {
        if (assignments == null) {
            assignments = new HashSet<ProcessAssignmentEntity>();
        }
        Validate.notBlank((CharSequence)resourceId, (String)"\u6570\u636e\u6e90ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.saveValidation(assignments);
        Map assignmentsMap = assignments.stream().collect(Collectors.toMap(UuidEntity::getId, assignment -> assignment, (a, b) -> b, () -> new HashMap(8)));
        HashSet<ProcessAssignmentEntity> saveAssignments = new HashSet<ProcessAssignmentEntity>();
        Set<ProcessAssignmentEntity> oldAssignments = this.processAssignmentRepository.findByResourceId(resourceId);
        HashSet addEntities = new HashSet();
        HashSet deleteEntities = new HashSet();
        HashSet updateEntities = new HashSet();
        this.titanToolkitService.collectionDiscrepancy(assignments, oldAssignments, UuidEntity::getId, deleteEntities, updateEntities, addEntities);
        Date date = new Date();
        for (ProcessAssignmentEntity addEntity : addEntities) {
            addEntity.setCreateTime(date);
            addEntity.setModifyTime(date);
            addEntity.setResourceId(resourceId);
            addEntity.setSort(addEntity.getSort() == null ? 1 : addEntity.getSort());
            this.processAssignmentRepository.save((Object)addEntity);
            saveAssignments.add(addEntity);
        }
        for (ProcessAssignmentEntity updateEntity : updateEntities) {
            ProcessAssignmentEntity assignment2 = (ProcessAssignmentEntity)((Object)assignmentsMap.get(updateEntity.getId()));
            updateEntity.setModifyTime(new Date());
            updateEntity.setAssignment(assignment2.getAssignment());
            updateEntity.setAssignmentName(assignment2.getAssignmentName());
            updateEntity.setSort(assignment2.getSort() == null ? updateEntity.getSort() : assignment2.getSort());
            this.processAssignmentRepository.save((Object)updateEntity);
            saveAssignments.add(updateEntity);
        }
        this.processAssignmentRepository.deleteAll(deleteEntities);
        return saveAssignments;
    }

    @Override
    @Transactional
    public ProcessAssignmentEntity save(String resourceId, ProcessAssignmentEntity assignment) {
        if (assignment == null) {
            return null;
        }
        this.saveValidation(assignment);
        long count = this.processAssignmentRepository.countByResourceId(resourceId);
        Validate.isTrue((count <= 1L ? 1 : 0) != 0, (String)"\u8be5\u8d44\u6e90\u4e0b\u6709\u591a\u4e2a\u5ba1\u6279\u4eba\uff0c\u4e0d\u7b26\u5408\u4e00\u5bf9\u4e00\u5173\u7cfb\uff0c\u8bf7\u7528ProcessAssignmentService#save(java.lang.String, java.util.Set)\u65b9\u6cd5\u4fdd\u5b58", (Object[])new Object[0]);
        ProcessAssignmentEntity entity = this.processAssignmentRepository.findOneByResourceId(resourceId);
        Date date = new Date();
        if (entity == null) {
            entity = assignment;
            entity.setId(null);
            entity.setSort(entity.getSort() == null ? 1 : entity.getSort());
            entity.setResourceId(resourceId);
            entity.setCreateTime(date);
        } else {
            entity.setSort(assignment.getSort() == null ? entity.getSort() : assignment.getSort());
            entity.setAssignment(assignment.getAssignment());
            entity.setAssignmentName(assignment.getAssignmentName());
        }
        entity.setModifyTime(date);
        this.processAssignmentRepository.save((Object)entity);
        return entity;
    }

    @Override
    @Transactional
    public void deleteByResourceId(String resourceId) {
        this.processAssignmentRepository.deleteByResourceId(resourceId);
    }

    @Override
    public Set<ProcessAssignmentEntity> findByResourceId(String resourceId) {
        Sort sort = new Sort(Sort.Direction.ASC, new String[]{"sort"});
        return this.processAssignmentRepository.findByResourceId(resourceId, sort);
    }

    @Override
    public boolean equals(UserVo user, String assignment) {
        UserVo userVo;
        if (StringUtils.isBlank((CharSequence)assignment) || user == null) {
            return false;
        }
        if (assignment.startsWith("username:")) {
            return assignment.equals(StringUtils.join((Object[])new String[]{"username:", user.getAccount()}));
        }
        if (assignment.startsWith("position:")) {
            userVo = this.userService.findDetailsById(user.getId());
            Validate.notNull((Object)userVo, (String)"\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f\uff1a%s", (Object[])new Object[]{user.getAccount()});
            Set positions = userVo.getPositions();
            if (!CollectionUtils.isEmpty((Collection)positions)) {
                for (PositionVo position : positions) {
                    if (!assignment.equals(StringUtils.join((Object[])new String[]{"position:", position.getCode()}))) continue;
                    return true;
                }
            }
        }
        if (assignment.startsWith("role:")) {
            userVo = this.userService.findDetailsById(user.getId());
            Validate.notNull((Object)userVo, (String)"\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f\uff1a%s", (Object[])new Object[]{user.getAccount()});
            List roles = this.roleService.findAllByUserId(userVo.getId(), Integer.valueOf(0));
            if (CollectionUtils.isEmpty((Collection)roles)) {
                return false;
            }
            for (RoleVo role : roles) {
                if (!assignment.equals(StringUtils.join((Object[])new String[]{"role:", role.getRoleCode()}))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ProcessAssignmentEntity findAssignment(String assignment) {
        if (StringUtils.isBlank((CharSequence)assignment)) {
            return null;
        }
        ProcessAssignmentEntity assignmentEntity = new ProcessAssignmentEntity();
        if (assignment.startsWith("username:")) {
            String account = assignment.replaceFirst("username:", "");
            UserVo userVo = this.userService.findByAccount(account);
            Validate.notNull((Object)userVo, (String)"\u672a\u627e\u5230\u7528\u6237\uff1a%s", (Object[])new Object[]{account});
            assignmentEntity.setAssignment(assignment);
            assignmentEntity.setAssignmentName(userVo.getUserName());
        } else if (assignment.startsWith("position:")) {
            String positionCode = assignment.replaceFirst("position:", "");
            PositionVo position = this.positionService.findByCode(positionCode);
            Validate.notNull((Object)position, (String)"\u672a\u627e\u5230\u804c\u4f4d\u4fe1\u606f\uff1a%s", (Object[])new Object[]{positionCode});
            assignmentEntity.setAssignment(assignment);
            assignmentEntity.setAssignmentName(position.getName());
        } else if (assignment.startsWith("role:")) {
            String roleCode = assignment.replaceFirst("role:", "");
            RoleVo role = this.roleService.findByCode(roleCode);
            Validate.notNull((Object)role, (String)"\u672a\u627e\u5230\u89d2\u8272\u4fe1\u606f:%s", (Object[])new Object[]{roleCode});
            assignmentEntity.setAssignment(assignment);
            assignmentEntity.setAssignmentName(role.getRoleName());
        } else {
            throw new IllegalArgumentException(String.format("\u9519\u8bef\u7684\u4ee3\u7406\u4eba\uff1a%s,\u5fc5\u987b\u4ee5%s\u6216%s\u6216%s\u5f00\u5934", assignment, "username:", "position:", "role:"));
        }
        assignmentEntity.setSort(1);
        assignmentEntity.setCreateTime(new Date());
        assignmentEntity.setModifyTime(new Date());
        return assignmentEntity;
    }

    @Override
    @Transactional
    public ProcessAssignmentEntity save(String resourceId, String assignment) {
        ProcessAssignmentEntity assignmentEntity = this.findAssignment(assignment);
        return this.save(resourceId, assignmentEntity);
    }

    @Override
    public boolean contains(List<String> assignments, UserVo user) {
        if (!CollectionUtils.isEmpty(assignments)) {
            for (String assignment : assignments) {
                if (!this.equals(user, assignment)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void valid(List<String> assignments) {
        Validate.notEmpty(assignments, (String)"\u4ee3\u7406\u4eba\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (String assignment : assignments) {
            this.valid(assignment);
        }
    }

    @Override
    public void valid(String assignment) {
        Validate.notBlank((CharSequence)assignment, (String)"\u4ee3\u7406\u4eba\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((assignment.startsWith("username:") || assignment.startsWith("position:") || assignment.startsWith("role:") ? 1 : 0) != 0, (String)"\u4ee3\u7406\u4eba\u3010%s\u3011\u9519\u8bef\uff0c\u4ee3\u7406\u4eba\u5fc5\u987b\u4ee5%s\u6216%s\u6216%s\u5f00\u5934", (Object[])new Object[]{assignment, "username:", "position:", "role:"});
    }
}

