/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.service.internal;

import com.bizunited.platform.titan.starter.entity.ProcessGroupEntity;
import com.bizunited.platform.titan.starter.repository.ProcessGroupRepository;
import com.bizunited.platform.titan.starter.service.ProcessGroupService;
import com.bizunited.platform.titan.starter.service.TitanToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="ProcessGroupServiceImpl")
public class ProcessGroupServiceImpl
implements ProcessGroupService {
    @Autowired
    private ProcessGroupRepository processGroupRepository;
    @Autowired
    private TitanToolkitService titanToolkitService;

    @Override
    @Transactional
    public ProcessGroupEntity create(ProcessGroupEntity group) {
        this.createValidation(group);
        group.setCreateTime(new Date());
        return (ProcessGroupEntity)((Object)this.processGroupRepository.save((Object)group));
    }

    @Override
    @Transactional
    public ProcessGroupEntity update(ProcessGroupEntity group) {
        this.updateValidation(group);
        ProcessGroupEntity dbGroup = this.processGroupRepository.findById(group.getId()).orElse(null);
        Validate.notNull((Object)((Object)dbGroup), (String)"\u672a\u627e\u5230\u66f4\u65b0\u7684\u5bf9\u8c61", (Object[])new Object[0]);
        dbGroup.setName(group.getName());
        dbGroup.setSort(group.getSort());
        return (ProcessGroupEntity)((Object)this.processGroupRepository.save((Object)dbGroup));
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u4e3b\u952eID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ProcessGroupEntity group = this.processGroupRepository.findById(id).orElse(null);
        if (group == null) {
            return;
        }
        Validate.isTrue((boolean)CollectionUtils.isEmpty(group.getProcessTemplates()), (String)"\u8be5\u5206\u7ec4\u4e0b\u5b58\u5728\u6d41\u7a0b\u6a21\u7248\uff0c\u4e0d\u80fd\u5220\u9664", (Object[])new Object[0]);
        this.processGroupRepository.delete((Object)group);
    }

    @Override
    public List<ProcessGroupEntity> findAll() {
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"sort"});
        List groups = this.processGroupRepository.findAll(sort);
        if (CollectionUtils.isEmpty((Collection)groups)) {
            Lists.newArrayList();
        }
        Collection collection = this.titanToolkitService.copyCollectionByWhiteList(groups, ProcessGroupEntity.class, ProcessGroupEntity.class, HashSet.class, ArrayList.class, new String[]{"processTemplates"});
        return Lists.newArrayList((Iterable)collection);
    }

    @Override
    public ProcessGroupEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.processGroupRepository.findById(id).orElse(null);
    }

    private void updateValidation(ProcessGroupEntity group) {
        Validate.notNull((Object)((Object)group), (String)"\u5206\u7ec4\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)group.getId(), (String)"\u66f4\u65b0\u5206\u7ec4\u65f6\uff0c\u4e3b\u952eID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)group.getName(), (String)"\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)group.getSort(), (String)"\u6392\u5e8f\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        long count = this.processGroupRepository.countByNameAndExcludeId(group.getName(), group.getId());
        Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5206\u7ec4\u540d\u79f0\u91cd\u590d\uff01", (Object[])new Object[0]);
    }

    private void createValidation(ProcessGroupEntity group) {
        Validate.notNull((Object)((Object)group), (String)"\u5206\u7ec4\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((group.getId() == null ? 1 : 0) != 0, (String)"\u65b0\u589e\u5206\u7ec4\u4fe1\u606f\u65f6\uff0c\u4e3b\u952eID\u4e0d\u80fd\u6709\u503c", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)group.getName(), (String)"\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)group.getSort(), (String)"\u6392\u5e8f\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        long count = this.processGroupRepository.countByName(group.getName());
        Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5206\u7ec4\u540d\u79f0\u91cd\u590d\uff01", (Object[])new Object[0]);
    }
}

