/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.service.internal;

import com.bizunited.platform.titan.starter.common.enums.TaskOperateBtn;
import com.bizunited.platform.titan.starter.entity.ProcessAssignmentEntity;
import com.bizunited.platform.titan.starter.entity.ProcessInstanceEntity;
import com.bizunited.platform.titan.starter.entity.ProcessInstanceOperateRecordEntity;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateEntity;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateNodeEntity;
import com.bizunited.platform.titan.starter.repository.ProcessInstanceOperateRecordRepository;
import com.bizunited.platform.titan.starter.service.ProcessAssignmentService;
import com.bizunited.platform.titan.starter.service.ProcessInstanceMsgService;
import com.bizunited.platform.titan.starter.service.ProcessInstanceOperateRecordService;
import com.bizunited.platform.titan.starter.service.ProcessInstanceService;
import com.bizunited.platform.titan.starter.service.ProcessTaskService;
import com.bizunited.platform.titan.starter.service.ProcessTemplateNodeService;
import com.bizunited.platform.user.common.service.user.UserService;
import com.bizunited.platform.user.common.vo.UserVo;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.flowable.task.api.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="ProcessInstanceOperateRecordServiceImpl")
public class ProcessInstanceOperateRecordServiceImpl
implements ProcessInstanceOperateRecordService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessInstanceOperateRecordServiceImpl.class);
    @Autowired
    private ProcessInstanceOperateRecordRepository processInstanceOperateRecordRepository;
    @Autowired
    private UserService userService;
    @Autowired
    private ProcessTaskService processTaskService;
    @Autowired
    private ProcessInstanceService processInstanceService;
    @Autowired
    private ProcessAssignmentService processAssignmentService;
    @Autowired
    private ProcessInstanceMsgService processInstanceMsgService;
    @Autowired
    private ProcessTemplateNodeService processTemplateNodeService;

    @Override
    @Transactional
    public ProcessInstanceOperateRecordEntity create(Task task, ProcessInstanceEntity processInstance, UserVo user, TaskOperateBtn operateBtn, String content) {
        ProcessTemplateNodeEntity node = this.processTemplateNodeService.findByProcessTemplateIdAndProcessNodeId(processInstance.getProcessTemplate().getId(), task.getTaskDefinitionKey());
        Validate.notNull((Object)((Object)node), (String)"\u6570\u636e\u9519\u8bef\uff0c\u672a\u627e\u5230\u6d41\u7a0b\u8282\u70b9", (Object[])new Object[0]);
        ProcessInstanceOperateRecordEntity record = new ProcessInstanceOperateRecordEntity();
        record.setCreateTime(new Date());
        record.setContent(content);
        record.setOperation(operateBtn.getBtn());
        record.setOperationDesc(operateBtn.getDesc());
        record.setProcessInstance(processInstance);
        record.setOperator(user);
        record.setOperatorAccount(user.getAccount());
        record.setProcessTemplateNode(node);
        record.setTaskId(task.getId());
        this.processInstanceOperateRecordRepository.save((Object)record);
        if (StringUtils.isNotBlank((CharSequence)task.getAssignee())) {
            this.processInstanceMsgService.create(user, processInstance, record.getContent(), operateBtn);
        }
        return record;
    }

    @Override
    public List<ProcessInstanceOperateRecordEntity> findByProcessInstanceIdAndLatestSubmitTimeAndBtns(String processInstanceId, Date latestSubmitTime, String ... btns) {
        return this.processInstanceOperateRecordRepository.findByProcessInstanceIdAndLatestSubmitTimeAndBtns(processInstanceId, latestSubmitTime, btns);
    }

    @Override
    public Set<ProcessInstanceOperateRecordEntity> findDetailsByProcessInstanceId(String processInstanceId) {
        Set<ProcessInstanceOperateRecordEntity> records = this.processInstanceOperateRecordRepository.findDetailsByProcessInstanceId(processInstanceId);
        this.loadUser(records);
        return this.addCurrentTaskRecord(processInstanceId, records);
    }

    @Override
    public Set<ProcessInstanceOperateRecordEntity> findByProcessInstanceIdAndProcessNodeId(String processInstanceId, String processNodeId) {
        Set<ProcessInstanceOperateRecordEntity> records = this.processInstanceOperateRecordRepository.findByProcessInstanceIdAndProcessNodeId(processInstanceId, processNodeId);
        this.loadUser(records);
        return records;
    }

    @Override
    public Long countByTaskIdAndUserAccountAndBtns(String taskId, String userAccount, String ... btns) {
        return this.processInstanceOperateRecordRepository.countByTaskIdAndUserAccountAndBtns(taskId, userAccount, btns);
    }

    @Override
    public Set<ProcessInstanceOperateRecordEntity> findByTaskIdAndBtns(String taskId, String ... btns) {
        Set<ProcessInstanceOperateRecordEntity> records = this.processInstanceOperateRecordRepository.findByTaskIdAndBtns(taskId, btns);
        this.loadUser(records);
        return records;
    }

    private void loadUser(Set<ProcessInstanceOperateRecordEntity> records) {
        if (CollectionUtils.isEmpty(records)) {
            return;
        }
        for (ProcessInstanceOperateRecordEntity record : records) {
            UserVo user = this.userService.findByAccount(record.getOperatorAccount());
            record.setOperator(user);
        }
    }

    private Set<ProcessInstanceOperateRecordEntity> addCurrentTaskRecord(String processInstanceId, Set<ProcessInstanceOperateRecordEntity> records) {
        List<Task> tasks;
        if (records == null) {
            records = new HashSet<ProcessInstanceOperateRecordEntity>();
        }
        if (!CollectionUtils.isEmpty(tasks = this.processTaskService.findCurrentTasks(processInstanceId))) {
            ProcessInstanceEntity processInstance = this.processInstanceService.findByProcessInstanceId(processInstanceId);
            if (processInstance == null) {
                return records;
            }
            ProcessTemplateEntity processTemplate = processInstance.getProcessTemplate();
            if (processTemplate == null) {
                return records;
            }
            for (Task task : tasks) {
                ProcessInstanceOperateRecordEntity record = new ProcessInstanceOperateRecordEntity();
                ProcessTemplateNodeEntity node = this.processTemplateNodeService.findByProcessTemplateIdAndProcessNodeId(processTemplate.getId(), task.getTaskDefinitionKey());
                if (StringUtils.isNotBlank((CharSequence)task.getAssignee())) {
                    ProcessAssignmentEntity processAssignment = null;
                    try {
                        processAssignment = this.processAssignmentService.findAssignment(task.getAssignee());
                    }
                    catch (Exception e) {
                        LOGGER.warn(e.getMessage(), (Throwable)e);
                    }
                    if (processAssignment != null) {
                        UserVo user = new UserVo();
                        user.setUserName(processAssignment.getAssignmentName());
                        record.setOperator(user);
                    }
                }
                record.setTaskId(task.getId());
                record.setProcessTemplateNode(node);
                record.setState(0);
                record.setCreateTime(new Date());
                records.add(record);
            }
        }
        return records;
    }
}

