/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.service.internal;

import com.bizunited.platform.rbac.server.util.SecurityUtils;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateNodePermissionEntity;
import com.bizunited.platform.titan.starter.repository.ProcessTemplateNodePermissionRepository;
import com.bizunited.platform.titan.starter.service.ProcessTemplateNodePermissionService;
import com.bizunited.platform.user.common.service.user.UserService;
import com.bizunited.platform.user.common.vo.UserVo;
import java.security.Principal;
import java.util.Date;
import java.util.Optional;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service(value="ProcessTemplateNodePermissionServiceImpl")
public class ProcessTemplateNodePermissionServiceImpl
implements ProcessTemplateNodePermissionService {
    @Autowired
    private ProcessTemplateNodePermissionRepository processTemplateNodePermissionRepository;
    @Autowired
    private UserService userService;

    private void createValidation(ProcessTemplateNodePermissionEntity nodePermission) {
        Validate.notNull((Object)((Object)nodePermission), (String)"\u4fdd\u5b58\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((nodePermission.getId() == null ? 1 : 0) != 0, (String)"\u521b\u5efa\u5bf9\u8c61\u4e0d\u80fd\u6709ID", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)nodePermission.getOperateCode(), (String)"\u64cd\u4f5c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)nodePermission.getOperateName(), (String)"\u64cd\u4f5c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)nodePermission.getOperations(), (String)"\u64cd\u4f5c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Long operateCodeCount = this.processTemplateNodePermissionRepository.countByOperateCode(nodePermission.getOperateCode());
        Validate.isTrue((operateCodeCount == null || operateCodeCount < 1L ? 1 : 0) != 0, (String)"\u5df2\u5b58\u5728\u64cd\u4f5c\u7f16\u7801:%s", (Object[])new Object[]{nodePermission.getOperateCode()});
        Long operateNameCount = this.processTemplateNodePermissionRepository.countByOperateName(nodePermission.getOperateName());
        Validate.isTrue((operateNameCount == null || operateNameCount < 1L ? 1 : 0) != 0, (String)"\u5df2\u5b58\u5728\u64cd\u4f5c\u540d\u79f0:%s", (Object[])new Object[]{nodePermission.getOperateName()});
    }

    @Override
    @Transactional
    public ProcessTemplateNodePermissionEntity create(ProcessTemplateNodePermissionEntity nodePermission, Principal principal) {
        this.createValidation(nodePermission);
        UserVo user = SecurityUtils.getCurrentUser();
        nodePermission.setCreateTime(new Date());
        nodePermission.setCreateUser(user);
        nodePermission.setCreateAccount(user.getAccount());
        nodePermission.setModifyTime(new Date());
        nodePermission.setModifyUser(user);
        nodePermission.setModifyAccount(user.getAccount());
        this.processTemplateNodePermissionRepository.save((Object)nodePermission);
        return nodePermission;
    }

    private void updateValidation(ProcessTemplateNodePermissionEntity nodePermission) {
        Validate.notNull((Object)((Object)nodePermission), (String)"\u66f4\u65b0\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)nodePermission.getId()), (String)"\u66f4\u65b0\u5bf9\u8c61\u5fc5\u987b\u6709ID", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)nodePermission.getOperateCode(), (String)"\u64cd\u4f5c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)nodePermission.getOperateName(), (String)"\u64cd\u4f5c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)nodePermission.getOperations(), (String)"\u64cd\u4f5c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Long operateCodeCount = this.processTemplateNodePermissionRepository.countByOperateCodeWithoutId(nodePermission.getOperateCode(), nodePermission.getId());
        Validate.isTrue((operateCodeCount == null || operateCodeCount < 1L ? 1 : 0) != 0, (String)"\u5df2\u5b58\u5728\u64cd\u4f5c\u7f16\u7801:%s", (Object[])new Object[]{nodePermission.getOperateCode()});
        Long operateNameCount = this.processTemplateNodePermissionRepository.countByOperateNameWithoutId(nodePermission.getOperateName(), nodePermission.getId());
        Validate.isTrue((operateNameCount == null || operateNameCount < 1L ? 1 : 0) != 0, (String)"\u5df2\u5b58\u5728\u64cd\u4f5c\u540d\u79f0:%s", (Object[])new Object[]{nodePermission.getOperateName()});
    }

    @Override
    @Transactional
    public ProcessTemplateNodePermissionEntity update(ProcessTemplateNodePermissionEntity nodePermission, Principal principal) {
        this.updateValidation(nodePermission);
        UserVo user = SecurityUtils.getCurrentUser();
        Optional op = this.processTemplateNodePermissionRepository.findById(nodePermission.getId());
        ProcessTemplateNodePermissionEntity processTemplateNodePermission = op.orElse(null);
        Validate.notNull((Object)((Object)processTemplateNodePermission), (String)"\u66f4\u65b0\u5bf9\u8c61\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        processTemplateNodePermission.setModifyUser(user);
        processTemplateNodePermission.setModifyAccount(user.getAccount());
        processTemplateNodePermission.setModifyTime(new Date());
        processTemplateNodePermission.setOperateCode(nodePermission.getOperateCode());
        processTemplateNodePermission.setOperateName(nodePermission.getOperateName());
        processTemplateNodePermission.setOperations(nodePermission.getOperations());
        this.processTemplateNodePermissionRepository.save((Object)processTemplateNodePermission);
        return processTemplateNodePermission;
    }

    @Override
    public Page<ProcessTemplateNodePermissionEntity> findByConditions(ProcessTemplateNodePermissionEntity nodePermission, Pageable pageable) {
        return this.processTemplateNodePermissionRepository.findByConditions(nodePermission, pageable);
    }

    @Override
    public ProcessTemplateNodePermissionEntity findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ProcessTemplateNodePermissionEntity permission = this.processTemplateNodePermissionRepository.findDetailById(id);
        this.loadUser(permission);
        return permission;
    }

    @Override
    public void loadUser(ProcessTemplateNodePermissionEntity permission) {
        if (permission == null) {
            return;
        }
        UserVo creator = this.userService.findByAccount(permission.getCreateAccount());
        UserVo modifyUser = this.userService.findByAccount(permission.getModifyAccount());
        permission.setCreateUser(creator);
        permission.setModifyUser(modifyUser);
    }
}

