/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.service.internal;

import com.bizunited.platform.titan.starter.entity.ProcessVariableEntity;
import com.bizunited.platform.titan.starter.repository.ProcessVariableRepository;
import com.bizunited.platform.titan.starter.service.ProcessVariableService;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="ProcessVariableServiceImpl")
public class ProcessVariableServiceImpl
implements ProcessVariableService {
    @Autowired
    private ProcessVariableRepository processVariableRepository;

    private void saveValidation(Set<ProcessVariableEntity> variables) {
        HashSet<String> names = new HashSet<String>();
        for (ProcessVariableEntity variable : variables) {
            Validate.notNull((Object)variable.getName(), (String)"\u53d8\u91cf\u540d\u4e0d\u80fd\u4e3anull", (Object[])new Object[0]);
            Validate.notNull((Object)variable.getValue(), (String)"\u53d8\u91cf\u503c\u4e0d\u80fd\u4e3anull", (Object[])new Object[0]);
            Validate.isTrue((!names.contains(variable.getName()) ? 1 : 0) != 0, (String)"\u53d8\u91cf\u540d[%s]\u91cd\u590d,\u8bf7\u68c0\u67e5", (Object[])new Object[]{variable.getName()});
            names.add(variable.getName());
        }
    }

    @Override
    @Transactional
    public Set<ProcessVariableEntity> save(String sourceId, Set<ProcessVariableEntity> variables) {
        ProcessVariableEntity oldVariable;
        Validate.notBlank((CharSequence)sourceId, (String)"\u6570\u636e\u6e90ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (variables == null) {
            variables = new HashSet<ProcessVariableEntity>();
        }
        this.saveValidation(variables);
        HashSet<ProcessVariableEntity> resultSet = new HashSet<ProcessVariableEntity>();
        Set<ProcessVariableEntity> oldVariables = this.processVariableRepository.findBySourceId(sourceId);
        HashMap oldVariablesMap = new HashMap(16);
        HashMap variablesMap = new HashMap(16);
        HashSet oldVariableNames = new HashSet();
        HashSet variableNames = new HashSet();
        oldVariables.forEach(v -> {
            oldVariablesMap.put(v.getName(), v);
            oldVariableNames.add(v.getName());
        });
        variables.forEach(v -> {
            variablesMap.put(v.getName(), v);
            variableNames.add(v.getName());
        });
        Sets.SetView newVariablesSet = Sets.difference(variableNames, oldVariableNames);
        Sets.SetView deleteVariablesSet = Sets.difference(oldVariableNames, variableNames);
        Sets.SetView updateVariablesSet = Sets.intersection(variableNames, oldVariableNames);
        for (String name : newVariablesSet) {
            ProcessVariableEntity variable = (ProcessVariableEntity)((Object)variablesMap.get(name));
            variable.setId(null);
            variable.setSourceId(sourceId);
            variable.setCreateTime(new Date());
            variable.setModifyTime(new Date());
            this.processVariableRepository.save((Object)variable);
            resultSet.add(variable);
        }
        for (String name : updateVariablesSet) {
            oldVariable = (ProcessVariableEntity)((Object)oldVariablesMap.get(name));
            ProcessVariableEntity variable = (ProcessVariableEntity)((Object)variablesMap.get(name));
            if (variable.getValue().equals(oldVariable.getValue())) {
                resultSet.add(oldVariable);
                continue;
            }
            oldVariable.setModifyTime(new Date());
            oldVariable.setValue(variable.getValue());
            this.processVariableRepository.save((Object)oldVariable);
            resultSet.add(oldVariable);
        }
        for (String name : deleteVariablesSet) {
            oldVariable = (ProcessVariableEntity)((Object)oldVariablesMap.get(name));
            this.processVariableRepository.delete((Object)oldVariable);
        }
        return resultSet;
    }

    @Override
    @Transactional
    public void deleteBySourceId(String sourceId) {
        this.processVariableRepository.deleteBySourceId(sourceId);
    }

    @Override
    public Set<ProcessVariableEntity> findBySourceId(String sourceId) {
        return this.processVariableRepository.findBySourceId(sourceId);
    }

    @Override
    public Map<String, Object> getVariablesByTargetId(String targetId) {
        Map<String, Object> variables = new HashMap<String, Object>(16);
        Set<ProcessVariableEntity> variableEntities = this.findBySourceId(targetId);
        if (!CollectionUtils.isEmpty(variableEntities)) {
            variables = variableEntities.stream().collect(Collectors.toMap(ProcessVariableEntity::getName, ProcessVariableEntity::getValue, (a, b) -> b, () -> new HashMap(16)));
        }
        return variables;
    }
}

