/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.titan.starter.entity.ProcessInstanceMsgEntity;
import com.bizunited.platform.titan.starter.service.ProcessInstanceMsgService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.security.Principal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"v1/titan/instance/msgs"})
@Api(tags={"\u6d41\u7a0b\u5b9e\u4f8b\u7559\u8a00\u8bb0\u5f55\u529f\u80fd\u4e1a\u52a1\u6a21\u578b\u7684MVC Controller\u5c42\u5b9e\u73b0"})
public class ProcessInstanceMsgController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessInstanceMsgController.class);
    @Autowired
    private ProcessInstanceMsgService processInstanceMsgService;

    @GetMapping(value={"findByProcessInstanceId"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8bID\u67e5\u8be2\u7559\u8a00\u8bb0\u5f55", notes="\u6839\u636e\u7559\u8a00\u65f6\u95f4\u987a\u5e8f\u6392\u5e8f\uff0c\u4ee5\u6811\u5f62\u7ed3\u6784\u8fd4\u56de")
    public ResponseModel findByProcessInstanceId(@RequestParam(value="processInstanceId") @ApiParam(value="\u6d41\u7a0b\u5b9e\u4f8bID", required=true) String processInstanceId) {
        try {
            List<ProcessInstanceMsgEntity> msgs = this.processInstanceMsgService.findByProcessInstanceId(processInstanceId);
            return this.buildHttpResult(msgs);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PostMapping(value={""})
    @ApiOperation(value="\u4fdd\u5b58\u7559\u8a00\u8bb0\u5f55")
    public ResponseModel create(@RequestBody ProcessInstanceMsgEntity msg) {
        try {
            Principal principal = this.getPrincipal();
            ProcessInstanceMsgEntity msgEntity = this.processInstanceMsgService.create(msg, principal);
            return this.buildHttpResultW((Object)msgEntity, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

