/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateEntity;
import com.bizunited.platform.titan.starter.service.ProcessTemplateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.security.Principal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6d41\u7a0b\u6a21\u7248\u529f\u80fd\u4e1a\u52a1\u6a21\u578b\u7684MVC Controller\u5c42\u5b9e\u73b0"})
@RestController
@RequestMapping(value={"v1/titan/templates"})
public class ProcessTemplateController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessTemplateController.class);
    private static final String[] PROCESS_TEMPLATE_PROPERTIES_W = new String[]{"createUser", "modifyUser", "processTemplateNodes", "processTemplateNodes.processTemplateNodePermission", "processTemplateNodes.assignment", "processTemplateNodes.assignment.processListener", "processTemplateNodes.assignment.script", "processTemplateNodes.assignment.variables", "permissions", "processTemplateListeners", "processTemplateListeners.processListener", "processTemplateListeners.script", "processTemplateListeners.variables", "onSubmitScript", "processTemplateNodes.processTemplateNodeMulti", "processTemplateNodes.processTemplateNodeMulti.assignments", "variables"};
    @Autowired
    private ProcessTemplateService processTemplateService;

    @PostMapping(value={""})
    @ApiOperation(value="\u521b\u5efa\u6d41\u7a0b\u6a21\u7248", notes="\u521b\u5efa\u6d41\u7a0b\u6a21\u7248\uff0c\u65b0\u7684\u6d41\u7a0bkey\u5fc5\u987b\u5728\u4e4b\u524d\u7684\u5e93\u4e2d\u662f\u4e0d\u5b58\u5728\u7684")
    public ResponseModel create(@RequestBody ProcessTemplateEntity processTemplateEntity) {
        try {
            Principal principal = this.getPrincipal();
            ProcessTemplateEntity processTemplate = this.processTemplateService.create(processTemplateEntity, principal, 1);
            return this.buildHttpResultW((Object)processTemplate, PROCESS_TEMPLATE_PROPERTIES_W);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PatchMapping(value={""})
    @ApiOperation(value="\u66f4\u65b0\u6d41\u7a0b\u6a21\u7248")
    public ResponseModel update(@RequestBody ProcessTemplateEntity processTemplateEntity) {
        try {
            Principal principal = this.getPrincipal();
            ProcessTemplateEntity processTemplate = this.processTemplateService.update(processTemplateEntity, principal);
            return this.buildHttpResultW((Object)processTemplate, PROCESS_TEMPLATE_PROPERTIES_W);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PatchMapping(value={"updateGroupByProcessKey"})
    @ApiOperation(value="\u6839\u636e\u6a21\u7248\u7f16\u7801\u66f4\u65b0\u6a21\u7248\u7684\u5206\u7ec4\u4fe1\u606f")
    public ResponseModel updateGroupByProcessKey(@RequestParam @ApiParam(value="\u6a21\u7248\u7f16\u7801") String processKey, @RequestParam @ApiParam(value="\u5206\u7ec4ID") String groupId) {
        try {
            this.processTemplateService.updateGroupByProcessKey(processKey, groupId);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByConditions"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6d41\u7a0b\u6a21\u7248", notes="\u9875\u6570\u53c2\u6570\u4e3apage\uff0c\u7b2c\u4e00\u9875\u4ece0\u5f00\u59cb\uff0c\u5206\u9875\u5927\u5c0f\u53c2\u6570\u4e3asize\uff08size\u9ed8\u8ba4\u4e3a50\uff09")
    public ResponseModel findByConditions(@PageableDefault(value=50) Pageable pageable, @ApiParam(value="\u6d41\u7a0bkey") @RequestParam(value="processKey", required=false) String processKey, @ApiParam(value="\u6d41\u7a0b\u540d\u79f0") @RequestParam(value="processName", required=false) String processName, @ApiParam(value="\u8868\u5355\u540d\u79f0") @RequestParam(value="formName", required=false) String formName, @ApiParam(value="\u662f\u5426\u662f\u6700\u540e\u7248\u672c") @RequestParam(value="isLastVersion", required=false) Boolean isLastVersion, @ApiParam(value="\u8868\u5355\u7c7b\u578b") @RequestParam(value="formType", required=false) Integer formType, @ApiParam(value="\u6a21\u7248\u72b6\u6001") @RequestParam(value="processState", required=false) Integer processState) {
        try {
            ProcessTemplateEntity processTemplate = new ProcessTemplateEntity();
            processTemplate.setProcessKey(processKey);
            processTemplate.setProcessName(processName);
            processTemplate.setFormName(formName);
            processTemplate.setLastVersion(isLastVersion);
            processTemplate.setFormType(formType);
            processTemplate.setProcessState(processState);
            Page<ProcessTemplateEntity> page = this.processTemplateService.findByConditions(pageable, processTemplate);
            return this.buildHttpResultW((Iterable)page, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByProcessKey"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0bkey\u67e5\u8be2\u6d41\u7a0b\u6a21\u7248", notes="\u6839\u636e\u7248\u672c\u53f7\u5012\u5e8f\u6392\u5e8f")
    public ResponseModel findByProcessKey(@ApiParam(value="\u6d41\u7a0bkey") @RequestParam(value="processKey", required=false) String processKey) {
        try {
            List<ProcessTemplateEntity> processTemplates = this.processTemplateService.findByProcessKey(processKey);
            return this.buildHttpResultW(processTemplates, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findDetailsById"})
    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u6d41\u7a0b\u6a21\u7248\u660e\u7ec6", notes="\u5305\u542b\u6a21\u7248\u4e0b\u7684\u6240\u6709\u5173\u8054\u4fe1\u606f")
    public ResponseModel findDetailsById(@ApiParam(value="\u6d41\u7a0b\u6a21\u7248ID", required=true) @RequestParam(value="id") String id) {
        try {
            ProcessTemplateEntity processTemplate = this.processTemplateService.findDetailsById(id);
            return this.buildHttpResultW((Object)processTemplate, PROCESS_TEMPLATE_PROPERTIES_W);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PutMapping(value={"upgradeVersion"})
    @ApiOperation(value="\u5347\u7ea7\u6d41\u7a0b\u7248\u672c", notes="\u4ee5\u6700\u65b0\u6a21\u7248\u4e3a\u672c\u5347\u7ea7\u7248\u672c\uff0c\u5347\u7ea7\u7248\u672c\u8981\u6c42\u5f53\u524d\u65e0\u6b63\u5728\u7f16\u8f91\u7684\u6a21\u7248")
    public ResponseModel upgradeVersion(@RequestBody ProcessTemplateEntity processTemplate) {
        try {
            Principal principal = this.getPrincipal();
            ProcessTemplateEntity processTemplateEntity = this.processTemplateService.upgradeVersion(processTemplate, principal);
            return this.buildHttpResultW((Object)processTemplateEntity, PROCESS_TEMPLATE_PROPERTIES_W);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PostMapping(value={"deploy"})
    @ApiOperation(value="\u53d1\u5e03\u6d41\u7a0b\u5230\u6d41\u7a0b\u5f15\u64ce", notes="\u53d1\u5e03\u6d41\u7a0b\u5230\u6d41\u7a0b\u5f15\u64ce\uff0c\u53d1\u5e03\u540e\u8be5\u6d41\u7a0b\u6a21\u7248\u5c06\u4e0d\u53ef\u5728\u8fdb\u884c\u7f16\u8f91")
    public ResponseModel deploy(@ApiParam(value="\u6d41\u7a0b\u6a21\u7248ID", required=true) @RequestParam(value="id") String id) {
        try {
            Principal principal = this.getPrincipal();
            this.processTemplateService.deploy(id, principal);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @DeleteMapping(value={"deleteById"})
    @ApiOperation(value="\u6839\u636eID\u5220\u9664\u6d41\u7a0b\u6a21\u7248", notes="\u6839\u636eID\u5220\u9664\u6d41\u7a0b\u6a21\u7248\uff0c\u53ea\u80fd\u5220\u9664\u672a\u53d1\u5e03\u7684\u6d41\u7a0b\u6a21\u7248")
    public ResponseModel deleteById(@ApiParam(value="\u6d41\u7a0b\u6a21\u7248ID", required=true) @RequestParam(value="id") String id) {
        try {
            Principal principal = this.getPrincipal();
            this.processTemplateService.deleteById(id, principal);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findStartableByConditions"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u53ef\u53d1\u8d77\u7684\u6d41\u7a0b\u6a21\u7248", notes="\u9875\u6570\u53c2\u6570\u4e3apage\uff0c\u7b2c\u4e00\u9875\u4ece0\u5f00\u59cb\uff0c\u5206\u9875\u5927\u5c0f\u53c2\u6570\u4e3asize\uff08size\u9ed8\u8ba4\u4e3a50\uff09")
    public ResponseModel findStartableByConditions(@PageableDefault(value=50) Pageable pageable, @ApiParam(value="\u6d41\u7a0bkey") @RequestParam(value="processKey", required=false) String processKey, @ApiParam(value="\u6d41\u7a0b\u540d\u79f0") @RequestParam(value="processName", required=false) String processName, @ApiParam(value="\u8868\u5355\u540d\u79f0") @RequestParam(value="formName", required=false) String formName) {
        try {
            Principal principal = this.getPrincipal();
            ProcessTemplateEntity processTemplate = new ProcessTemplateEntity();
            processTemplate.setProcessKey(processKey);
            processTemplate.setProcessName(processName);
            processTemplate.setFormName(formName);
            Page<ProcessTemplateEntity> page = this.processTemplateService.findStartableByConditions(pageable, processTemplate, principal);
            return this.buildHttpResultW((Iterable)page, new String[]{"processGroup"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findProcessXmlById"})
    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0bxml")
    public ResponseModel findProcessXmlById(String id) {
        try {
            String processXml = this.processTemplateService.findProcessXmlById(id);
            return this.buildHttpResultW(processXml, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

