/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.listener.proxy;

import com.bizunited.platform.core.service.ScriptService;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.core.service.invoke.InvokeProxy;
import com.bizunited.platform.core.service.invoke.InvokeProxyBuilder;
import com.bizunited.platform.core.service.invoke.InvokeRequestHandle;
import com.bizunited.platform.core.service.invoke.InvokeResponseHandle;
import com.bizunited.platform.core.service.invoke.handle.request.PrincipalHandle;
import com.bizunited.platform.core.service.invoke.handle.request.TransactionalHandle;
import com.bizunited.platform.titan.starter.common.enums.AssignmentType;
import com.bizunited.platform.titan.starter.common.enums.ProcessListenerExecuteMode;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateListenerEntity;
import com.bizunited.platform.titan.starter.entity.ProcessTemplateNodeAssignmentEntity;
import com.bizunited.platform.titan.starter.service.ProcessTemplateListenerService;
import com.bizunited.platform.titan.starter.service.ProcessTemplateNodeAssignmentService;
import com.bizunited.platform.titan.starter.service.invoke.handle.request.AbstractListenerHandle;
import com.bizunited.platform.titan.starter.service.invoke.handle.request.TaskListenerNotifyHandle;
import com.bizunited.platform.titan.starter.service.invoke.handle.request.TaskScriptListenerHandle;
import com.bizunited.platform.titan.starter.service.invoke.handle.response.ListenerResponseHandle;
import java.util.ArrayList;
import java.util.List;
import org.flowable.engine.delegate.TaskListener;
import org.flowable.task.service.delegate.DelegateTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="TaskProxyListener")
public class TaskProxyListener
implements TaskListener {
    private static final long serialVersionUID = -7532614718969156854L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskProxyListener.class);
    @Autowired
    private ScriptService scriptService;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private PrincipalHandle principalHandle;
    @Autowired
    private TransactionalHandle transactionalHandle;
    @Autowired
    private ListenerResponseHandle listenerResponseHandle;
    @Autowired
    private ProcessTemplateListenerService processTemplateListenerService;
    @Autowired
    private ProcessTemplateNodeAssignmentService processTemplateNodeAssignmentService;

    public void notify(DelegateTask delegateTask) {
        List<ProcessTemplateListenerEntity> listeners;
        ProcessTemplateNodeAssignmentEntity nodeAssignment;
        LOGGER.info("\u8282\u70b9\uff1a{}", (Object)delegateTask.getTaskDefinitionKey());
        LOGGER.info("EventName: {}", (Object)delegateTask.getEventName());
        ArrayList<Object> handles = new ArrayList<Object>();
        if (delegateTask.getEventName().equals("create") && (nodeAssignment = this.processTemplateNodeAssignmentService.findDetailsByProcessDefinitionIdAndProcessNodeId(delegateTask.getProcessDefinitionId(), delegateTask.getTaskDefinitionKey())) != null && nodeAssignment.getType().equals(AssignmentType.LISTENER.getType())) {
            Object handle;
            if (nodeAssignment.getProcessListener().getExecuteMode().equals(ProcessListenerExecuteMode.ORIGIN.getMode())) {
                handle = new TaskListenerNotifyHandle(delegateTask, nodeAssignment.getProcessListener(), nodeAssignment.getVariables());
                handles.add(handle);
            } else if (nodeAssignment.getProcessListener().getExecuteMode().equals(ProcessListenerExecuteMode.SCRIPT.getMode())) {
                handle = new TaskScriptListenerHandle(nodeAssignment.getScript(), delegateTask, this.scriptService, nodeAssignment.getVariables());
                handles.add(handle);
            }
        }
        if (!CollectionUtils.isEmpty(listeners = this.processTemplateListenerService.findDetailsByProcessDefinitionIdAndTargetIdAndEvent(delegateTask.getProcessDefinitionId(), delegateTask.getTaskDefinitionKey(), delegateTask.getEventName()))) {
            for (ProcessTemplateListenerEntity listener : listeners) {
                AbstractListenerHandle handle;
                if (listener.getProcessListener().getExecuteMode().equals(ProcessListenerExecuteMode.ORIGIN.getMode())) {
                    handle = new TaskListenerNotifyHandle(delegateTask, listener.getProcessListener(), listener.getVariables());
                    handles.add(handle);
                    continue;
                }
                if (!listener.getProcessListener().getExecuteMode().equals(ProcessListenerExecuteMode.SCRIPT.getMode())) continue;
                handle = new TaskScriptListenerHandle(listener.getScript(), delegateTask, this.scriptService, listener.getVariables());
                handles.add(handle);
            }
        }
        if (!CollectionUtils.isEmpty(handles)) {
            InvokeProxyBuilder build = new InvokeProxyBuilder();
            build.addClassLoader(this.applicationContext.getClassLoader());
            build.addInvokeRequestFilter(new InvokeRequestHandle[]{this.principalHandle, this.transactionalHandle});
            build.addInvokeRequestFilter(handles.toArray(new InvokeRequestHandle[handles.size()]));
            build.addInvokeResponseFilter(new InvokeResponseHandle[]{this.listenerResponseHandle});
            InvokeProxy invokeProxy = build.build();
            try {
                invokeProxy.invoke(new InvokeParams());
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
    }
}

