/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.titan.starter.service.internal;

import com.bizunited.platform.titan.starter.entity.ProcessTemplateEntity;
import com.bizunited.platform.titan.starter.entity.ProcessTemplatePermissionEntity;
import com.bizunited.platform.titan.starter.repository.ProcessTemplatePermissionRepository;
import com.bizunited.platform.titan.starter.service.ProcessTemplatePermissionService;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="ProcessTemplatePermissionServiceImpl")
public class ProcessTemplatePermissionServiceImpl
implements ProcessTemplatePermissionService {
    @Autowired
    private ProcessTemplatePermissionRepository processTemplatePermissionRepository;

    private void createValidation(Set<ProcessTemplatePermissionEntity> permissions) {
        for (ProcessTemplatePermissionEntity permission : permissions) {
            Validate.isTrue((permission.getId() == null ? 1 : 0) != 0, (String)"\u521b\u5efa\u6d41\u7a0b\u6a21\u7248\u6743\u9650\u4e0d\u80fd\u6709ID", (Object[])new Object[0]);
            Validate.notNull((Object)permission.getType(), (String)"\u6743\u9650\u7c7b\u578b\u4e0d\u80fd\u7a7a", (Object[])new Object[0]);
            if (permission.getType().equals(0)) continue;
            Validate.notBlank((CharSequence)permission.getPermissionValue(), (String)"\u6743\u9650\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }

    @Override
    @Transactional
    public void create(ProcessTemplateEntity processTemplateEntity, Set<ProcessTemplatePermissionEntity> permissions) {
        if (CollectionUtils.isEmpty(permissions)) {
            processTemplateEntity.setPermissions(new HashSet<ProcessTemplatePermissionEntity>());
            return;
        }
        this.createValidation(permissions);
        for (ProcessTemplatePermissionEntity permission : permissions) {
            permission.setCreateTime(new Date());
            permission.setModifyTime(new Date());
            permission.setProcessTemplate(processTemplateEntity);
        }
        this.processTemplatePermissionRepository.saveAll(permissions);
        processTemplateEntity.setPermissions(permissions);
    }

    private void updateValidation(Set<ProcessTemplatePermissionEntity> permissions) {
        for (ProcessTemplatePermissionEntity permission : permissions) {
            Validate.notNull((Object)permission.getType(), (String)"\u6743\u9650\u7c7b\u578b\u4e0d\u80fd\u7a7a", (Object[])new Object[0]);
            if (permission.getType().equals(0)) continue;
            Validate.notBlank((CharSequence)permission.getPermissionValue(), (String)"\u6743\u9650\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }

    @Override
    @Transactional
    public void update(ProcessTemplateEntity processTemplateEntity, Set<ProcessTemplatePermissionEntity> permissions) {
        if (permissions == null) {
            permissions = new HashSet<ProcessTemplatePermissionEntity>();
        }
        this.updateValidation(permissions);
        Set<ProcessTemplatePermissionEntity> oldPermissions = this.processTemplatePermissionRepository.findByProcessTemplateId(processTemplateEntity.getId());
        HashMap<String, ProcessTemplatePermissionEntity> oldPermissionsMap = new HashMap<String, ProcessTemplatePermissionEntity>(16);
        if (!CollectionUtils.isEmpty(oldPermissions)) {
            for (ProcessTemplatePermissionEntity oldPermission : oldPermissions) {
                oldPermissionsMap.put(oldPermission.getId(), oldPermission);
            }
        }
        HashSet<ProcessTemplatePermissionEntity> createPermissions = new HashSet<ProcessTemplatePermissionEntity>();
        HashSet<ProcessTemplatePermissionEntity> updatePermissions = new HashSet<ProcessTemplatePermissionEntity>();
        for (ProcessTemplatePermissionEntity permission : permissions) {
            if (permission.getId() == null) {
                createPermissions.add(permission);
                continue;
            }
            ProcessTemplatePermissionEntity oldPermission = (ProcessTemplatePermissionEntity)((Object)oldPermissionsMap.get(permission.getId()));
            Validate.notNull((Object)((Object)oldPermission), (String)"\u66f4\u65b0\u5bf9\u8c61\u4e0d\u5b58\u5728\uff0cID:%s", (Object[])new Object[]{permission.getId()});
            oldPermission.setType(permission.getType());
            oldPermission.setPermissionValue(permission.getPermissionValue());
            oldPermission.setModifyTime(new Date());
            updatePermissions.add(oldPermission);
            oldPermissionsMap.remove(oldPermission.getId());
        }
        this.create(processTemplateEntity, createPermissions);
        this.processTemplatePermissionRepository.saveAll(updatePermissions);
        processTemplateEntity.getPermissions().addAll(updatePermissions);
        if (!CollectionUtils.isEmpty(oldPermissionsMap)) {
            oldPermissionsMap.forEach((k, v) -> this.processTemplatePermissionRepository.delete(v));
        }
    }

    @Override
    public Set<ProcessTemplatePermissionEntity> findByProcessTemplateId(String templateId) {
        if (StringUtils.isBlank((CharSequence)templateId)) {
            return Sets.newHashSet();
        }
        return this.processTemplatePermissionRepository.findByProcessTemplateId(templateId);
    }
}

